/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.bukkit.item;

import com.google.gson.JsonElement;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import java.util.Objects;
import java.util.Optional;
import net.momirealms.craftengine.bukkit.nms.FastNMS;
import net.momirealms.craftengine.bukkit.plugin.reflection.minecraft.CoreReflections;
import net.momirealms.craftengine.bukkit.plugin.reflection.minecraft.MBuiltInRegistries;
import net.momirealms.craftengine.bukkit.plugin.reflection.minecraft.MRegistryOps;
import net.momirealms.craftengine.bukkit.util.ItemStackUtils;
import net.momirealms.craftengine.bukkit.util.KeyUtils;
import net.momirealms.craftengine.core.item.ItemWrapper;
import net.momirealms.craftengine.core.util.Key;
import net.momirealms.craftengine.core.util.VersionHelper;
import net.momirealms.craftengine.libraries.nbt.Tag;
import org.bukkit.inventory.ItemStack;

public class ComponentItemWrapper
implements ItemWrapper<ItemStack> {
    private final ItemStack item;
    private final Object handle;

    public ComponentItemWrapper(ItemStack item) {
        this.item = ItemStackUtils.ensureCraftItemStack(item);
        this.handle = FastNMS.INSTANCE.field$CraftItemStack$handle(this.item);
    }

    public ComponentItemWrapper(ItemStack item, int count) {
        this.item = ItemStackUtils.ensureCraftItemStack(item);
        this.item.setAmount(count);
        this.handle = FastNMS.INSTANCE.field$CraftItemStack$handle(this.item);
    }

    public void removeComponent(Object type) {
        FastNMS.INSTANCE.method$ItemStack$removeComponent(this.getLiteralObject(), this.ensureDataComponentType(type));
    }

    public void resetComponent(Object type) {
        Object item = FastNMS.INSTANCE.method$ItemStack$getItem(this.getLiteralObject());
        Object componentMap = FastNMS.INSTANCE.method$Item$components(item);
        Object componentType = this.ensureDataComponentType(type);
        Object defaultComponent = FastNMS.INSTANCE.method$DataComponentMap$get(componentMap, componentType);
        FastNMS.INSTANCE.method$ItemStack$setComponent(this.getLiteralObject(), componentType, defaultComponent);
    }

    public void setComponent(Object type, Object value) {
        if (value instanceof JsonElement) {
            JsonElement jsonElement = (JsonElement)value;
            this.setJsonComponent(type, jsonElement);
        } else if (CoreReflections.clazz$Tag.isInstance(value)) {
            this.setNBTComponent(type, value);
        } else if (value instanceof Tag) {
            Tag tag = (Tag)value;
            this.setSparrowNBTComponent(type, tag);
        } else {
            this.setJavaComponent(type, value);
        }
    }

    public Object getComponentExact(Object type) {
        return FastNMS.INSTANCE.method$ItemStack$getComponent(this.getLiteralObject(), this.ensureDataComponentType(type));
    }

    public <T> Optional<T> getJavaComponent(Object type) {
        return this.getComponentInternal(type, MRegistryOps.JAVA);
    }

    public Optional<JsonElement> getJsonComponent(Object type) {
        return this.getComponentInternal(type, MRegistryOps.JSON);
    }

    public Optional<Object> getNBTComponent(Object type) {
        return this.getComponentInternal(type, MRegistryOps.NBT);
    }

    public Optional<Tag> getSparrowNBTComponent(Object type) {
        Object componentType = this.ensureDataComponentType(type);
        Codec codec = FastNMS.INSTANCE.method$DataComponentType$codec(componentType);
        try {
            Object componentData = FastNMS.INSTANCE.method$ItemStack$getComponent(this.getLiteralObject(), componentType);
            if (componentData == null) {
                return Optional.empty();
            }
            DataResult result = codec.encodeStart(MRegistryOps.SPARROW_NBT, componentData);
            return result.result().map(Tag::copy);
        }
        catch (Throwable t) {
            throw new RuntimeException("Cannot read component " + type.toString(), t);
        }
    }

    private <T> Optional<T> getComponentInternal(Object type, DynamicOps ops) {
        Object componentType = this.ensureDataComponentType(type);
        Codec codec = FastNMS.INSTANCE.method$DataComponentType$codec(componentType);
        try {
            Object componentData = FastNMS.INSTANCE.method$ItemStack$getComponent(this.getLiteralObject(), componentType);
            if (componentData == null) {
                return Optional.empty();
            }
            DataResult result = codec.encodeStart(ops, componentData);
            return result.result();
        }
        catch (Throwable t) {
            throw new RuntimeException("Cannot read component " + type.toString(), t);
        }
    }

    public boolean hasComponent(Object type) {
        return FastNMS.INSTANCE.method$ItemStack$hasComponent(this.getLiteralObject(), this.ensureDataComponentType(type));
    }

    public boolean hasNonDefaultComponent(Object type) {
        Object componentType;
        if (VersionHelper.isOrAbove1_21_4()) {
            return FastNMS.INSTANCE.method$ItemStack$hasNonDefaultComponent(this.getLiteralObject(), this.ensureDataComponentType(type));
        }
        Object item = FastNMS.INSTANCE.method$ItemStack$getItem(this.getLiteralObject());
        Object componentMap = FastNMS.INSTANCE.method$Item$components(item);
        Object defaultComponent = FastNMS.INSTANCE.method$DataComponentMap$get(componentMap, componentType = this.ensureDataComponentType(type));
        return !Objects.equals(defaultComponent, this.getComponentExact(componentType));
    }

    public void setComponentExact(Object type, Object value) {
        FastNMS.INSTANCE.method$ItemStack$setComponent(this.getLiteralObject(), this.ensureDataComponentType(type), value);
    }

    public void setJavaComponent(Object type, Object value) {
        this.setComponentInternal(type, MRegistryOps.JAVA, value);
    }

    public void setJsonComponent(Object type, JsonElement value) {
        this.setComponentInternal(type, MRegistryOps.JSON, value);
    }

    public void setNBTComponent(Object type, Object value) {
        this.setComponentInternal(type, MRegistryOps.NBT, value);
    }

    public void setSparrowNBTComponent(Object type, Tag value) {
        this.setComponentInternal(type, MRegistryOps.SPARROW_NBT, value);
    }

    private void setComponentInternal(Object type, DynamicOps ops, Object value) {
        if (value == null) {
            return;
        }
        Object componentType = this.ensureDataComponentType(type);
        if (componentType == null) {
            return;
        }
        Codec codec = FastNMS.INSTANCE.method$DataComponentType$codec(componentType);
        try {
            DataResult result = codec.parse(ops, value);
            if (result.isError()) {
                throw new IllegalArgumentException(result.toString());
            }
            result.result().ifPresent(it -> FastNMS.INSTANCE.method$ItemStack$setComponent(this.getLiteralObject(), componentType, it));
        }
        catch (Throwable t) {
            throw new RuntimeException("Cannot parse component " + type.toString(), t);
        }
    }

    private Object ensureDataComponentType(Object type) {
        if (!CoreReflections.clazz$DataComponentType.isInstance(type)) {
            Key key = Key.of(type.toString());
            return FastNMS.INSTANCE.method$Registry$getValue(MBuiltInRegistries.DATA_COMPONENT_TYPE, KeyUtils.toResourceLocation(key));
        }
        return type;
    }

    @Override
    public ItemWrapper<ItemStack> copyWithCount(int count) {
        ItemStack copied = this.item.clone();
        copied.setAmount(count);
        return new ComponentItemWrapper(copied);
    }

    @Override
    public ItemStack getItem() {
        return this.item;
    }

    @Override
    public Object getLiteralObject() {
        return this.handle;
    }

    @Override
    public int count() {
        return this.item.getAmount();
    }

    @Override
    public void count(int amount) {
        this.item.setAmount(Math.max(amount, 0));
    }

    @Override
    public void shrink(int amount) {
        this.count(this.count() - amount);
    }
}

