/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.bukkit.nms.v1_20.loot;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootSerializer;
import net.minecraft.world.level.storage.loot.LootTableInfo;
import net.minecraft.world.level.storage.loot.entries.LootEntryType;
import net.minecraft.world.level.storage.loot.entries.LootSelectorEntry;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameters;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.momirealms.craftengine.bukkit.api.BukkitAdaptors;
import net.momirealms.craftengine.bukkit.item.BukkitItemManager;
import net.momirealms.craftengine.bukkit.plugin.user.BukkitServerPlayer;
import net.momirealms.craftengine.bukkit.util.KeyUtils;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class CraftEngineItem
extends LootSelectorEntry {
    public static final LootEntryType TYPE = new LootEntryType((LootSerializer)new Serializer());
    private final MinecraftKey item;

    public CraftEngineItem(MinecraftKey item, int weight, int quality, LootItemCondition[] conditions, LootItemFunction[] functions) {
        super(weight, quality, conditions, functions);
        this.item = item;
    }

    @NotNull
    public LootEntryType a() {
        return TYPE;
    }

    public void a(@NotNull Consumer<ItemStack> consumer, @NotNull LootTableInfo context) {
        Optional optionalCustomItem = BukkitItemManager.instance().getCustomItem(KeyUtils.resourceLocationToKey(this.item));
        if (optionalCustomItem.isEmpty()) {
            return;
        }
        BukkitServerPlayer serverPlayer = null;
        Object object = context.b(LootContextParameters.a);
        if (object instanceof EntityHuman) {
            EntityHuman player = (EntityHuman)object;
            serverPlayer = BukkitAdaptors.adapt((Player)player.getBukkitEntity());
        }
        consumer.accept((ItemStack)optionalCustomItem.get().buildItem(serverPlayer).getLiteralObject());
    }

    public static class Serializer
    extends LootSelectorEntry.e<CraftEngineItem> {
        public void serializeCustom(@NotNull JsonObject json, @NotNull CraftEngineItem entry, @NotNull JsonSerializationContext context) {
            super.a(json, (LootSelectorEntry)entry, context);
            json.addProperty("name", entry.item.toString());
        }

        @NotNull
        protected CraftEngineItem deserialize(JsonObject jsonObject, @NotNull JsonDeserializationContext jsonDeserializationContext, int i, int j, LootItemCondition @NotNull [] lootItemConditions, LootItemFunction @NotNull [] lootItemFunctions) {
            MinecraftKey resourceLocation = MinecraftKey.a((String)jsonObject.get("name").getAsString());
            return new CraftEngineItem(resourceLocation, i, j, lootItemConditions, lootItemFunctions);
        }
    }
}

