/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.bukkit.nms.v1_21.recipe;

import java.util.List;
import net.minecraft.core.NonNullList;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.ShapelessRecipe;
import net.minecraft.world.level.Level;
import net.momirealms.craftengine.bukkit.nms.v1_21.recipe.RecipeHelper;
import net.momirealms.craftengine.core.item.ItemBuildContext;
import net.momirealms.craftengine.core.item.recipe.CustomShapelessRecipe;
import net.momirealms.craftengine.core.item.recipe.input.RecipeInput;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

public class InjectedShapelessRecipe
extends ShapelessRecipe {
    private final CustomShapelessRecipe<ItemStack> recipe;

    public InjectedShapelessRecipe(CustomShapelessRecipe<ItemStack> recipe, String group, CraftingBookCategory category, net.minecraft.world.item.ItemStack result, NonNullList<Ingredient> ingredients) {
        super(group, category, result, ingredients);
        this.recipe = recipe;
    }

    public static InjectedShapelessRecipe of(CustomShapelessRecipe<ItemStack> recipe) {
        List<net.momirealms.craftengine.core.item.recipe.Ingredient<ItemStack>> ingredients = recipe.ingredientsInUse();
        NonNullList data = NonNullList.withSize((int)ingredients.size(), (Object)Ingredient.EMPTY);
        for (int i = 0; i < ingredients.size(); ++i) {
            data.set(i, (Object)RecipeHelper.toMinecraft(ingredients.get(i)));
        }
        return new InjectedShapelessRecipe(recipe, recipe.group(), RecipeHelper.toMinecraft(recipe.category()), (net.minecraft.world.item.ItemStack)recipe.result().buildItem(ItemBuildContext.EMPTY).getLiteralObject(), (NonNullList<Ingredient>)data);
    }

    public boolean matches(@NotNull CraftingInput input, @NotNull Level level) {
        boolean vanillaMatches = super.matches(input, level);
        if (!vanillaMatches) {
            return false;
        }
        return this.recipe.matches((RecipeInput)RecipeHelper.toCraftEngine(input));
    }

    @NotNull
    public NonNullList<net.minecraft.world.item.ItemStack> getRemainingItems(@NotNull CraftingInput input) {
        return RecipeHelper.getRemainingItems(input);
    }

    public boolean showNotification() {
        return this.recipe.showNotification();
    }
}

