/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.bukkit.nms.v1_21_5.recipe;

import com.google.common.collect.Maps;
import java.util.Map;
import net.minecraft.core.NonNullList;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.item.crafting.ShapedRecipePattern;
import net.minecraft.world.level.Level;
import net.momirealms.craftengine.bukkit.nms.v1_21_5.recipe.RecipeHelper;
import net.momirealms.craftengine.core.item.ItemBuildContext;
import net.momirealms.craftengine.core.item.recipe.CustomShapedRecipe;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

public class InjectedShapedRecipe
extends ShapedRecipe {
    private final CustomShapedRecipe<ItemStack> recipe;

    public InjectedShapedRecipe(CustomShapedRecipe<ItemStack> recipe, String group, CraftingBookCategory category, ShapedRecipePattern pattern, net.minecraft.world.item.ItemStack result, boolean showNotification) {
        super(group, category, pattern, result, showNotification);
        this.recipe = recipe;
    }

    public static InjectedShapedRecipe of(CustomShapedRecipe<ItemStack> recipe) {
        Map data = Maps.transformValues(recipe.pattern().ingredients(), RecipeHelper::toMinecraft);
        ShapedRecipePattern pattern = ShapedRecipePattern.of((Map)data, (String[])recipe.pattern().pattern());
        return new InjectedShapedRecipe(recipe, recipe.group(), RecipeHelper.toMinecraft(recipe.category()), pattern, (net.minecraft.world.item.ItemStack)recipe.result().buildItem(ItemBuildContext.EMPTY).getLiteralObject(), recipe.showNotification());
    }

    public boolean matches(@NotNull CraftingInput input, @NotNull Level level) {
        boolean vanillaMatches = super.matches(input, level);
        if (!vanillaMatches) {
            return false;
        }
        return this.recipe.matches(RecipeHelper.toCraftEngine(input));
    }

    @NotNull
    public NonNullList<net.minecraft.world.item.ItemStack> getRemainingItems(@NotNull CraftingInput input) {
        return RecipeHelper.getRemainingItems(input);
    }

    public boolean showNotification() {
        return this.recipe.showNotification();
    }
}

