/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.bukkit.plugin.command.feature;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.momirealms.craftengine.bukkit.plugin.BukkitCraftEngine;
import net.momirealms.craftengine.bukkit.plugin.command.BukkitCommandFeature;
import net.momirealms.craftengine.core.pack.Pack;
import net.momirealms.craftengine.core.plugin.CraftEngine;
import net.momirealms.craftengine.core.plugin.command.CraftEngineCommandManager;
import net.momirealms.craftengine.core.util.FileUtils;
import net.momirealms.craftengine.libraries.cloud.Command;
import net.momirealms.craftengine.libraries.cloud.CommandManager;
import org.bukkit.command.CommandSender;

public class DebugMigrateTemplatesCommand
extends BukkitCommandFeature<CommandSender> {
    private static final Pattern PATTERN = Pattern.compile("(?<!\\$)\\{([0-9a-zA-Z_]+)}");

    public DebugMigrateTemplatesCommand(CraftEngineCommandManager<CommandSender> commandManager, CraftEngine plugin) {
        super(commandManager, plugin);
    }

    @Override
    public Command.Builder<? extends CommandSender> assembleCommand(CommandManager<CommandSender> manager, Command.Builder<CommandSender> builder) {
        return builder.handler(context -> {
            for (Pack pack : BukkitCraftEngine.instance().packManager().loadedPacks()) {
                for (Path file : FileUtils.getYmlConfigsDeeply(pack.configurationFolder())) {
                    try {
                        Files.writeString(file, (CharSequence)DebugMigrateTemplatesCommand.replacePlaceholders(Files.readString(file)), new OpenOption[0]);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
            ((CommandSender)context.sender()).sendMessage("Done");
        });
    }

    @Override
    public String getFeatureID() {
        return "debug_migrate_templates";
    }

    private static String replacePlaceholders(String input) {
        if (input == null) {
            return null;
        }
        Matcher matcher = PATTERN.matcher(input);
        StringBuilder sb = new StringBuilder();
        while (matcher.find()) {
            matcher.appendReplacement(sb, "\\${" + matcher.group(1) + "}");
        }
        matcher.appendTail(sb);
        return sb.toString();
    }
}

