/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.bukkit.plugin.command.feature;

import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import net.momirealms.craftengine.bukkit.api.CraftEngineBlocks;
import net.momirealms.craftengine.bukkit.plugin.command.BukkitCommandFeature;
import net.momirealms.craftengine.core.block.ImmutableBlockState;
import net.momirealms.craftengine.core.block.UpdateOption;
import net.momirealms.craftengine.core.block.parser.BlockStateParser;
import net.momirealms.craftengine.core.plugin.CraftEngine;
import net.momirealms.craftengine.core.plugin.command.CraftEngineCommandManager;
import net.momirealms.craftengine.libraries.cloud.Command;
import net.momirealms.craftengine.libraries.cloud.CommandManager;
import net.momirealms.craftengine.libraries.cloud.bukkit.parser.location.LocationParser;
import net.momirealms.craftengine.libraries.cloud.context.CommandContext;
import net.momirealms.craftengine.libraries.cloud.context.CommandInput;
import net.momirealms.craftengine.libraries.cloud.parser.standard.StringParser;
import net.momirealms.craftengine.libraries.cloud.suggestion.Suggestion;
import net.momirealms.craftengine.libraries.cloud.suggestion.SuggestionProvider;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.checkerframework.checker.nullness.qual.NonNull;

public class DebugSetBlockCommand
extends BukkitCommandFeature<CommandSender> {
    public DebugSetBlockCommand(CraftEngineCommandManager<CommandSender> commandManager, CraftEngine plugin) {
        super(commandManager, plugin);
    }

    @Override
    public Command.Builder<? extends CommandSender> assembleCommand(CommandManager<CommandSender> manager, Command.Builder<CommandSender> builder) {
        return builder.required("location", LocationParser.locationParser()).required("id", StringParser.stringComponent((StringParser.StringMode)StringParser.StringMode.GREEDY_FLAG_YIELDING).suggestionProvider((SuggestionProvider)new SuggestionProvider<Object>(this){

            public @NonNull CompletableFuture<? extends @NonNull Iterable<? extends @NonNull Suggestion>> suggestionsFuture(@NonNull CommandContext<Object> context, @NonNull CommandInput input) {
                return CompletableFuture.completedFuture(BlockStateParser.fillSuggestions(input.input(), input.cursor()).stream().map(Suggestion::suggestion).collect(Collectors.toList()));
            }
        })).handler(context -> {
            String data = (String)context.get("id");
            ImmutableBlockState state = BlockStateParser.deserialize(data);
            if (state == null) {
                return;
            }
            Location location = (Location)context.get("location");
            CraftEngineBlocks.place(location, state, UpdateOption.UPDATE_ALL, false);
        });
    }

    @Override
    public String getFeatureID() {
        return "debug_set_block";
    }
}

