/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.bukkit.plugin.command.feature;

import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import net.momirealms.craftengine.bukkit.item.ComponentTypes;
import net.momirealms.craftengine.bukkit.plugin.command.BukkitCommandFeature;
import net.momirealms.craftengine.bukkit.util.PlayerUtils;
import net.momirealms.craftengine.core.item.CustomItem;
import net.momirealms.craftengine.core.item.Item;
import net.momirealms.craftengine.core.item.ItemBuildContext;
import net.momirealms.craftengine.core.item.ItemKeys;
import net.momirealms.craftengine.core.plugin.CraftEngine;
import net.momirealms.craftengine.core.plugin.command.CraftEngineCommandManager;
import net.momirealms.craftengine.core.plugin.command.FlagKeys;
import net.momirealms.craftengine.core.plugin.locale.MessageConstants;
import net.momirealms.craftengine.core.util.Key;
import net.momirealms.craftengine.core.util.VersionHelper;
import net.momirealms.craftengine.libraries.adventure.text.Component;
import net.momirealms.craftengine.libraries.cloud.Command;
import net.momirealms.craftengine.libraries.cloud.CommandManager;
import net.momirealms.craftengine.libraries.cloud.bukkit.data.MultiplePlayerSelector;
import net.momirealms.craftengine.libraries.cloud.bukkit.parser.NamespacedKeyParser;
import net.momirealms.craftengine.libraries.cloud.bukkit.parser.selector.MultiplePlayerSelectorParser;
import net.momirealms.craftengine.libraries.cloud.context.CommandContext;
import net.momirealms.craftengine.libraries.cloud.context.CommandInput;
import net.momirealms.craftengine.libraries.cloud.parser.flag.CommandFlag;
import net.momirealms.craftengine.libraries.cloud.suggestion.Suggestion;
import net.momirealms.craftengine.libraries.cloud.suggestion.SuggestionProvider;
import org.bukkit.NamespacedKey;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.checkerframework.checker.nullness.qual.NonNull;

public class TotemAnimationCommand
extends BukkitCommandFeature<CommandSender> {
    public TotemAnimationCommand(CraftEngineCommandManager<CommandSender> commandManager, CraftEngine plugin) {
        super(commandManager, plugin);
    }

    @Override
    public Command.Builder<? extends CommandSender> assembleCommand(CommandManager<CommandSender> manager, Command.Builder<CommandSender> builder) {
        return builder.flag(FlagKeys.SILENT_FLAG).required("players", MultiplePlayerSelectorParser.multiplePlayerSelectorParser()).required("id", NamespacedKeyParser.namespacedKeyComponent().suggestionProvider((SuggestionProvider)new SuggestionProvider<Object>(){

            public @NonNull CompletableFuture<? extends @NonNull Iterable<? extends @NonNull Suggestion>> suggestionsFuture(@NonNull CommandContext<Object> context, @NonNull CommandInput input) {
                return CompletableFuture.completedFuture(TotemAnimationCommand.this.plugin().itemManager().cachedTotemSuggestions());
            }
        })).flag(CommandFlag.builder((String)"sound_event").withComponent(NamespacedKeyParser.namespacedKeyParser()).build()).flag(CommandFlag.builder((String)"sound_location").withComponent(NamespacedKeyParser.namespacedKeyParser()).build()).handler(context -> {
            NamespacedKey namespacedKey = (NamespacedKey)context.get("id");
            Key key = Key.of(namespacedKey.namespace(), namespacedKey.value());
            CustomItem customItem = this.plugin().itemManager().getCustomItem(key).orElse(null);
            if (customItem == null || !VersionHelper.isOrAbove1_21_2() && customItem.material().equals(ItemKeys.TOTEM_OF_UNDYING)) {
                this.handleFeedback(context, MessageConstants.COMMAND_TOTEM_NOT_TOTEM, new Component[]{Component.text((String)key.toString())});
                return;
            }
            Item item = customItem.buildItem(ItemBuildContext.EMPTY);
            if (VersionHelper.isOrAbove1_21_2()) {
                if (context.flags().contains("sound_location")) {
                    String soundResourceLocation = context.flags().getValue("sound_location").get().toString();
                    if (soundResourceLocation != null) {
                        item.setComponent(ComponentTypes.DEATH_PROTECTION, Map.of("death_effects", List.of(Map.of("type", "play_sound", "sound", Map.of("sound_id", soundResourceLocation)))));
                    }
                } else if (context.flags().contains("sound_event")) {
                    String soundEvent = context.flags().getValue("sound_event").get().toString();
                    if (soundEvent != null) {
                        item.setComponent(ComponentTypes.DEATH_PROTECTION, Map.of("death_effects", List.of(Map.of("type", "play_sound", "sound", soundEvent))));
                    }
                } else {
                    item.setComponent(ComponentTypes.DEATH_PROTECTION, Map.of());
                }
            }
            ItemStack totemItem = (ItemStack)item.getItem();
            MultiplePlayerSelector selector = (MultiplePlayerSelector)context.get("players");
            for (Player player : selector.values()) {
                PlayerUtils.sendTotemAnimation(player, totemItem);
            }
        });
    }

    @Override
    public String getFeatureID() {
        return "totem_animation";
    }
}

