/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.bukkit.plugin.injector;

import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import net.momirealms.craftengine.bukkit.item.BukkitItemManager;
import net.momirealms.craftengine.bukkit.item.ComponentTypes;
import net.momirealms.craftengine.bukkit.nms.FastNMS;
import net.momirealms.craftengine.bukkit.plugin.reflection.minecraft.CoreReflections;
import net.momirealms.craftengine.bukkit.util.ItemTags;
import net.momirealms.craftengine.bukkit.util.KeyUtils;
import net.momirealms.craftengine.core.item.CustomItem;
import net.momirealms.craftengine.core.item.Item;
import net.momirealms.craftengine.core.item.ItemKeys;
import net.momirealms.craftengine.core.item.data.FireworkExplosion;
import net.momirealms.craftengine.core.util.Color;
import net.momirealms.craftengine.core.util.Key;
import net.momirealms.craftengine.core.util.ReflectionUtils;
import net.momirealms.craftengine.core.util.Tristate;
import net.momirealms.craftengine.core.util.VersionHelper;
import net.momirealms.craftengine.libraries.bytebuddy.ByteBuddy;
import net.momirealms.craftengine.libraries.bytebuddy.ClassFileVersion;
import net.momirealms.craftengine.libraries.bytebuddy.dynamic.scaffold.subclass.ConstructorStrategy;
import net.momirealms.craftengine.libraries.bytebuddy.implementation.Implementation;
import net.momirealms.craftengine.libraries.bytebuddy.implementation.MethodDelegation;
import net.momirealms.craftengine.libraries.bytebuddy.implementation.bind.annotation.AllArguments;
import net.momirealms.craftengine.libraries.bytebuddy.implementation.bind.annotation.RuntimeType;
import net.momirealms.craftengine.libraries.bytebuddy.matcher.ElementMatcher;
import net.momirealms.craftengine.libraries.bytebuddy.matcher.ElementMatchers;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class RecipeInjector {
    private static Class<?> clazz$InjectedArmorDyeRecipe;
    private static Class<?> clazz$InjectedRepairItemRecipe;
    private static Class<?> clazz$InjectedFireworkStarFadeRecipe;
    private static final Function<Object, Integer> INGREDIENT_SIZE_GETTER;
    private static final BiFunction<Object, Integer, Object> INGREDIENT_GETTER;
    private static final Function<Object, Boolean> REPAIR_INGREDIENT_COUNT_CHECKER;
    private static final Function<Object, Boolean> DYE_INGREDIENT_COUNT_CHECKER;
    private static final Predicate<Item<ItemStack>> IS_DYEABLE;

    public static void init() {
        ByteBuddy byteBuddy = new ByteBuddy(ClassFileVersion.JAVA_V17);
        ElementMatcher.Junction matches = (VersionHelper.isOrAbove1_21() ? ElementMatchers.takesArguments((Class[])new Class[]{CoreReflections.clazz$CraftingInput, CoreReflections.clazz$Level}) : ElementMatchers.takesArguments((Class[])new Class[]{CoreReflections.clazz$CraftingContainer, CoreReflections.clazz$Level})).and((ElementMatcher)ElementMatchers.returns(Boolean.TYPE));
        ElementMatcher.Junction assemble = (VersionHelper.isOrAbove1_21() ? ElementMatchers.takesArguments((Class[])new Class[]{CoreReflections.clazz$CraftingInput, CoreReflections.clazz$HolderLookup$Provider}) : (VersionHelper.isOrAbove1_20_5() ? ElementMatchers.takesArguments((Class[])new Class[]{CoreReflections.clazz$CraftingContainer, CoreReflections.clazz$HolderLookup$Provider}) : ElementMatchers.takesArguments((Class[])new Class[]{CoreReflections.clazz$CraftingContainer, CoreReflections.clazz$RegistryAccess}))).and((ElementMatcher)ElementMatchers.returns(CoreReflections.clazz$ItemStack));
        clazz$InjectedArmorDyeRecipe = byteBuddy.subclass(CoreReflections.clazz$ArmorDyeRecipe, (ConstructorStrategy)ConstructorStrategy.Default.IMITATE_SUPER_CLASS_OPENING).name("net.momirealms.craftengine.bukkit.item.recipe.ArmorDyeRecipe").method((ElementMatcher)matches).intercept((Implementation)MethodDelegation.to((Object)DyeMatchesInterceptor.INSTANCE)).method((ElementMatcher)assemble).intercept((Implementation)MethodDelegation.to((Object)DyeAssembleInterceptor.INSTANCE)).make().load(RecipeInjector.class.getClassLoader()).getLoaded();
        clazz$InjectedFireworkStarFadeRecipe = byteBuddy.subclass(CoreReflections.clazz$FireworkStarFadeRecipe).name("net.momirealms.craftengine.bukkit.item.recipe.FireworkStarFadeRecipe").method((ElementMatcher)matches).intercept((Implementation)MethodDelegation.to((Object)FireworkStarFadeMatchesInterceptor.INSTANCE)).method((ElementMatcher)assemble).intercept((Implementation)MethodDelegation.to((Object)FireworkStarFadeAssembleInterceptor.INSTANCE)).make().load(RecipeInjector.class.getClassLoader()).getLoaded();
        clazz$InjectedRepairItemRecipe = byteBuddy.subclass(CoreReflections.clazz$RepairItemRecipe, (ConstructorStrategy)ConstructorStrategy.Default.IMITATE_SUPER_CLASS_OPENING).name("net.momirealms.craftengine.bukkit.item.recipe.RepairItemRecipe").method((ElementMatcher)matches).intercept((Implementation)MethodDelegation.to((Object)RepairMatchesInterceptor.INSTANCE)).make().load(RecipeInjector.class.getClassLoader()).getLoaded();
    }

    public static Object createRepairItemRecipe(Key id) throws ReflectiveOperationException {
        return RecipeInjector.createSpecialRecipe(id, clazz$InjectedRepairItemRecipe);
    }

    public static Object createCustomDyeRecipe(Key id) throws ReflectiveOperationException {
        return RecipeInjector.createSpecialRecipe(id, clazz$InjectedArmorDyeRecipe);
    }

    public static Object createFireworkStarFadeRecipe(Key id) throws ReflectiveOperationException {
        return RecipeInjector.createSpecialRecipe(id, clazz$InjectedFireworkStarFadeRecipe);
    }

    @NotNull
    private static Object createSpecialRecipe(Key id, Class<?> clazz$InjectedRepairItemRecipe) throws InstantiationException, IllegalAccessException, InvocationTargetException {
        if (VersionHelper.isOrAbove1_20_2()) {
            Constructor<?> constructor = ReflectionUtils.getConstructor(clazz$InjectedRepairItemRecipe, CoreReflections.clazz$CraftingBookCategory);
            return constructor.newInstance(CoreReflections.instance$CraftingBookCategory$MISC);
        }
        Constructor<?> constructor = ReflectionUtils.getConstructor(clazz$InjectedRepairItemRecipe, CoreReflections.clazz$ResourceLocation, CoreReflections.clazz$CraftingBookCategory);
        return constructor.newInstance(KeyUtils.toResourceLocation(id), CoreReflections.instance$CraftingBookCategory$MISC);
    }

    @Nullable
    private static Pair<Item<ItemStack>, Item<ItemStack>> getItemsToCombine(Object input) {
        Item<ItemStack> item1 = null;
        Item<ItemStack> item2 = null;
        int size = INGREDIENT_SIZE_GETTER.apply(input);
        for (int i = 0; i < size; ++i) {
            Object itemStack = INGREDIENT_GETTER.apply(input, i);
            if (FastNMS.INSTANCE.method$ItemStack$isEmpty(itemStack)) continue;
            Item<ItemStack> wrapped = BukkitItemManager.instance().wrap(FastNMS.INSTANCE.method$CraftItemStack$asCraftMirror(itemStack));
            if (item1 == null) {
                item1 = wrapped;
                continue;
            }
            if (item2 != null) {
                return null;
            }
            item2 = wrapped;
        }
        if (item1 == null || item2 == null) {
            return null;
        }
        if (!RecipeInjector.canCombine(item1, item2)) {
            return null;
        }
        return new Pair(item1, item2);
    }

    private static boolean canCombine(Item<ItemStack> input1, Item<ItemStack> input2) {
        if (input1.count() != 1 || !RecipeInjector.isDamageableItem(input1)) {
            return false;
        }
        if (input2.count() != 1 || !RecipeInjector.isDamageableItem(input2)) {
            return false;
        }
        if (!input1.id().equals(input2.id())) {
            return false;
        }
        Optional<CustomItem<ItemStack>> customItem = input1.getCustomItem();
        return customItem.isEmpty() || customItem.get().settings().canRepair() != Tristate.FALSE;
    }

    private static boolean isDamageableItem(Item<ItemStack> item) {
        if (VersionHelper.isOrAbove1_20_5()) {
            return item.hasComponent(ComponentTypes.MAX_DAMAGE) && item.hasComponent(ComponentTypes.DAMAGE);
        }
        return FastNMS.INSTANCE.method$Item$canBeDepleted(FastNMS.INSTANCE.method$ItemStack$getItem(item.getLiteralObject()));
    }

    @Nullable
    private static Color getDyeColor(Item<ItemStack> dyeItem) {
        Optional<CustomItem<ItemStack>> optionalCustomItem = dyeItem.getCustomItem();
        if (optionalCustomItem.isPresent()) {
            CustomItem<ItemStack> customItem = optionalCustomItem.get();
            return Optional.ofNullable(customItem.settings().dyeColor()).orElseGet(() -> RecipeInjector.getVanillaDyeColor(dyeItem));
        }
        return RecipeInjector.getVanillaDyeColor(dyeItem);
    }

    @Nullable
    private static Color getFireworkColor(Item<ItemStack> dyeItem) {
        Optional<CustomItem<ItemStack>> optionalCustomItem = dyeItem.getCustomItem();
        if (optionalCustomItem.isPresent()) {
            CustomItem<ItemStack> customItem = optionalCustomItem.get();
            return Optional.ofNullable(customItem.settings().fireworkColor()).orElseGet(() -> RecipeInjector.getVanillaFireworkColor(dyeItem));
        }
        return RecipeInjector.getVanillaFireworkColor(dyeItem);
    }

    private static boolean isDyeable(Item<ItemStack> item) {
        Optional<CustomItem<ItemStack>> optionalCustomItem = item.getCustomItem();
        if (optionalCustomItem.isPresent()) {
            CustomItem<ItemStack> customItem = optionalCustomItem.get();
            if (customItem.settings().dyeable() == Tristate.FALSE) {
                return false;
            }
            if (customItem.settings().dyeable() == Tristate.TRUE) {
                return true;
            }
        }
        return IS_DYEABLE.test(item);
    }

    @Nullable
    private static Color getVanillaDyeColor(Item<ItemStack> item) {
        Object itemStack = item.getLiteralObject();
        Object dyeItem = FastNMS.INSTANCE.method$ItemStack$getItem(itemStack);
        if (!CoreReflections.clazz$DyeItem.isInstance(dyeItem)) {
            return null;
        }
        return Color.fromDecimal(FastNMS.INSTANCE.method$DyeColor$getTextureDiffuseColor(FastNMS.INSTANCE.method$DyeItem$getDyeColor(dyeItem)));
    }

    @Nullable
    private static Color getVanillaFireworkColor(Item<ItemStack> item) {
        Object itemStack = item.getLiteralObject();
        Object dyeItem = FastNMS.INSTANCE.method$ItemStack$getItem(itemStack);
        if (!CoreReflections.clazz$DyeItem.isInstance(dyeItem)) {
            return null;
        }
        return Color.fromDecimal(FastNMS.INSTANCE.method$DyeColor$getFireworkColor(FastNMS.INSTANCE.method$DyeItem$getDyeColor(dyeItem)));
    }

    private static boolean isArmorDye(Item<ItemStack> dyeItem) {
        Optional<CustomItem<ItemStack>> optionalCustomItem = dyeItem.getCustomItem();
        if (optionalCustomItem.isPresent()) {
            CustomItem<ItemStack> customItem = optionalCustomItem.get();
            return customItem.settings().dyeColor() != null || RecipeInjector.isVanillaDyeItem(dyeItem);
        }
        return RecipeInjector.isVanillaDyeItem(dyeItem);
    }

    private static boolean isFireworkDye(Item<ItemStack> dyeItem) {
        Optional<CustomItem<ItemStack>> optionalCustomItem = dyeItem.getCustomItem();
        if (optionalCustomItem.isPresent()) {
            CustomItem<ItemStack> customItem = optionalCustomItem.get();
            return customItem.settings().fireworkColor() != null || RecipeInjector.isVanillaDyeItem(dyeItem);
        }
        return RecipeInjector.isVanillaDyeItem(dyeItem);
    }

    private static boolean isVanillaDyeItem(Item<ItemStack> item) {
        return CoreReflections.clazz$DyeItem.isInstance(FastNMS.INSTANCE.method$ItemStack$getItem(item.getLiteralObject()));
    }

    static {
        Function<Object, Integer> function = VersionHelper.isOrAbove1_21() ? FastNMS.INSTANCE::method$CraftingInput$size : (INGREDIENT_SIZE_GETTER = FastNMS.INSTANCE::method$Container$getContainerSize);
        INGREDIENT_GETTER = VersionHelper.isOrAbove1_21() ? FastNMS.INSTANCE::method$CraftingInput$getItem : FastNMS.INSTANCE::method$Container$getItem;
        REPAIR_INGREDIENT_COUNT_CHECKER = VersionHelper.isOrAbove1_21() ? input -> FastNMS.INSTANCE.method$CraftingInput$ingredientCount(input) != 2 : container -> false;
        DYE_INGREDIENT_COUNT_CHECKER = VersionHelper.isOrAbove1_21() ? input -> FastNMS.INSTANCE.method$CraftingInput$ingredientCount(input) < 2 : container -> false;
        IS_DYEABLE = VersionHelper.isOrAbove1_20_5() ? item -> item.hasItemTag(ItemTags.DYEABLE) : item -> {
            Object itemLike = FastNMS.INSTANCE.method$ItemStack$getItem(item.getLiteralObject());
            return CoreReflections.clazz$DyeableLeatherItem.isInstance(itemLike);
        };
    }

    public static class DyeMatchesInterceptor {
        public static final DyeMatchesInterceptor INSTANCE = new DyeMatchesInterceptor();

        @RuntimeType
        public Object intercept(@AllArguments Object[] args) {
            Object input = args[0];
            if (DYE_INGREDIENT_COUNT_CHECKER.apply(input).booleanValue()) {
                return false;
            }
            int size = INGREDIENT_SIZE_GETTER.apply(input);
            Item<ItemStack> itemToDye = null;
            boolean hasDye = false;
            for (int i = 0; i < size; ++i) {
                Object itemStack = INGREDIENT_GETTER.apply(input, i);
                if (FastNMS.INSTANCE.method$ItemStack$isEmpty(itemStack)) continue;
                Item<ItemStack> wrapped = BukkitItemManager.instance().wrap(FastNMS.INSTANCE.method$CraftItemStack$asCraftMirror(itemStack));
                if (RecipeInjector.isDyeable(wrapped)) {
                    if (itemToDye != null) {
                        return false;
                    }
                    itemToDye = wrapped;
                    continue;
                }
                if (!RecipeInjector.isArmorDye(wrapped)) {
                    return false;
                }
                hasDye = true;
            }
            return hasDye && itemToDye != null;
        }
    }

    public static class DyeAssembleInterceptor {
        public static final DyeAssembleInterceptor INSTANCE = new DyeAssembleInterceptor();

        @RuntimeType
        public Object intercept(@AllArguments Object[] args) {
            ArrayList<Color> colors = new ArrayList<Color>();
            Item<ItemStack> itemToDye = null;
            Object input = args[0];
            int size = INGREDIENT_SIZE_GETTER.apply(input);
            for (int i = 0; i < size; ++i) {
                Object itemStack = INGREDIENT_GETTER.apply(input, i);
                if (FastNMS.INSTANCE.method$ItemStack$isEmpty(itemStack)) continue;
                Item<ItemStack> wrapped = BukkitItemManager.instance().wrap(FastNMS.INSTANCE.method$CraftItemStack$asCraftMirror(itemStack));
                if (RecipeInjector.isDyeable(wrapped)) {
                    itemToDye = wrapped.copyWithCount(1);
                    continue;
                }
                Color dyeColor = RecipeInjector.getDyeColor(wrapped);
                if (dyeColor != null) {
                    colors.add(dyeColor);
                    continue;
                }
                return CoreReflections.instance$ItemStack$EMPTY;
            }
            if (itemToDye == null || itemToDye.isEmpty() || colors.isEmpty()) {
                return CoreReflections.instance$ItemStack$EMPTY;
            }
            return itemToDye.applyDyedColors(colors).getLiteralObject();
        }
    }

    public static class FireworkStarFadeMatchesInterceptor {
        public static final FireworkStarFadeMatchesInterceptor INSTANCE = new FireworkStarFadeMatchesInterceptor();

        @RuntimeType
        public Object intercept(@AllArguments Object[] args) {
            Object input = args[0];
            if (DYE_INGREDIENT_COUNT_CHECKER.apply(input).booleanValue()) {
                return false;
            }
            boolean hasDye = false;
            boolean hasFireworkStar = false;
            int size = INGREDIENT_SIZE_GETTER.apply(input);
            for (int i = 0; i < size; ++i) {
                Object itemStack = INGREDIENT_GETTER.apply(input, i);
                if (FastNMS.INSTANCE.method$ItemStack$isEmpty(itemStack)) continue;
                Item<ItemStack> wrapped = BukkitItemManager.instance().wrap(FastNMS.INSTANCE.method$CraftItemStack$asCraftMirror(itemStack));
                if (RecipeInjector.isFireworkDye(wrapped)) {
                    hasDye = true;
                    continue;
                }
                if (!wrapped.id().equals(ItemKeys.FIREWORK_STAR)) {
                    return false;
                }
                if (hasFireworkStar) {
                    return false;
                }
                hasFireworkStar = true;
            }
            return hasDye && hasFireworkStar;
        }
    }

    public static class FireworkStarFadeAssembleInterceptor {
        public static final FireworkStarFadeAssembleInterceptor INSTANCE = new FireworkStarFadeAssembleInterceptor();

        @RuntimeType
        public Object intercept(@AllArguments Object[] args) {
            IntArrayList colors = new IntArrayList();
            Item<ItemStack> starItem = null;
            Object input = args[0];
            int size = INGREDIENT_SIZE_GETTER.apply(input);
            for (int i = 0; i < size; ++i) {
                Object itemStack = INGREDIENT_GETTER.apply(input, i);
                if (FastNMS.INSTANCE.method$ItemStack$isEmpty(itemStack)) continue;
                Item<ItemStack> wrapped = BukkitItemManager.instance().wrap(FastNMS.INSTANCE.method$CraftItemStack$asCraftMirror(itemStack));
                if (RecipeInjector.isFireworkDye(wrapped)) {
                    Color color = RecipeInjector.getFireworkColor(wrapped);
                    if (color == null) {
                        return CoreReflections.instance$ItemStack$EMPTY;
                    }
                    colors.add(color.color());
                    continue;
                }
                if (!wrapped.id().equals(ItemKeys.FIREWORK_STAR)) continue;
                starItem = wrapped.copyWithCount(1);
            }
            if (starItem == null || colors.isEmpty()) {
                return CoreReflections.instance$ItemStack$EMPTY;
            }
            FireworkExplosion explosion = starItem.fireworkExplosion().orElse(FireworkExplosion.DEFAULT);
            starItem.fireworkExplosion(explosion.withFadeColors((IntList)colors));
            return starItem.getLiteralObject();
        }
    }

    public static class RepairMatchesInterceptor {
        public static final RepairMatchesInterceptor INSTANCE = new RepairMatchesInterceptor();

        @RuntimeType
        public Object intercept(@AllArguments Object[] args) {
            Object input = args[0];
            if (REPAIR_INGREDIENT_COUNT_CHECKER.apply(input).booleanValue()) {
                return false;
            }
            return RecipeInjector.getItemsToCombine(input) != null;
        }
    }
}

