/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.bukkit.util;

import io.netty.buffer.Unpooled;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.momirealms.craftengine.bukkit.nms.FastNMS;
import net.momirealms.craftengine.core.util.FriendlyByteBuf;

public final class TagUtils {
    private TagUtils() {
    }

    public static Object createUpdateTagsPacket(Map<Object, List<TagEntry>> tags) {
        Map registriesNetworkPayload = FastNMS.INSTANCE.method$TagNetworkSerialization$serializeTagsToNetwork();
        HashMap modified = new HashMap();
        for (Map.Entry payload : registriesNetworkPayload.entrySet()) {
            List<TagEntry> overrides = tags.get(payload.getKey());
            if (overrides == null || overrides.isEmpty()) {
                modified.put(payload.getKey(), payload.getValue());
                continue;
            }
            FriendlyByteBuf deserializeBuf = new FriendlyByteBuf(Unpooled.buffer());
            FastNMS.INSTANCE.method$TagNetworkSerialization$NetworkPayload$write(payload.getValue(), (Object)deserializeBuf);
            Map originalTags = deserializeBuf.readMap(FriendlyByteBuf::readUtf, FriendlyByteBuf::readIntIdList);
            HashMap<Integer, List> reversedTags = new HashMap<Integer, List>();
            for (Map.Entry entry : originalTags.entrySet()) {
                IntListIterator intListIterator = ((IntList)entry.getValue()).iterator();
                while (intListIterator.hasNext()) {
                    int id = (Integer)intListIterator.next();
                    reversedTags.computeIfAbsent(id, k -> new ArrayList()).add((String)entry.getKey());
                }
            }
            for (TagEntry tagEntry : overrides) {
                reversedTags.remove(tagEntry.id);
                for (String tag : tagEntry.tags) {
                    reversedTags.computeIfAbsent(tagEntry.id, k -> new ArrayList()).add(tag);
                }
            }
            HashMap<String, IntList> processedTags = new HashMap<String, IntList>();
            for (Map.Entry tagEntry3 : reversedTags.entrySet()) {
                for (String tag : (List)tagEntry3.getValue()) {
                    processedTags.computeIfAbsent(tag, k -> new IntArrayList()).addLast((Object)((Integer)tagEntry3.getKey()));
                }
            }
            FriendlyByteBuf friendlyByteBuf = new FriendlyByteBuf(Unpooled.buffer());
            friendlyByteBuf.writeMap(processedTags, FriendlyByteBuf::writeUtf, FriendlyByteBuf::writeIntIdList);
            Object mergedPayload = FastNMS.INSTANCE.method$TagNetworkSerialization$NetworkPayload$read((Object)friendlyByteBuf);
            modified.put(payload.getKey(), mergedPayload);
        }
        return FastNMS.INSTANCE.constructor$ClientboundUpdateTagsPacket(modified);
    }

    public record TagEntry(int id, List<String> tags) {
    }
}

