/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.core.block;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import net.momirealms.craftengine.core.block.BlockManager;
import net.momirealms.craftengine.core.block.BlockSettings;
import net.momirealms.craftengine.core.block.BlockStateVariant;
import net.momirealms.craftengine.core.block.BlockStateWrapper;
import net.momirealms.craftengine.core.block.CustomBlock;
import net.momirealms.craftengine.core.block.DelegatingBlock;
import net.momirealms.craftengine.core.block.ImmutableBlockState;
import net.momirealms.craftengine.core.block.properties.Properties;
import net.momirealms.craftengine.core.block.properties.Property;
import net.momirealms.craftengine.core.loot.LootTable;
import net.momirealms.craftengine.core.pack.Pack;
import net.momirealms.craftengine.core.pack.ResourceLocation;
import net.momirealms.craftengine.core.pack.model.generation.AbstractModelGenerator;
import net.momirealms.craftengine.core.pack.model.generation.ModelGeneration;
import net.momirealms.craftengine.core.plugin.CraftEngine;
import net.momirealms.craftengine.core.plugin.config.Config;
import net.momirealms.craftengine.core.plugin.config.ConfigParser;
import net.momirealms.craftengine.core.plugin.context.event.EventFunctions;
import net.momirealms.craftengine.core.plugin.locale.LocalizedResourceConfigException;
import net.momirealms.craftengine.core.util.GsonHelper;
import net.momirealms.craftengine.core.util.Key;
import net.momirealms.craftengine.core.util.MiscUtils;
import net.momirealms.craftengine.core.util.ResourceConfigUtils;
import net.momirealms.craftengine.libraries.cloud.suggestion.Suggestion;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractBlockManager
extends AbstractModelGenerator
implements BlockManager {
    protected final BlockParser blockParser;
    protected final Map<Key, CustomBlock> byId = new HashMap<Key, CustomBlock>();
    protected final List<Suggestion> cachedSuggestions = new ArrayList<Suggestion>();
    protected final Set<String> namespacesInUse = new HashSet<String>();
    protected final Map<Key, JsonElement> modBlockStates = new HashMap<Key, JsonElement>();
    protected final Map<Integer, JsonElement> tempVanillaBlockStateModels = new Int2ObjectOpenHashMap();
    protected final Map<Integer, Key> tempRegistryIdConflictMap = new Int2ObjectOpenHashMap();
    protected final Map<Integer, Integer> tempBlockAppearanceConvertor = new Int2IntOpenHashMap();
    protected final Map<Key, Map<String, JsonElement>> blockStateOverrides = new HashMap<Key, Map<String, JsonElement>>();
    protected final Map<Integer, List<Integer>> appearanceToRealState = new Int2ObjectOpenHashMap();
    protected Map<Integer, List<String>> clientBoundTags = Map.of();
    protected Map<Integer, List<String>> previousClientBoundTags = Map.of();
    protected Map<Key, List<Integer>> blockAppearanceArranger;
    protected Map<Key, List<Integer>> realBlockArranger;
    protected Map<Key, Integer> internalId2StateId;
    protected Map<Key, DelegatingBlock> registeredBlocks;

    protected AbstractBlockManager(CraftEngine plugin) {
        super(plugin);
        this.blockParser = new BlockParser();
    }

    @Override
    public void unload() {
        super.clearModelsToGenerate();
        this.clearCache();
        this.cachedSuggestions.clear();
        this.blockStateOverrides.clear();
        this.modBlockStates.clear();
        this.byId.clear();
        this.previousClientBoundTags = this.clientBoundTags;
        this.clientBoundTags = new HashMap<Integer, List<String>>();
        this.appearanceToRealState.clear();
    }

    @Override
    public void delayedLoad() {
        this.initSuggestions();
        this.clearCache();
        this.resendTags();
    }

    @Override
    public Map<Key, CustomBlock> blocks() {
        return Collections.unmodifiableMap(this.byId);
    }

    @Override
    public Optional<CustomBlock> blockById(Key id) {
        return Optional.ofNullable(this.byId.get(id));
    }

    protected void addBlockInternal(Key id, CustomBlock customBlock) {
        this.byId.put(id, customBlock);
        if (Config.generateModAssets()) {
            for (ImmutableBlockState state : customBlock.variantProvider().states()) {
                this.modBlockStates.put(this.getBlockOwnerId(state.customBlockState()), this.tempVanillaBlockStateModels.get(state.vanillaBlockState().registryId()));
            }
        }
    }

    @Override
    public ConfigParser parser() {
        return this.blockParser;
    }

    @Override
    public Map<Key, JsonElement> modBlockStates() {
        return Collections.unmodifiableMap(this.modBlockStates);
    }

    @Override
    public Map<Key, Map<String, JsonElement>> blockOverrides() {
        return Collections.unmodifiableMap(this.blockStateOverrides);
    }

    @Override
    public Collection<Suggestion> cachedSuggestions() {
        return Collections.unmodifiableCollection(this.cachedSuggestions);
    }

    public Set<String> namespacesInUse() {
        return Collections.unmodifiableSet(this.namespacesInUse);
    }

    protected void clearCache() {
        this.tempRegistryIdConflictMap.clear();
        this.tempBlockAppearanceConvertor.clear();
        this.tempVanillaBlockStateModels.clear();
    }

    protected void initSuggestions() {
        this.cachedSuggestions.clear();
        this.namespacesInUse.clear();
        HashSet<String> states = new HashSet<String>();
        for (CustomBlock block : this.byId.values()) {
            states.add(block.id().toString());
            this.namespacesInUse.add(block.id().namespace());
            for (ImmutableBlockState state : block.variantProvider().states()) {
                states.add(state.toString());
            }
        }
        for (String state : states) {
            this.cachedSuggestions.add(Suggestion.suggestion((String)state));
        }
    }

    @NotNull
    public List<Integer> appearanceToRealStates(int appearanceStateId) {
        return Optional.ofNullable(this.appearanceToRealState.get(appearanceStateId)).orElse(List.of());
    }

    protected abstract void resendTags();

    protected abstract boolean isVanillaBlock(Key var1);

    protected abstract int getBlockRegistryId(Key var1);

    protected abstract String stateRegistryIdToStateSNBT(int var1);

    protected abstract Key getBlockOwnerId(int var1);

    protected abstract CustomBlock.Builder platformBuilder(Key var1);

    public class BlockParser
    implements ConfigParser {
        public static final String[] CONFIG_SECTION_NAME = new String[]{"blocks", "block"};

        @Override
        public String[] sectionId() {
            return CONFIG_SECTION_NAME;
        }

        @Override
        public int loadingSequence() {
            return 40;
        }

        @Override
        public void parseSection(Pack pack, Path path, Key id, Map<String, Object> section) {
            if (AbstractBlockManager.this.isVanillaBlock(id)) {
                this.parseVanillaBlock(pack, path, id, section);
            } else {
                if (AbstractBlockManager.this.byId.containsKey(id)) {
                    throw new LocalizedResourceConfigException("warning.config.block.duplicate", new String[0]);
                }
                this.parseCustomBlock(pack, path, id, section);
            }
        }

        private void parseVanillaBlock(Pack pack, Path path, Key id, Map<String, Object> section) {
            Object clientBoundTags;
            Map<String, Object> settings = MiscUtils.castToMap(section.get("settings"), true);
            if (settings != null && (clientBoundTags = settings.get("client-bound-tags")) instanceof List) {
                List list = (List)clientBoundTags;
                List<String> clientSideTags = MiscUtils.getAsStringList(list).stream().filter(ResourceLocation::isValid).toList();
                AbstractBlockManager.this.clientBoundTags.put(AbstractBlockManager.this.getBlockRegistryId(id), clientSideTags);
            }
        }

        private void parseCustomBlock(Pack pack, Path path, Key id, Map<String, Object> section) {
            Map<String, BlockStateVariant> variants;
            Map<String, Integer> appearances;
            Map<String, Property<Object>> properties;
            boolean singleState;
            BlockSettings settings = BlockSettings.fromMap(id, MiscUtils.castToMap(section.get("settings"), true));
            Map<String, Object> stateSection = MiscUtils.castToMap(ResourceConfigUtils.requireNonNullOrThrow(ResourceConfigUtils.get(section, "state", "states"), "warning.config.block.missing_state"), true);
            boolean bl = singleState = !stateSection.containsKey("properties");
            if (singleState) {
                int internalId = ResourceConfigUtils.getAsInt(ResourceConfigUtils.requireNonNullOrThrow(stateSection.get("id"), "warning.config.block.state.missing_real_id"), "id");
                int appearanceId = this.pluginFormattedBlockStateToRegistryId(ResourceConfigUtils.requireNonEmptyStringOrThrow(stateSection.get("state"), "warning.config.block.state.missing_state"));
                this.arrangeModelForStateAndVerify(appearanceId, ResourceConfigUtils.get(stateSection, "model", "models"));
                properties = Map.of();
                appearances = Map.of("", appearanceId);
                variants = Map.of("", new BlockStateVariant("", settings, this.getInternalBlockId(internalId, appearanceId)));
            } else {
                properties = this.parseBlockProperties(ResourceConfigUtils.getAsMap(ResourceConfigUtils.requireNonNullOrThrow(stateSection.get("properties"), "warning.config.block.state.missing_properties"), "properties"));
                appearances = this.parseBlockAppearances(ResourceConfigUtils.getAsMap(ResourceConfigUtils.requireNonNullOrThrow(stateSection.get("appearances"), "warning.config.block.state.missing_appearances"), "appearances"));
                variants = this.parseBlockVariants(ResourceConfigUtils.getAsMap(ResourceConfigUtils.requireNonNullOrThrow(stateSection.get("variants"), "warning.config.block.state.missing_variants"), "variants"), it -> appearances.getOrDefault(it, -1), settings);
            }
            AbstractBlockManager.this.addBlockInternal(id, AbstractBlockManager.this.platformBuilder(id).appearances(appearances).variantMapper(variants).properties(properties).settings(settings).lootTable(LootTable.fromMap(ResourceConfigUtils.getAsMapOrNull(section.get("loot"), "loot"))).behavior(MiscUtils.getAsMapList(ResourceConfigUtils.get(section, "behavior", "behaviors"))).events(EventFunctions.parseEvents(ResourceConfigUtils.get(section, "events", "event"))).build());
        }

        private Map<String, BlockStateVariant> parseBlockVariants(Map<String, Object> variantsSection, Function<String, Integer> appearanceValidator, BlockSettings parentSettings) {
            HashMap<String, BlockStateVariant> variants = new HashMap<String, BlockStateVariant>();
            for (Map.Entry<String, Object> entry : variantsSection.entrySet()) {
                Map<String, Object> variantSection = ResourceConfigUtils.getAsMap(entry.getValue(), entry.getKey());
                String variantNBT = entry.getKey();
                String appearance = ResourceConfigUtils.requireNonEmptyStringOrThrow(variantSection.get("appearance"), "warning.config.block.state.variant.missing_appearance");
                int appearanceId = appearanceValidator.apply(appearance);
                if (appearanceId == -1) {
                    throw new LocalizedResourceConfigException("warning.config.block.state.variant.invalid_appearance", variantNBT, appearance);
                }
                int internalId = this.getInternalBlockId(ResourceConfigUtils.getAsInt(ResourceConfigUtils.requireNonNullOrThrow(variantSection.get("id"), "warning.config.block.state.missing_real_id"), "id"), appearanceId);
                Map<String, Object> anotherSetting = ResourceConfigUtils.getAsMapOrNull(variantSection.get("settings"), "settings");
                variants.put(variantNBT, new BlockStateVariant(appearance, anotherSetting == null ? parentSettings : BlockSettings.ofFullCopy(parentSettings, anotherSetting), internalId));
            }
            return variants;
        }

        private int getInternalBlockId(int internalId, int appearanceId) {
            Key baseBlock = AbstractBlockManager.this.getBlockOwnerId(appearanceId);
            Key internalBlockId = Key.of("craftengine", baseBlock.value() + "_" + internalId);
            int internalBlockRegistryId = Optional.ofNullable(AbstractBlockManager.this.internalId2StateId.get(internalBlockId)).orElse(-1);
            if (internalBlockRegistryId == -1) {
                throw new LocalizedResourceConfigException("warning.config.block.state.invalid_real_id", internalBlockId.toString(), String.valueOf(AbstractBlockManager.this.availableAppearances(baseBlock) - 1));
            }
            return internalBlockRegistryId;
        }

        private Map<String, Integer> parseBlockAppearances(Map<String, Object> appearancesSection) {
            HashMap<String, Integer> appearances = new HashMap<String, Integer>();
            for (Map.Entry<String, Object> entry : appearancesSection.entrySet()) {
                Map<String, Object> appearanceSection = ResourceConfigUtils.getAsMap(entry.getValue(), entry.getKey());
                int appearanceId = this.pluginFormattedBlockStateToRegistryId(ResourceConfigUtils.requireNonEmptyStringOrThrow(appearanceSection.get("state"), "warning.config.block.state.missing_state"));
                this.arrangeModelForStateAndVerify(appearanceId, ResourceConfigUtils.get(appearanceSection, "model", "models"));
                appearances.put(entry.getKey(), appearanceId);
            }
            return appearances;
        }

        @NotNull
        private Map<String, Property<?>> parseBlockProperties(Map<String, Object> propertiesSection) {
            HashMap properties = new HashMap();
            for (Map.Entry<String, Object> entry : propertiesSection.entrySet()) {
                Property<?> property = Properties.fromMap(entry.getKey(), ResourceConfigUtils.getAsMap(entry.getValue(), entry.getKey()));
                properties.put(entry.getKey(), property);
            }
            return properties;
        }

        private void arrangeModelForStateAndVerify(int registryId, Object modelOrModels) {
            List<JsonObject> variants;
            if (modelOrModels == null) {
                return;
            }
            if (modelOrModels instanceof String) {
                String model = (String)modelOrModels;
                JsonObject json = new JsonObject();
                json.addProperty("model", model);
                variants = Collections.singletonList(json);
            } else {
                variants = ResourceConfigUtils.parseConfigAsList(modelOrModels, this::parseAppearanceModelSectionAsJson);
                if (variants.isEmpty()) {
                    return;
                }
            }
            String blockState = AbstractBlockManager.this.stateRegistryIdToStateSNBT(registryId);
            Key blockId = Key.of(blockState.substring(blockState.indexOf(123) + 1, blockState.lastIndexOf(125)));
            String propertyNBT = blockState.substring(blockState.indexOf(91) + 1, blockState.lastIndexOf(93));
            JsonElement combinedVariant = GsonHelper.combine(variants);
            Map overrideMap = AbstractBlockManager.this.blockStateOverrides.computeIfAbsent(blockId, k -> new HashMap());
            JsonElement previous = (JsonElement)overrideMap.get(propertyNBT);
            if (previous != null && !previous.equals(combinedVariant)) {
                throw new LocalizedResourceConfigException("warning.config.block.state.model.conflict", GsonHelper.get().toJson(combinedVariant), blockState, GsonHelper.get().toJson(previous));
            }
            overrideMap.put(propertyNBT, combinedVariant);
        }

        private JsonObject parseAppearanceModelSectionAsJson(Map<String, Object> section) {
            Map<String, Object> generationMap;
            JsonObject json = new JsonObject();
            String modelPath = ResourceConfigUtils.requireNonEmptyStringOrThrow(section.get("path"), "warning.config.block.state.model.missing_path");
            if (!ResourceLocation.isValid(modelPath)) {
                throw new LocalizedResourceConfigException("warning.config.block.state.model.invalid_path", modelPath);
            }
            json.addProperty("model", modelPath);
            if (section.containsKey("x")) {
                json.addProperty("x", (Number)ResourceConfigUtils.getAsInt(section.get("x"), "x"));
            }
            if (section.containsKey("y")) {
                json.addProperty("y", (Number)ResourceConfigUtils.getAsInt(section.get("y"), "y"));
            }
            if (section.containsKey("uvlock")) {
                json.addProperty("uvlock", Boolean.valueOf(ResourceConfigUtils.getAsBoolean(section.get("uvlock"), "uvlock")));
            }
            if (section.containsKey("weight")) {
                json.addProperty("weight", (Number)ResourceConfigUtils.getAsInt(section.get("weight"), "weight"));
            }
            if ((generationMap = MiscUtils.castToMap(section.get("generation"), true)) != null) {
                AbstractBlockManager.this.prepareModelGeneration(ModelGeneration.of(Key.of(modelPath), generationMap));
            }
            return json;
        }

        private int pluginFormattedBlockStateToRegistryId(String blockState) {
            int registryId;
            String[] split = blockState.split(":", 3);
            if (split.length >= 4) {
                throw new LocalizedResourceConfigException("warning.config.block.state.invalid_vanilla", blockState);
            }
            String stateOrId = split[split.length - 1];
            boolean isId = false;
            int arrangerIndex = 0;
            try {
                arrangerIndex = Integer.parseInt(stateOrId);
                if (arrangerIndex < 0) {
                    throw new LocalizedResourceConfigException("warning.config.block.state.invalid_vanilla", blockState);
                }
                isId = true;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (isId) {
                if (split.length == 1) {
                    throw new LocalizedResourceConfigException("warning.config.block.state.invalid_vanilla", blockState);
                }
                Key block = split.length == 2 ? Key.of(split[0]) : Key.of(split[0], split[1]);
                try {
                    List<Integer> arranger = AbstractBlockManager.this.blockAppearanceArranger.get(block);
                    if (arranger == null) {
                        throw new LocalizedResourceConfigException("warning.config.block.state.unavailable_vanilla", blockState);
                    }
                    if (arrangerIndex >= arranger.size()) {
                        throw new LocalizedResourceConfigException("warning.config.block.state.invalid_vanilla_id", blockState, String.valueOf(arranger.size() - 1));
                    }
                    registryId = arranger.get(arrangerIndex);
                }
                catch (NumberFormatException e) {
                    throw new LocalizedResourceConfigException("warning.config.block.state.invalid_vanilla", e, blockState);
                }
            } else {
                BlockStateWrapper packedBlockState = AbstractBlockManager.this.createPackedBlockState(blockState);
                if (packedBlockState == null || !packedBlockState.isVanillaBlock()) {
                    throw new LocalizedResourceConfigException("warning.config.block.state.invalid_vanilla", blockState);
                }
                registryId = packedBlockState.registryId();
            }
            return registryId;
        }
    }
}

