/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.core.entity.furniture;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.momirealms.craftengine.core.entity.furniture.AnchorType;
import net.momirealms.craftengine.core.entity.furniture.CustomFurniture;
import net.momirealms.craftengine.core.entity.furniture.FurnitureSettings;
import net.momirealms.craftengine.core.loot.LootTable;
import net.momirealms.craftengine.core.plugin.context.PlayerOptionalContext;
import net.momirealms.craftengine.core.plugin.context.event.EventTrigger;
import net.momirealms.craftengine.core.plugin.context.function.Function;
import net.momirealms.craftengine.core.util.Key;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractCustomFurniture
implements CustomFurniture {
    private final Key id;
    private final FurnitureSettings settings;
    private final Map<AnchorType, CustomFurniture.Placement> placements;
    private final Map<EventTrigger, List<Function<PlayerOptionalContext>>> events;
    @Nullable
    private final LootTable<?> lootTable;
    private final AnchorType anyType;

    protected AbstractCustomFurniture(@NotNull Key id, @NotNull FurnitureSettings settings, @NotNull Map<AnchorType, CustomFurniture.Placement> placements, @NotNull Map<EventTrigger, List<Function<PlayerOptionalContext>>> events, @Nullable LootTable<?> lootTable) {
        this.id = id;
        this.settings = settings;
        this.placements = placements;
        this.lootTable = lootTable;
        this.events = events;
        this.anyType = placements.keySet().stream().findFirst().orElse(null);
    }

    @Override
    public void execute(PlayerOptionalContext context, EventTrigger trigger) {
        for (Function function : Optional.ofNullable(this.events.get((Object)trigger)).orElse(Collections.emptyList())) {
            function.run(context);
        }
    }

    @Override
    public Key id() {
        return this.id;
    }

    @Override
    public Map<AnchorType, CustomFurniture.Placement> placements() {
        return this.placements;
    }

    @Override
    public FurnitureSettings settings() {
        return this.settings;
    }

    @Override
    @Nullable
    public LootTable<?> lootTable() {
        return this.lootTable;
    }

    @Override
    public AnchorType getAnyAnchorType() {
        return this.anyType;
    }

    @Override
    public boolean isAllowedPlacement(AnchorType anchorType) {
        return this.placements.containsKey((Object)anchorType);
    }

    @Override
    public CustomFurniture.Placement getPlacement(AnchorType anchorType) {
        return this.placements.get((Object)anchorType);
    }

    @Override
    public CustomFurniture.Placement getValidPlacement(AnchorType anchorType) {
        CustomFurniture.Placement placement = this.placements.get((Object)anchorType);
        if (placement == null) {
            return this.placements.get((Object)this.getAnyAnchorType());
        }
        return placement;
    }
}

