/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.core.font;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.imageio.ImageIO;
import net.momirealms.craftengine.core.entity.player.Player;
import net.momirealms.craftengine.core.font.BitmapImage;
import net.momirealms.craftengine.core.font.Emoji;
import net.momirealms.craftengine.core.font.EmojiComponentProcessResult;
import net.momirealms.craftengine.core.font.EmojiParameters;
import net.momirealms.craftengine.core.font.EmojiTextProcessResult;
import net.momirealms.craftengine.core.font.Font;
import net.momirealms.craftengine.core.font.FontManager;
import net.momirealms.craftengine.core.font.FontTagFormatter;
import net.momirealms.craftengine.core.font.IllegalCharacterProcessResult;
import net.momirealms.craftengine.core.font.OffsetFont;
import net.momirealms.craftengine.core.pack.Pack;
import net.momirealms.craftengine.core.pack.ResourceLocation;
import net.momirealms.craftengine.core.plugin.CraftEngine;
import net.momirealms.craftengine.core.plugin.config.ConfigParser;
import net.momirealms.craftengine.core.plugin.context.ContextHolder;
import net.momirealms.craftengine.core.plugin.context.PlayerOptionalContext;
import net.momirealms.craftengine.core.plugin.locale.LocalizedResourceConfigException;
import net.momirealms.craftengine.core.util.AdventureHelper;
import net.momirealms.craftengine.core.util.CharacterUtils;
import net.momirealms.craftengine.core.util.Key;
import net.momirealms.craftengine.core.util.MiscUtils;
import net.momirealms.craftengine.core.util.ResourceConfigUtils;
import net.momirealms.craftengine.libraries.adventure.text.Component;
import net.momirealms.craftengine.libraries.adventure.text.ComponentLike;
import net.momirealms.craftengine.libraries.ahocorasick.trie.Token;
import net.momirealms.craftengine.libraries.ahocorasick.trie.Trie;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractFontManager
implements FontManager {
    private final CraftEngine plugin;
    private final Map<Key, Font> fonts = new HashMap<Key, Font>();
    private final Map<Key, Emoji> emojis = new HashMap<Key, Emoji>();
    private final Map<Key, BitmapImage> images = new HashMap<Key, BitmapImage>();
    private final Set<Integer> illegalChars = new HashSet<Integer>();
    private final ImageParser imageParser;
    private final EmojiParser emojiParser;
    private OffsetFont offsetFont;
    protected Trie imageTagTrie;
    protected Trie emojiKeywordTrie;
    protected Map<String, Component> tagMapper;
    protected Map<String, Emoji> emojiMapper;
    protected List<Emoji> emojiList;
    protected List<String> allEmojiSuggestions;

    public AbstractFontManager(CraftEngine plugin) {
        this.plugin = plugin;
        this.imageParser = new ImageParser();
        this.emojiParser = new EmojiParser();
    }

    @Override
    public void load() {
        this.offsetFont = Optional.ofNullable(this.plugin.config().settings().getSection("image.offset-characters")).map(OffsetFont::new).orElse(null);
    }

    @Override
    public void unload() {
        this.fonts.clear();
        this.images.clear();
        this.illegalChars.clear();
        this.emojis.clear();
    }

    @Override
    public void disable() {
        this.unload();
    }

    @Override
    public ConfigParser[] parsers() {
        return new ConfigParser[]{this.imageParser, this.emojiParser};
    }

    @Override
    public void delayedLoad() {
        Optional.ofNullable(this.fonts.get(DEFAULT_FONT)).ifPresent(font -> this.illegalChars.addAll(font.codepointsInUse()));
        this.buildImageTagTrie();
        this.buildEmojiKeywordsTrie();
        this.emojiList = new ArrayList<Emoji>(this.emojis.values());
        this.allEmojiSuggestions = this.emojis.values().stream().flatMap(emoji -> emoji.keywords().stream()).collect(Collectors.toList());
    }

    @Override
    public Map<String, Component> matchTags(String json) {
        if (this.imageTagTrie == null) {
            return Collections.emptyMap();
        }
        HashMap<String, Component> tags = new HashMap<String, Component>();
        for (Token token : this.imageTagTrie.tokenize(json)) {
            if (!token.isMatch()) continue;
            tags.put(token.getFragment(), this.tagMapper.get(token.getFragment()));
        }
        return tags;
    }

    @Override
    public EmojiTextProcessResult replaceMiniMessageEmoji(@NotNull String miniMessage, Player player, int maxTimes) {
        if (this.emojiKeywordTrie == null || maxTimes <= 0) {
            return EmojiTextProcessResult.notReplaced(miniMessage);
        }
        HashMap<String, String> replacements = new HashMap<String, String>();
        for (Token token : this.emojiKeywordTrie.tokenize(miniMessage)) {
            Emoji emoji;
            String fragment;
            if (!token.isMatch() || replacements.containsKey(fragment = token.getFragment()) || (emoji = this.emojiMapper.get(fragment)) == null || player != null && emoji.permission() != null && !player.hasPermission(emoji.permission())) continue;
            Component content = AdventureHelper.miniMessage().deserialize(emoji.content(), PlayerOptionalContext.of(player, ContextHolder.builder().withOptionalParameter(EmojiParameters.EMOJI, emoji.emojiImage()).withParameter(EmojiParameters.KEYWORD, emoji.keywords().get(0))).tagResolvers());
            replacements.put(fragment, AdventureHelper.componentToMiniMessage(content));
        }
        if (replacements.isEmpty()) {
            return EmojiTextProcessResult.notReplaced(miniMessage);
        }
        String regex = replacements.keySet().stream().map(Pattern::quote).collect(Collectors.joining("|"));
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(miniMessage);
        StringBuilder sb = new StringBuilder();
        int count = 0;
        while (matcher.find() && count < maxTimes) {
            String key = matcher.group();
            String replacement = (String)replacements.get(key);
            if (replacement != null) {
                matcher.appendReplacement(sb, Matcher.quoteReplacement(replacement));
                ++count;
                continue;
            }
            matcher.appendReplacement(sb, Matcher.quoteReplacement(matcher.group()));
        }
        matcher.appendTail(sb);
        return EmojiTextProcessResult.replaced(sb.toString());
    }

    @Override
    public EmojiTextProcessResult replaceJsonEmoji(@NotNull String jsonText, Player player, int maxTimes) {
        if (this.emojiKeywordTrie == null) {
            return EmojiTextProcessResult.notReplaced(jsonText);
        }
        HashMap<String, Component> emojis = new HashMap<String, Component>();
        for (Token token : this.emojiKeywordTrie.tokenize(jsonText)) {
            Emoji emoji;
            String fragment;
            if (!token.isMatch() || emojis.containsKey(fragment = token.getFragment()) || (emoji = this.emojiMapper.get(fragment)) == null || player != null && emoji.permission() != null && !player.hasPermission(emoji.permission())) continue;
            emojis.put(fragment, AdventureHelper.miniMessage().deserialize(emoji.content(), PlayerOptionalContext.of(player, ContextHolder.builder().withOptionalParameter(EmojiParameters.EMOJI, emoji.emojiImage()).withParameter(EmojiParameters.KEYWORD, emoji.keywords().get(0))).tagResolvers()));
            if (emojis.size() < maxTimes) continue;
            break;
        }
        if (emojis.isEmpty()) {
            return EmojiTextProcessResult.notReplaced(jsonText);
        }
        Component component = AdventureHelper.jsonToComponent(jsonText);
        String patternString = emojis.keySet().stream().map(Pattern::quote).collect(Collectors.joining("|"));
        component = component.replaceText(builder -> builder.times(maxTimes).match(Pattern.compile(patternString)).replacement((result, b) -> (ComponentLike)emojis.get(result.group())));
        return EmojiTextProcessResult.replaced(AdventureHelper.componentToJson(component));
    }

    @Override
    public EmojiComponentProcessResult replaceComponentEmoji(@NotNull Component text, Player player, @NotNull String raw, int maxTimes) {
        HashMap<String, Component> emojis = new HashMap<String, Component>();
        for (Token token : this.emojiKeywordTrie.tokenize(raw)) {
            Emoji emoji;
            String fragment;
            if (!token.isMatch() || emojis.containsKey(fragment = token.getFragment()) || (emoji = this.emojiMapper.get(token.getFragment())) == null || player != null && emoji.permission() != null && !player.hasPermission(Objects.requireNonNull(emoji.permission()))) continue;
            emojis.put(fragment, AdventureHelper.miniMessage().deserialize(emoji.content(), PlayerOptionalContext.of(player, ContextHolder.builder().withOptionalParameter(EmojiParameters.EMOJI, emoji.emojiImage()).withParameter(EmojiParameters.KEYWORD, emoji.keywords().get(0))).tagResolvers()));
            if (emojis.size() < maxTimes) continue;
            break;
        }
        if (emojis.isEmpty()) {
            return EmojiComponentProcessResult.failed();
        }
        String patternString = emojis.keySet().stream().map(Pattern::quote).collect(Collectors.joining("|"));
        text = text.replaceText(builder -> builder.times(maxTimes).match(Pattern.compile(patternString)).replacement((result, b) -> (ComponentLike)emojis.get(result.group())));
        return EmojiComponentProcessResult.success(text);
    }

    @Override
    public IllegalCharacterProcessResult processIllegalCharacters(String raw, char replacement) {
        boolean hasIllegal = false;
        Map<String, Component> tokens = this.matchTags(raw);
        if (!tokens.isEmpty()) {
            for (Map.Entry<String, Component> entry : tokens.entrySet()) {
                raw = raw.replace(entry.getKey(), String.valueOf(replacement));
                hasIllegal = true;
            }
        }
        if (this.isDefaultFontInUse()) {
            char[] chars = raw.toCharArray();
            int[] codepoints = CharacterUtils.charsToCodePoints(chars);
            int[] newCodepoints = new int[codepoints.length];
            for (int i = 0; i < codepoints.length; ++i) {
                int codepoint = codepoints[i];
                if (!this.isIllegalCodepoint(codepoint)) {
                    newCodepoints[i] = codepoint;
                    continue;
                }
                newCodepoints[i] = replacement;
                hasIllegal = true;
            }
            if (hasIllegal) {
                return IllegalCharacterProcessResult.has(new String(newCodepoints, 0, newCodepoints.length));
            }
        } else if (hasIllegal) {
            return IllegalCharacterProcessResult.has(raw);
        }
        return IllegalCharacterProcessResult.not();
    }

    private void buildEmojiKeywordsTrie() {
        this.emojiMapper = new HashMap<String, Emoji>();
        for (Emoji emoji : this.emojis.values()) {
            for (String keyword : emoji.keywords()) {
                this.emojiMapper.put(keyword, emoji);
            }
        }
        this.emojiKeywordTrie = Trie.builder().ignoreOverlaps().addKeywords(this.emojiMapper.keySet()).build();
    }

    private void buildImageTagTrie() {
        this.tagMapper = new HashMap<String, Component>(1024);
        for (BitmapImage image : this.images.values()) {
            String id = image.id().toString();
            String simpleImageTag = AbstractFontManager.imageTag(id);
            this.tagMapper.put(simpleImageTag, image.componentAt(0, 0));
            this.tagMapper.put("\\" + simpleImageTag, (Component)Component.text((String)simpleImageTag));
            for (int i = 0; i < image.rows(); ++i) {
                for (int j = 0; j < image.columns(); ++j) {
                    String imageArgs = id + ":" + i + ":" + j;
                    String imageTag = AbstractFontManager.imageTag(imageArgs);
                    this.tagMapper.put(imageTag, image.componentAt(i, j));
                    this.tagMapper.put("\\" + imageTag, (Component)Component.text((String)imageTag));
                }
            }
        }
        for (int i = -256; i <= 256; ++i) {
            String shiftTag = "<shift:" + i + ">";
            this.tagMapper.put(shiftTag, this.offsetFont.createOffset(i));
            this.tagMapper.put("\\" + shiftTag, (Component)Component.text((String)shiftTag));
        }
        this.imageTagTrie = Trie.builder().ignoreOverlaps().addKeywords(this.tagMapper.keySet()).build();
    }

    private static String imageTag(String text) {
        return "<image:" + text + ">";
    }

    @Override
    public boolean isDefaultFontInUse() {
        return !this.illegalChars.isEmpty();
    }

    @Override
    public boolean isIllegalCodepoint(int codepoint) {
        return this.illegalChars.contains(codepoint);
    }

    @Override
    public Collection<Font> fonts() {
        return Collections.unmodifiableCollection(this.fonts.values());
    }

    @Override
    public Optional<BitmapImage> bitmapImageByCodepoint(Key font, int codepoint) {
        return this.fontById(font).map(f -> f.bitmapImageByCodepoint(codepoint));
    }

    @Override
    public Optional<BitmapImage> bitmapImageByImageId(Key id) {
        return Optional.ofNullable(this.images.get(id));
    }

    @Override
    public int codepointByImageId(Key key, int x, int y) {
        BitmapImage image = this.images.get(key);
        if (image == null) {
            return -1;
        }
        return image.codepointAt(x, y);
    }

    @Override
    public String createOffsets(int offset, FontTagFormatter tagFormatter) {
        return Optional.ofNullable(this.offsetFont).map(it -> it.createOffset(offset, tagFormatter)).orElse("");
    }

    @Override
    public Optional<Font> fontById(Key id) {
        return Optional.ofNullable(this.fonts.get(id));
    }

    private Font getOrCreateFont(Key key) {
        return this.fonts.computeIfAbsent(key, Font::new);
    }

    public class ImageParser
    implements ConfigParser {
        public static final String[] CONFIG_SECTION_NAME = new String[]{"images", "image"};

        @Override
        public String[] sectionId() {
            return CONFIG_SECTION_NAME;
        }

        @Override
        public int loadingSequence() {
            return 80;
        }

        @Override
        public void parseSection(Pack pack, Path path, Key id, Map<String, Object> section) {
            int ascent;
            int height;
            Object heightObj;
            int[][] codepointGrid;
            Font font;
            Key fontKey;
            Object resourceLocation;
            block29: {
                List<char[]> chars;
                if (AbstractFontManager.this.images.containsKey(id)) {
                    throw new LocalizedResourceConfigException("warning.config.image.duplicate", path, id, new String[0]);
                }
                Object file = section.get("file");
                if (file == null) {
                    throw new LocalizedResourceConfigException("warning.config.image.missing_file", path, id, new String[0]);
                }
                resourceLocation = CharacterUtils.replaceBackslashWithSlash(file.toString());
                if (!ResourceLocation.isValid((String)resourceLocation)) {
                    throw new LocalizedResourceConfigException("warning.config.image.invalid_file_chars", path, id, new String[]{resourceLocation});
                }
                String fontName = section.getOrDefault("font", "minecraft:default").toString();
                if (!ResourceLocation.isValid(fontName)) {
                    throw new LocalizedResourceConfigException("warning.config.image.invalid_font_chars", path, id, fontName);
                }
                fontKey = Key.withDefaultNamespace(fontName, id.namespace());
                font = AbstractFontManager.this.getOrCreateFont(fontKey);
                Object charsObj = ResourceConfigUtils.get(section, "chars", "char");
                if (charsObj == null) {
                    throw new LocalizedResourceConfigException("warning.config.image.missing_char", path, id, new String[0]);
                }
                if (charsObj instanceof List) {
                    List list = (List)charsObj;
                    chars = MiscUtils.getAsStringList(list).stream().map(it -> {
                        if (it.startsWith("\\u")) {
                            return CharacterUtils.decodeUnicodeToChars(it);
                        }
                        return it.toCharArray();
                    }).toList();
                    if (chars.isEmpty()) {
                        throw new LocalizedResourceConfigException("warning.config.image.missing_char", path, id, new String[0]);
                    }
                } else if (charsObj instanceof Integer) {
                    Integer integer = (Integer)charsObj;
                    chars = List.of(new char[]{(char)integer.intValue()});
                } else {
                    String character = charsObj.toString();
                    if (character.isEmpty()) {
                        throw new LocalizedResourceConfigException("warning.config.image.missing_char", path, id, new String[0]);
                    }
                    chars = character.length() == 1 ? List.of(character.toCharArray()) : (character.startsWith("\\u") ? List.of(CharacterUtils.decodeUnicodeToChars(character)) : List.of(character.toCharArray()));
                }
                int size = -1;
                codepointGrid = new int[chars.size()][];
                for (int i = 0; i < chars.size(); ++i) {
                    int[] codepoints;
                    for (int codepoint : codepoints = CharacterUtils.charsToCodePoints(chars.get(i))) {
                        if (!font.isCodepointInUse(codepoint)) continue;
                        BitmapImage image = font.bitmapImageByCodepoint(codepoint);
                        throw new LocalizedResourceConfigException("warning.config.image.codepoint_conflict", path, id, fontKey.toString(), CharacterUtils.encodeCharsToUnicode(Character.toChars(codepoint)), new String(Character.toChars(codepoint)), image.id().toString());
                    }
                    if (codepoints.length == 0) {
                        throw new LocalizedResourceConfigException("warning.config.image.missing_char", path, id, new String[0]);
                    }
                    codepointGrid[i] = codepoints;
                    if (size == -1) {
                        size = codepoints.length;
                    }
                    if (size == codepoints.length) continue;
                    throw new LocalizedResourceConfigException("warning.config.image.invalid_codepoint_grid", path, id, new String[0]);
                }
                heightObj = section.get("height");
                if (!((String)resourceLocation).endsWith(".png")) {
                    resourceLocation = (String)resourceLocation + ".png";
                }
                if (heightObj == null) {
                    Key namespacedPath = Key.of((String)resourceLocation);
                    Path targetImagePath = pack.resourcePackFolder().resolve("assets").resolve(namespacedPath.namespace()).resolve("textures").resolve(namespacedPath.value());
                    if (Files.exists(targetImagePath, new LinkOption[0])) {
                        try (InputStream in = Files.newInputStream(targetImagePath, new OpenOption[0]);){
                            BufferedImage image = ImageIO.read(in);
                            heightObj = image.getHeight() / codepointGrid.length;
                            break block29;
                        }
                        catch (IOException e) {
                            AbstractFontManager.this.plugin.logger().warn("Failed to load image " + String.valueOf(targetImagePath), e);
                            return;
                        }
                    }
                    throw new LocalizedResourceConfigException("warning.config.image.missing_height", path, id, new String[0]);
                }
            }
            if ((height = ResourceConfigUtils.getAsInt(heightObj, "height")) < (ascent = ResourceConfigUtils.getAsInt(section.getOrDefault("ascent", height - 1), "ascent"))) {
                throw new LocalizedResourceConfigException("warning.config.image.height_ascent_conflict", path, id, String.valueOf(height), String.valueOf(ascent));
            }
            BitmapImage bitmapImage = new BitmapImage(id, fontKey, height, ascent, (String)resourceLocation, codepointGrid);
            int[][] nArrayArray = codepointGrid;
            int n = nArrayArray.length;
            for (int i = 0; i < n; ++i) {
                int[] y;
                for (int x : y = nArrayArray[i]) {
                    font.addBitmapImage(x, bitmapImage);
                }
            }
            AbstractFontManager.this.images.put(id, bitmapImage);
        }
    }

    public class EmojiParser
    implements ConfigParser {
        public static final String[] CONFIG_SECTION_NAME = new String[]{"emoji", "emojis"};

        @Override
        public String[] sectionId() {
            return CONFIG_SECTION_NAME;
        }

        @Override
        public int loadingSequence() {
            return 140;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void parseSection(Pack pack, Path path, Key id, Map<String, Object> section) {
            String content;
            if (AbstractFontManager.this.emojis.containsKey(id)) {
                throw new LocalizedResourceConfigException("warning.config.emoji.duplicate", path, id, new String[0]);
            }
            String permission = (String)section.get("permission");
            Object keywordsRaw = section.get("keywords");
            if (keywordsRaw == null) {
                throw new LocalizedResourceConfigException("warning.config.emoji.missing_keywords", path, id, new String[0]);
            }
            List<String> keywords = MiscUtils.getAsStringList(keywordsRaw);
            if (keywords.isEmpty()) {
                throw new LocalizedResourceConfigException("warning.config.emoji.missing_keywords", path, id, new String[0]);
            }
            Object rawContent = section.getOrDefault("content", "<white><arg:emoji></white>");
            if (rawContent instanceof List) {
                List list = (List)rawContent;
                content = list.stream().map(Object::toString).collect(Collectors.joining());
            } else {
                content = rawContent.toString();
            }
            String image = null;
            if (section.containsKey("image")) {
                String rawImage = section.get("image").toString();
                String[] split = rawImage.split(":");
                if (split.length == 2) {
                    Key imageId = new Key(split[0], split[1]);
                    Optional<BitmapImage> bitmapImage = AbstractFontManager.this.bitmapImageByImageId(imageId);
                    if (!bitmapImage.isPresent()) throw new LocalizedResourceConfigException("warning.config.emoji.invalid_image", path, id, rawImage);
                    image = bitmapImage.get().miniMessageAt(0, 0);
                } else {
                    if (split.length != 4) throw new LocalizedResourceConfigException("warning.config.emoji.invalid_image", path, id, rawImage);
                    Key imageId = new Key(split[0], split[1]);
                    Optional<BitmapImage> bitmapImage = AbstractFontManager.this.bitmapImageByImageId(imageId);
                    if (!bitmapImage.isPresent()) throw new LocalizedResourceConfigException("warning.config.emoji.invalid_image", path, id, rawImage);
                    try {
                        image = bitmapImage.get().miniMessageAt(Integer.parseInt(split[2]), Integer.parseInt(split[3]));
                    }
                    catch (ArrayIndexOutOfBoundsException e) {
                        throw new LocalizedResourceConfigException("warning.config.emoji.invalid_image", path, id, rawImage);
                    }
                }
            }
            Emoji emoji = new Emoji(content, permission, image, keywords);
            AbstractFontManager.this.emojis.put(id, emoji);
        }
    }
}

