/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.core.item;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.function.Supplier;
import net.momirealms.craftengine.core.entity.player.Player;
import net.momirealms.craftengine.core.item.BuildableItem;
import net.momirealms.craftengine.core.item.CustomItem;
import net.momirealms.craftengine.core.item.ExternalItemSource;
import net.momirealms.craftengine.core.item.Item;
import net.momirealms.craftengine.core.item.ItemBuildContext;
import net.momirealms.craftengine.core.item.NetworkItemHandler;
import net.momirealms.craftengine.core.item.behavior.ItemBehavior;
import net.momirealms.craftengine.core.item.equipment.Equipment;
import net.momirealms.craftengine.core.item.recipe.DatapackRecipeResult;
import net.momirealms.craftengine.core.item.recipe.UniqueIdItem;
import net.momirealms.craftengine.core.item.updater.ItemUpdateResult;
import net.momirealms.craftengine.core.pack.model.LegacyOverridesModel;
import net.momirealms.craftengine.core.pack.model.ModernItemModel;
import net.momirealms.craftengine.core.pack.model.generation.ModelGenerator;
import net.momirealms.craftengine.core.plugin.Manageable;
import net.momirealms.craftengine.core.plugin.config.ConfigParser;
import net.momirealms.craftengine.core.util.FriendlyByteBuf;
import net.momirealms.craftengine.core.util.Key;
import net.momirealms.craftengine.core.util.UniqueKey;
import net.momirealms.craftengine.libraries.cloud.suggestion.Suggestion;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface ItemManager<T>
extends Manageable,
ModelGenerator {
    public Map<Key, Equipment> equipments();

    public ConfigParser[] parsers();

    public Map<Key, TreeSet<LegacyOverridesModel>> legacyItemOverrides();

    public Map<Key, TreeMap<Integer, ModernItemModel>> modernItemOverrides();

    public Map<Key, ModernItemModel> modernItemModels1_21_4();

    public Map<Key, TreeSet<LegacyOverridesModel>> modernItemModels1_21_2();

    public Collection<Key> vanillaItems();

    @Nullable
    public T buildCustomItemStack(Key var1, @Nullable Player var2);

    @Nullable
    public T buildItemStack(Key var1, @Nullable Player var2);

    @Nullable
    public Item<T> createCustomWrappedItem(Key var1, @Nullable Player var2);

    @Nullable
    public Item<T> createWrappedItem(Key var1, @Nullable Player var2);

    @NotNull
    public Item<T> wrap(T var1);

    public Item<T> fromByteArray(byte[] var1);

    public Collection<Key> items();

    public ExternalItemSource<T> getExternalItemSource(String var1);

    public boolean registerExternalItemSource(ExternalItemSource<T> var1);

    public Optional<Equipment> getEquipment(Key var1);

    public Optional<CustomItem<T>> getCustomItem(Key var1);

    public Optional<List<ItemBehavior>> getItemBehavior(Key var1);

    public Optional<? extends BuildableItem<T>> getVanillaItem(Key var1);

    public NetworkItemHandler<T> networkItemHandler();

    default public Optional<? extends BuildableItem<T>> getBuildableItem(Key key) {
        Optional<CustomItem<T>> item = this.getCustomItem(key);
        if (item.isPresent()) {
            return item;
        }
        return this.getVanillaItem(key);
    }

    public Optional<CustomItem<T>> getCustomItemByPathOnly(String var1);

    public boolean addCustomItem(CustomItem<T> var1);

    default public List<UniqueKey> itemIdsByTag(Key tag) {
        ArrayList<UniqueKey> items = new ArrayList<UniqueKey>();
        items.addAll(this.vanillaItemIdsByTag(tag));
        items.addAll(this.customItemIdsByTag(tag));
        return items;
    }

    public List<UniqueKey> vanillaItemIdsByTag(Key var1);

    public List<UniqueKey> customItemIdsByTag(Key var1);

    public int fuelTime(T var1);

    public int fuelTime(Key var1);

    public Collection<Suggestion> cachedSuggestions();

    public Collection<Suggestion> cachedTotemSuggestions();

    public boolean isVanillaItem(Key var1);

    public Item<T> decode(FriendlyByteBuf var1);

    public void encode(FriendlyByteBuf var1, Item<T> var2);

    public Item<T> s2c(Item<T> var1, Player var2);

    public Item<T> c2s(Item<T> var1);

    public UniqueIdItem<T> uniqueEmptyItem();

    public Item<T> applyTrim(Item<T> var1, Item<T> var2, Item<T> var3, Key var4);

    public Item<T> build(DatapackRecipeResult var1);

    public ItemUpdateResult updateItem(Item<T> var1, Supplier<ItemBuildContext> var2);
}

