/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.core.item.data;

import it.unimi.dsi.fastutil.ints.IntList;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public record FireworkExplosion(Shape shape, IntList colors, IntList fadeColors, boolean hasTrail, boolean hasTwinkle) {
    public static final FireworkExplosion DEFAULT = new FireworkExplosion(Shape.SMALL_BALL, IntList.of(), IntList.of(), false, false);

    public FireworkExplosion withFadeColors(@NotNull IntList fadeColors) {
        return new FireworkExplosion(this.shape, this.colors, fadeColors, this.hasTrail, this.hasTwinkle);
    }

    public static enum Shape {
        SMALL_BALL(0, "small_ball"),
        LARGE_BALL(1, "large_ball"),
        STAR(2, "star"),
        CREEPER(3, "creeper"),
        BURST(4, "burst");

        private final int id;
        private final String name;
        private static final Shape[] BY_ID;
        private static final Map<String, Shape> BY_NAME;

        private Shape(int id, String name) {
            this.id = id;
            this.name = name;
        }

        public int id() {
            return this.id;
        }

        @NotNull
        public String getName() {
            return this.name;
        }

        public static Shape byName(String name) {
            return BY_NAME.get(name);
        }

        public static Shape byId(int id) {
            return BY_ID[id];
        }

        static {
            BY_ID = Shape.values();
            BY_NAME = new HashMap<String, Shape>();
            for (Shape shape : BY_ID) {
                BY_NAME.put(shape.getName(), shape);
                BY_NAME.put(shape.name, shape);
            }
        }
    }
}

