/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.core.item.equipment;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.momirealms.craftengine.core.item.equipment.AbstractEquipment;
import net.momirealms.craftengine.core.item.equipment.EquipmentFactory;
import net.momirealms.craftengine.core.item.equipment.EquipmentLayerType;
import net.momirealms.craftengine.core.item.equipment.Equipments;
import net.momirealms.craftengine.core.item.modifier.EquippableAssetIdModifier;
import net.momirealms.craftengine.core.item.modifier.ItemDataModifier;
import net.momirealms.craftengine.core.util.Key;
import net.momirealms.craftengine.core.util.MiscUtils;
import net.momirealms.craftengine.core.util.ResourceConfigUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ComponentBasedEquipment
extends AbstractEquipment
implements Supplier<JsonObject> {
    public static final Factory FACTORY = new Factory();
    private final EnumMap<EquipmentLayerType, List<Layer>> layers = new EnumMap(EquipmentLayerType.class);

    public ComponentBasedEquipment(Key assetId) {
        super(assetId);
    }

    @Override
    public Key type() {
        return Equipments.COMPONENT;
    }

    @Override
    public <I> List<ItemDataModifier<I>> modifiers() {
        return List.of(new EquippableAssetIdModifier(this.assetId));
    }

    public EnumMap<EquipmentLayerType, List<Layer>> layers() {
        return this.layers;
    }

    public void addLayer(EquipmentLayerType layerType, List<Layer> layer) {
        this.layers.put(layerType, layer);
    }

    @Override
    public JsonObject get() {
        JsonObject jsonObject = new JsonObject();
        JsonObject layersJson = new JsonObject();
        jsonObject.add("layers", (JsonElement)layersJson);
        for (Map.Entry<EquipmentLayerType, List<Layer>> entry : this.layers.entrySet()) {
            EquipmentLayerType type = entry.getKey();
            List<Layer> layerList = entry.getValue();
            this.setLayers(layersJson, layerList, type.id());
        }
        return jsonObject;
    }

    private void setLayers(JsonObject layersJson, List<Layer> layers, String key) {
        if (layers == null || layers.isEmpty()) {
            return;
        }
        JsonArray layersArray = new JsonArray();
        for (Layer layer : layers) {
            layersArray.add((JsonElement)layer.get());
        }
        layersJson.add(key, (JsonElement)layersArray);
    }

    public record Layer(String texture, DyeableData data, boolean usePlayerTexture) implements Supplier<JsonObject>
    {
        @NotNull
        public static List<Layer> fromConfig(Object obj) {
            Object object = obj;
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{String.class, Map.class, List.class}, (Object)object, n)) {
                case 0: {
                    String texture = (String)object;
                    return List.of(new Layer(texture, null, false));
                }
                case 1: {
                    Map map = (Map)object;
                    Map<String, Object> data = MiscUtils.castToMap(map, false);
                    String texture = data.get("texture").toString();
                    return List.of(new Layer(texture, DyeableData.fromObj(data.get("dyeable")), ResourceConfigUtils.getAsBoolean(data.getOrDefault("use-player-texture", false), "use-player-texture")));
                }
                case 2: {
                    List list = (List)object;
                    ArrayList<Layer> layers = new ArrayList<Layer>();
                    for (Object inner : list) {
                        layers.addAll(Layer.fromConfig(inner));
                    }
                    return layers;
                }
            }
            return List.of();
        }

        @Override
        public JsonObject get() {
            JsonObject jsonObject = new JsonObject();
            jsonObject.addProperty("texture", this.texture);
            if (this.data != null) {
                jsonObject.add("dyeable", (JsonElement)this.data.get());
            }
            if (this.usePlayerTexture) {
                jsonObject.addProperty("use_player_texture", Boolean.valueOf(true));
            }
            return jsonObject;
        }

        public record DyeableData(@Nullable Integer colorWhenUndyed) implements Supplier<JsonObject>
        {
            public static DyeableData fromObj(Object obj) {
                Map map;
                Map<String, Object> data;
                if (obj instanceof Map && (data = MiscUtils.castToMap(map = (Map)obj, false)).containsKey("color-when-undyed")) {
                    return new DyeableData(ResourceConfigUtils.getAsInt(data.get("color-when-undyed"), "color-when-undyed"));
                }
                return new DyeableData(null);
            }

            @Override
            public JsonObject get() {
                JsonObject dyeData = new JsonObject();
                if (this.colorWhenUndyed != null) {
                    dyeData.addProperty("color_when_undyed", (Number)this.colorWhenUndyed);
                }
                return dyeData;
            }
        }
    }

    public static class Factory
    implements EquipmentFactory {
        @Override
        public ComponentBasedEquipment create(Key id, Map<String, Object> args) {
            ComponentBasedEquipment equipment = new ComponentBasedEquipment(id);
            for (Map.Entry<String, Object> entry : args.entrySet()) {
                EquipmentLayerType layerType = EquipmentLayerType.byId(entry.getKey());
                if (layerType == null) continue;
                equipment.addLayer(layerType, Layer.fromConfig(entry.getValue()));
            }
            return equipment;
        }
    }
}

