/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.core.item.modifier;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.momirealms.craftengine.core.item.ComponentKeys;
import net.momirealms.craftengine.core.item.Item;
import net.momirealms.craftengine.core.item.ItemBuildContext;
import net.momirealms.craftengine.core.item.ItemDataModifierFactory;
import net.momirealms.craftengine.core.item.ItemKeys;
import net.momirealms.craftengine.core.item.data.Enchantment;
import net.momirealms.craftengine.core.item.modifier.ItemDataModifier;
import net.momirealms.craftengine.core.item.modifier.ItemDataModifiers;
import net.momirealms.craftengine.core.item.modifier.SimpleNetworkItemDataModifier;
import net.momirealms.craftengine.core.util.Key;
import net.momirealms.craftengine.core.util.ResourceConfigUtils;
import org.jetbrains.annotations.Nullable;

public class EnchantmentsModifier<I>
implements SimpleNetworkItemDataModifier<I> {
    public static final Factory<?> FACTORY = new Factory();
    private final List<Enchantment> enchantments;

    public EnchantmentsModifier(List<Enchantment> enchantments) {
        this.enchantments = enchantments;
    }

    public List<Enchantment> enchantments() {
        return this.enchantments;
    }

    @Override
    public Key type() {
        return ItemDataModifiers.ENCHANTMENTS;
    }

    @Override
    public Item<I> apply(Item<I> item, ItemBuildContext context) {
        if (item.vanillaId().equals(ItemKeys.ENCHANTED_BOOK)) {
            return item.setStoredEnchantments(this.enchantments);
        }
        return item.setEnchantments(this.enchantments);
    }

    @Override
    @Nullable
    public Key componentType(Item<I> item, ItemBuildContext context) {
        return item.vanillaId().equals(ItemKeys.ENCHANTED_BOOK) ? ComponentKeys.STORED_ENCHANTMENTS : ComponentKeys.ENCHANTMENTS;
    }

    @Override
    @Nullable
    public Object[] nbtPath(Item<I> item, ItemBuildContext context) {
        Object[] objectArray;
        if (item.vanillaId().equals(ItemKeys.ENCHANTED_BOOK)) {
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = "StoredEnchantments";
        } else {
            Object[] objectArray3 = new Object[1];
            objectArray = objectArray3;
            objectArray3[0] = "Enchantments";
        }
        return objectArray;
    }

    @Override
    public String nbtPathString(Item<I> item, ItemBuildContext context) {
        return item.vanillaId().equals(ItemKeys.ENCHANTED_BOOK) ? "StoredEnchantments" : "Enchantments";
    }

    public static class Factory<I>
    implements ItemDataModifierFactory<I> {
        @Override
        public ItemDataModifier<I> create(Object arg) {
            Map<String, Object> data = ResourceConfigUtils.getAsMap(arg, "enchantments");
            ArrayList<Enchantment> enchantments = new ArrayList<Enchantment>();
            for (Map.Entry<String, Object> e : data.entrySet()) {
                Object object = e.getValue();
                if (!(object instanceof Number)) continue;
                Number number = (Number)object;
                enchantments.add(new Enchantment(Key.of(e.getKey()), number.intValue()));
            }
            return new EnchantmentsModifier(enchantments);
        }
    }
}

