/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.core.item.recipe;

import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.momirealms.craftengine.core.item.recipe.AbstractRecipeSerializer;
import net.momirealms.craftengine.core.item.recipe.CraftingRecipeCategory;
import net.momirealms.craftengine.core.item.recipe.CustomCraftingTableRecipe;
import net.momirealms.craftengine.core.item.recipe.Ingredient;
import net.momirealms.craftengine.core.item.recipe.PlacementInfo;
import net.momirealms.craftengine.core.item.recipe.RecipeSerializers;
import net.momirealms.craftengine.core.item.recipe.input.CraftingInput;
import net.momirealms.craftengine.core.item.recipe.input.RecipeInput;
import net.momirealms.craftengine.core.item.recipe.result.CustomRecipeResult;
import net.momirealms.craftengine.core.util.Key;
import net.momirealms.craftengine.core.util.MiscUtils;
import org.jetbrains.annotations.NotNull;

public class CustomShapelessRecipe<T>
extends CustomCraftingTableRecipe<T> {
    public static final Serializer<?> SERIALIZER = new Serializer();
    private final List<Ingredient<T>> ingredients;
    private final PlacementInfo<T> placementInfo;

    public CustomShapelessRecipe(Key id, boolean showNotification, CustomRecipeResult<T> result, String group, CraftingRecipeCategory category, List<Ingredient<T>> ingredients) {
        super(id, showNotification, result, group, category);
        this.ingredients = ingredients;
        this.placementInfo = PlacementInfo.create(ingredients);
    }

    public PlacementInfo<T> placementInfo() {
        return this.placementInfo;
    }

    @Override
    public List<Ingredient<T>> ingredientsInUse() {
        return this.ingredients;
    }

    @Override
    public boolean matches(RecipeInput input) {
        return this.matches((CraftingInput)input);
    }

    private boolean matches(CraftingInput<T> input) {
        if (input.ingredientCount() != this.ingredients.size()) {
            return false;
        }
        if (input.size() == 1 && this.ingredients.size() == 1) {
            return this.ingredients.getFirst().test(input.getItem(0));
        }
        return input.finder().canCraft(this);
    }

    @Override
    @NotNull
    public Key serializerType() {
        return RecipeSerializers.SHAPELESS;
    }

    public static class Serializer<A>
    extends AbstractRecipeSerializer<A, CustomShapelessRecipe<A>> {
        @Override
        public CustomShapelessRecipe<A> readMap(Key id, Map<String, Object> arguments) {
            ArrayList ingredients = new ArrayList();
            Object ingredientsObject = this.getIngredientOrThrow(arguments);
            if (ingredientsObject instanceof Map) {
                Map map = (Map)ingredientsObject;
                for (Map.Entry<String, Object> entry : MiscUtils.castToMap(map, false).entrySet()) {
                    if (entry.getValue() == null) continue;
                    ingredients.add(this.toIngredient(MiscUtils.getAsStringList(entry.getValue())));
                }
            } else if (ingredientsObject instanceof List) {
                List list = (List)ingredientsObject;
                for (Object obj : list) {
                    if (obj instanceof List) {
                        List inner = (List)obj;
                        ingredients.add(this.toIngredient(MiscUtils.getAsStringList(inner)));
                        continue;
                    }
                    String item = obj.toString();
                    ingredients.add(this.toIngredient(item));
                }
            } else {
                ingredients.add(this.toIngredient(ingredientsObject.toString()));
            }
            return new CustomShapelessRecipe(id, this.showNotification(arguments), this.parseResult(arguments), arguments.containsKey("group") ? arguments.get("group").toString() : null, this.craftingRecipeCategory(arguments), ingredients);
        }

        @Override
        public CustomShapelessRecipe<A> readJson(Key id, JsonObject json) {
            return new CustomShapelessRecipe(id, true, this.parseResult(VANILLA_RECIPE_HELPER.craftingResult(json.getAsJsonObject("result"))), VANILLA_RECIPE_HELPER.readGroup(json), VANILLA_RECIPE_HELPER.craftingCategory(json), VANILLA_RECIPE_HELPER.shapelessIngredients(json.getAsJsonArray("ingredients")).stream().map(this::toIngredient).toList());
        }
    }
}

