/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.core.item.recipe;

import com.google.gson.JsonObject;
import java.util.List;
import java.util.Map;
import net.momirealms.craftengine.core.item.recipe.AbstractGroupedRecipe;
import net.momirealms.craftengine.core.item.recipe.AbstractRecipeSerializer;
import net.momirealms.craftengine.core.item.recipe.Ingredient;
import net.momirealms.craftengine.core.item.recipe.RecipeSerializers;
import net.momirealms.craftengine.core.item.recipe.RecipeType;
import net.momirealms.craftengine.core.item.recipe.input.RecipeInput;
import net.momirealms.craftengine.core.item.recipe.input.SingleItemInput;
import net.momirealms.craftengine.core.item.recipe.result.CustomRecipeResult;
import net.momirealms.craftengine.core.util.Key;
import org.jetbrains.annotations.NotNull;

public class CustomStoneCuttingRecipe<T>
extends AbstractGroupedRecipe<T> {
    public static final Serializer<?> SERIALIZER = new Serializer();
    protected final Ingredient<T> ingredient;

    public CustomStoneCuttingRecipe(Key id, boolean showNotification, CustomRecipeResult<T> result, String group, Ingredient<T> ingredient) {
        super(id, showNotification, result, group);
        this.ingredient = ingredient;
    }

    @Override
    public boolean matches(RecipeInput input) {
        return this.ingredient.test(((SingleItemInput)input).input());
    }

    @Override
    public List<Ingredient<T>> ingredientsInUse() {
        return List.of(this.ingredient);
    }

    @Override
    @NotNull
    public Key serializerType() {
        return RecipeSerializers.STONECUTTING;
    }

    @Override
    public RecipeType type() {
        return RecipeType.STONECUTTING;
    }

    public Ingredient<T> ingredient() {
        return this.ingredient;
    }

    public static class Serializer<A>
    extends AbstractRecipeSerializer<A, CustomStoneCuttingRecipe<A>> {
        @Override
        public CustomStoneCuttingRecipe<A> readMap(Key id, Map<String, Object> arguments) {
            String group = arguments.containsKey("group") ? arguments.get("group").toString() : null;
            return new CustomStoneCuttingRecipe(id, this.showNotification(arguments), this.parseResult(arguments), group, this.singleInputIngredient(arguments));
        }

        @Override
        public CustomStoneCuttingRecipe<A> readJson(Key id, JsonObject json) {
            String group = VANILLA_RECIPE_HELPER.readGroup(json);
            return new CustomStoneCuttingRecipe(id, true, this.parseResult(VANILLA_RECIPE_HELPER.stoneCuttingResult(json)), group, this.toIngredient(VANILLA_RECIPE_HELPER.singleIngredient(json.get("ingredient"))));
        }
    }
}

