/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.core.item.recipe;

import java.util.Map;
import net.momirealms.craftengine.core.item.recipe.CustomBlastingRecipe;
import net.momirealms.craftengine.core.item.recipe.CustomBrewingRecipe;
import net.momirealms.craftengine.core.item.recipe.CustomCampfireRecipe;
import net.momirealms.craftengine.core.item.recipe.CustomShapedRecipe;
import net.momirealms.craftengine.core.item.recipe.CustomShapelessRecipe;
import net.momirealms.craftengine.core.item.recipe.CustomSmeltingRecipe;
import net.momirealms.craftengine.core.item.recipe.CustomSmithingTransformRecipe;
import net.momirealms.craftengine.core.item.recipe.CustomSmithingTrimRecipe;
import net.momirealms.craftengine.core.item.recipe.CustomSmokingRecipe;
import net.momirealms.craftengine.core.item.recipe.CustomStoneCuttingRecipe;
import net.momirealms.craftengine.core.item.recipe.Recipe;
import net.momirealms.craftengine.core.item.recipe.RecipeSerializer;
import net.momirealms.craftengine.core.plugin.locale.LocalizedResourceConfigException;
import net.momirealms.craftengine.core.registry.BuiltInRegistries;
import net.momirealms.craftengine.core.registry.Registries;
import net.momirealms.craftengine.core.registry.WritableRegistry;
import net.momirealms.craftengine.core.util.Key;
import net.momirealms.craftengine.core.util.ResourceConfigUtils;
import net.momirealms.craftengine.core.util.ResourceKey;

public final class RecipeSerializers {
    public static final Key SHAPED = Key.of("minecraft:shaped");
    public static final Key SHAPELESS = Key.of("minecraft:shapeless");
    public static final Key SMELTING = Key.of("minecraft:smelting");
    public static final Key BLASTING = Key.of("minecraft:blasting");
    public static final Key SMOKING = Key.of("minecraft:smoking");
    public static final Key CAMPFIRE_COOKING = Key.of("minecraft:campfire_cooking");
    public static final Key STONECUTTING = Key.of("minecraft:stonecutting");
    public static final Key SMITHING_TRANSFORM = Key.of("minecraft:smithing_transform");
    public static final Key SMITHING_TRIM = Key.of("minecraft:smithing_trim");
    public static final Key BREWING = Key.of("minecraft:brewing");

    public static <T, R extends Recipe<T>> void register(Key key, RecipeSerializer<T, R> serializer) {
        WritableRegistry registry = (WritableRegistry)BuiltInRegistries.RECIPE_SERIALIZER;
        registry.register(ResourceKey.create(Registries.RECIPE_FACTORY.location(), key), serializer);
    }

    public static <T, R extends Recipe<T>> Recipe<T> fromMap(Key id, Map<String, Object> map) {
        String type = ResourceConfigUtils.requireNonEmptyStringOrThrow(map.get("type"), "warning.config.recipe.missing_type");
        Key key = Key.withDefaultNamespace(type, "minecraft");
        RecipeSerializer<?, Recipe<?>> factory = BuiltInRegistries.RECIPE_SERIALIZER.getValue(key);
        if (factory == null) {
            throw new LocalizedResourceConfigException("warning.config.recipe.invalid_type", type);
        }
        return factory.readMap(id, map);
    }

    static {
        RecipeSerializers.register(SHAPED, CustomShapedRecipe.SERIALIZER);
        RecipeSerializers.register(Key.of("crafting_shaped"), CustomShapedRecipe.SERIALIZER);
        RecipeSerializers.register(SHAPELESS, CustomShapelessRecipe.SERIALIZER);
        RecipeSerializers.register(Key.of("crafting_shapeless"), CustomShapelessRecipe.SERIALIZER);
        RecipeSerializers.register(SMELTING, CustomSmeltingRecipe.SERIALIZER);
        RecipeSerializers.register(SMOKING, CustomSmokingRecipe.SERIALIZER);
        RecipeSerializers.register(BLASTING, CustomBlastingRecipe.SERIALIZER);
        RecipeSerializers.register(CAMPFIRE_COOKING, CustomCampfireRecipe.SERIALIZER);
        RecipeSerializers.register(STONECUTTING, CustomStoneCuttingRecipe.SERIALIZER);
        RecipeSerializers.register(SMITHING_TRANSFORM, CustomSmithingTransformRecipe.SERIALIZER);
        RecipeSerializers.register(SMITHING_TRIM, CustomSmithingTrimRecipe.SERIALIZER);
        RecipeSerializers.register(BREWING, CustomBrewingRecipe.SERIALIZER);
    }
}

