/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.core.item.updater;

import java.util.Map;
import net.momirealms.craftengine.core.item.updater.ItemUpdater;
import net.momirealms.craftengine.core.item.updater.ItemUpdaterType;
import net.momirealms.craftengine.core.item.updater.impl.ApplyDataOperation;
import net.momirealms.craftengine.core.item.updater.impl.ResetOperation;
import net.momirealms.craftengine.core.item.updater.impl.TransmuteOperation;
import net.momirealms.craftengine.core.plugin.locale.LocalizedResourceConfigException;
import net.momirealms.craftengine.core.registry.BuiltInRegistries;
import net.momirealms.craftengine.core.registry.Registries;
import net.momirealms.craftengine.core.registry.WritableRegistry;
import net.momirealms.craftengine.core.util.Key;
import net.momirealms.craftengine.core.util.ResourceConfigUtils;
import net.momirealms.craftengine.core.util.ResourceKey;

public class ItemUpdaters {
    public static final Key APPLY_DATA = Key.of("craftengine:apply_data");
    public static final Key TRANSMUTE = Key.of("craftengine:transmute");
    public static final Key RESET = Key.of("craftengine:reset");

    public static void register(Key id, ItemUpdaterType<?> type) {
        WritableRegistry registry = (WritableRegistry)BuiltInRegistries.ITEM_UPDATER_TYPE;
        registry.register(ResourceKey.create(Registries.ITEM_UPDATER_TYPE.location(), id), type);
    }

    public static <I> ItemUpdater<I> fromMap(Key item, Map<String, Object> map) {
        String type = ResourceConfigUtils.requireNonEmptyStringOrThrow(map.get("type"), "warning.config.item.updater.missing_type");
        Key key = Key.withDefaultNamespace(type, "craftengine");
        ItemUpdaterType<?> updaterType = BuiltInRegistries.ITEM_UPDATER_TYPE.getValue(key);
        if (updaterType == null) {
            throw new LocalizedResourceConfigException("warning.config.item.updater.invalid_type", type);
        }
        return updaterType.create(item, map);
    }

    static {
        ItemUpdaters.register(APPLY_DATA, ApplyDataOperation.TYPE);
        ItemUpdaters.register(TRANSMUTE, TransmuteOperation.TYPE);
        ItemUpdaters.register(RESET, ResetOperation.TYPE);
    }
}

