/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.core.loot;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.momirealms.craftengine.core.entity.player.Player;
import net.momirealms.craftengine.core.item.Item;
import net.momirealms.craftengine.core.loot.LootConditions;
import net.momirealms.craftengine.core.loot.LootContext;
import net.momirealms.craftengine.core.loot.LootPool;
import net.momirealms.craftengine.core.loot.entry.LootEntryContainers;
import net.momirealms.craftengine.core.loot.function.LootFunction;
import net.momirealms.craftengine.core.loot.function.LootFunctions;
import net.momirealms.craftengine.core.plugin.context.ContextHolder;
import net.momirealms.craftengine.core.plugin.context.number.NumberProvider;
import net.momirealms.craftengine.core.plugin.context.number.NumberProviders;
import net.momirealms.craftengine.core.plugin.locale.LocalizedResourceConfigException;
import net.momirealms.craftengine.core.util.MiscUtils;
import net.momirealms.craftengine.core.util.ResourceConfigUtils;
import net.momirealms.craftengine.core.world.World;
import org.jetbrains.annotations.Nullable;

public class LootTable<T> {
    private final List<LootPool<T>> pools;
    private final List<LootFunction<T>> functions;
    private final BiFunction<Item<T>, LootContext, Item<T>> compositeFunction;

    public LootTable(List<LootPool<T>> pools, List<LootFunction<T>> functions) {
        this.pools = pools;
        this.functions = functions;
        this.compositeFunction = LootFunctions.compose(functions);
    }

    @Nullable
    public static <T> LootTable<T> fromMap(Map<String, Object> map) {
        List list;
        if (map == null || map.isEmpty()) {
            return null;
        }
        Object pools = ResourceConfigUtils.requireNonNullOrThrow(map.get("pools"), "warning.config.loot_table.missing_pools");
        if (!(pools instanceof List) || (list = (List)pools).isEmpty()) {
            throw new LocalizedResourceConfigException("warning.config.loot_table.invalid_pools_type", pools.getClass().getSimpleName());
        }
        List poolList = (List)map.get("pools");
        ArrayList<LootPool<T>> lootPools = new ArrayList<LootPool<T>>();
        for (Object rawPool : poolList) {
            String string;
            LootPool<T> lootPool;
            if (rawPool instanceof Map) {
                Map rawPoolMap = (Map)rawPool;
                Map<String, Object> pool = MiscUtils.castToMap(rawPoolMap, false);
                NumberProvider rolls = NumberProviders.fromObject(pool.getOrDefault("rolls", 1));
                NumberProvider bonus_rolls = NumberProviders.fromObject(pool.getOrDefault("bonus_rolls", 0));
                List conditions = Optional.ofNullable(pool.get("conditions")).map(it -> LootConditions.fromMapList(LootTable.castToMapListOrThrow(it, () -> new LocalizedResourceConfigException("warning.config.loot_table.invalid_conditions_type", it.getClass().getSimpleName())))).orElse(Lists.newArrayList());
                List containers = Optional.ofNullable(pool.get("entries")).map(it -> new ArrayList(LootEntryContainers.fromMapList(LootTable.castToMapListOrThrow(it, () -> new LocalizedResourceConfigException("warning.config.loot_table.invalid_entries_type", it.getClass().getSimpleName()))))).orElse(Lists.newArrayList());
                List functions = Optional.ofNullable(pool.get("functions")).map(it -> new ArrayList(LootFunctions.fromMapList(LootTable.castToMapListOrThrow(it, () -> new LocalizedResourceConfigException("warning.config.loot_table.invalid_functions_type", it.getClass().getSimpleName()))))).orElse(Lists.newArrayList());
                lootPools.add(new LootPool(containers, conditions, functions, rolls, bonus_rolls));
                continue;
            }
            if (!(rawPool instanceof String) || (lootPool = LootTable.readFlatFormatLootPool(string = (String)rawPool)) == null) continue;
            lootPools.add(lootPool);
        }
        return new LootTable<T>(lootPools, Optional.ofNullable(map.get("functions")).map(it -> new ArrayList(LootFunctions.fromMapList(LootTable.castToMapListOrThrow(it, () -> new LocalizedResourceConfigException("warning.config.loot_table.invalid_functions_type", it.getClass().getSimpleName()))))).orElse(Lists.newArrayList()));
    }

    public List<Item<T>> getRandomItems(ContextHolder parameters, World world) {
        return this.getRandomItems(parameters, world, null);
    }

    public List<Item<T>> getRandomItems(ContextHolder parameters, World world, @Nullable Player player) {
        return this.getRandomItems(new LootContext(world, player, player == null ? 1.0f : (float)player.luck(), parameters));
    }

    private List<Item<T>> getRandomItems(LootContext context) {
        ArrayList<Item<T>> list = new ArrayList<Item<T>>();
        this.getRandomItems(context, list::add);
        return list;
    }

    public void getRandomItems(LootContext context, Consumer<Item<T>> lootConsumer) {
        this.getRandomItemsRaw(context, this.createFunctionApplier(this.createStackSplitter(lootConsumer), context));
    }

    private Consumer<Item<T>> createFunctionApplier(Consumer<Item<T>> lootConsumer, LootContext context) {
        return item -> {
            for (LootFunction<Item> lootFunction : this.functions) {
                lootFunction.apply((Item)item, context);
            }
            lootConsumer.accept((Item<T>)item);
        };
    }

    private Consumer<Item<T>> createStackSplitter(Consumer<Item<T>> consumer) {
        return item -> {
            if (item.count() < item.maxStackSize()) {
                consumer.accept((Item)item);
            } else {
                Item splitItem;
                for (int remaining = item.count(); remaining > 0; remaining -= splitItem.count()) {
                    splitItem = item.copyWithCount(Math.min(item.maxStackSize(), remaining));
                    consumer.accept(splitItem);
                }
            }
        };
    }

    public void getRandomItemsRaw(LootContext context, Consumer<Item<T>> lootConsumer) {
        Consumer<Item<T>> consumer = LootFunction.decorate(this.compositeFunction, lootConsumer, context);
        for (LootPool<T> pool : this.pools) {
            pool.addRandomItems(consumer, context);
        }
    }

    public static <T> LootPool<T> readFlatFormatLootPool(String pool) {
        return null;
    }

    private static List<Map<String, Object>> castToMapListOrThrow(Object obj, Supplier<RuntimeException> exceptionSupplier) {
        if (obj instanceof List) {
            List list = (List)obj;
            return list;
        }
        throw exceptionSupplier.get();
    }
}

