/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.core.loot.entry;

import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import net.momirealms.craftengine.core.item.Item;
import net.momirealms.craftengine.core.loot.LootContext;
import net.momirealms.craftengine.core.loot.entry.AbstractLootEntryContainer;
import net.momirealms.craftengine.core.loot.entry.LootEntry;
import net.momirealms.craftengine.core.loot.function.LootFunction;
import net.momirealms.craftengine.core.loot.function.LootFunctions;
import net.momirealms.craftengine.core.plugin.context.Condition;

public abstract class AbstractSingleLootEntryContainer<T>
extends AbstractLootEntryContainer<T> {
    protected final int weight;
    protected final int quality;
    protected final List<LootFunction<T>> functions;
    protected final BiFunction<Item<T>, LootContext, Item<T>> compositeFunction;
    private final EntryBase<T> entry = new EntryBase<T>(){

        @Override
        public void createItem(Consumer<Item<T>> lootConsumer, LootContext context) {
            AbstractSingleLootEntryContainer.this.createItem(LootFunction.decorate(AbstractSingleLootEntryContainer.this.compositeFunction, lootConsumer, context), context);
        }
    };

    protected AbstractSingleLootEntryContainer(List<Condition<LootContext>> conditions, List<LootFunction<T>> functions, int weight, int quality) {
        super(conditions);
        this.weight = weight;
        this.quality = quality;
        this.functions = functions;
        this.compositeFunction = LootFunctions.compose(functions);
    }

    @Override
    public boolean expand(LootContext context, Consumer<LootEntry<T>> choiceConsumer) {
        if (super.test(context)) {
            choiceConsumer.accept(this.entry);
            return true;
        }
        return false;
    }

    public int weight() {
        return this.weight;
    }

    public int quality() {
        return this.quality;
    }

    protected abstract void createItem(Consumer<Item<T>> var1, LootContext var2);

    protected abstract class EntryBase<A>
    implements LootEntry<A> {
        protected EntryBase() {
        }

        @Override
        public int getWeight(float luck) {
            float qualityModifier = (float)AbstractSingleLootEntryContainer.this.quality() * luck;
            int weightBoost = 100;
            double baseWeight = 100.0f * ((float)AbstractSingleLootEntryContainer.this.weight() + qualityModifier);
            double impacted = baseWeight * ((baseWeight - 100.0) / 100.0 / 100.0);
            float luckModifier = Math.min(100.0f, luck * 10.0f) / 100.0f;
            double reduced = Math.ceil(baseWeight - impacted * (double)luckModifier);
            return (int)Math.max(0.0, reduced);
        }
    }
}

