/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.core.pack.conflict.resolution;

import java.util.Map;
import net.momirealms.craftengine.core.pack.conflict.resolution.Resolution;
import net.momirealms.craftengine.core.pack.conflict.resolution.ResolutionConditional;
import net.momirealms.craftengine.core.pack.conflict.resolution.ResolutionFactory;
import net.momirealms.craftengine.core.pack.conflict.resolution.ResolutionMergeAltas;
import net.momirealms.craftengine.core.pack.conflict.resolution.ResolutionMergeJson;
import net.momirealms.craftengine.core.pack.conflict.resolution.ResolutionMergePackMcMeta;
import net.momirealms.craftengine.core.pack.conflict.resolution.RetainMatchingResolution;
import net.momirealms.craftengine.core.plugin.locale.LocalizedException;
import net.momirealms.craftengine.core.registry.BuiltInRegistries;
import net.momirealms.craftengine.core.registry.Registries;
import net.momirealms.craftengine.core.registry.WritableRegistry;
import net.momirealms.craftengine.core.util.Key;
import net.momirealms.craftengine.core.util.ResourceConfigUtils;
import net.momirealms.craftengine.core.util.ResourceKey;

public class Resolutions {
    public static final Key RETAIN_MATCHING = Key.of("craftengine:retain_matching");
    public static final Key MERGE_JSON = Key.of("craftengine:merge_json");
    public static final Key MERGE_ATLAS = Key.of("craftengine:merge_atlas");
    public static final Key CONDITIONAL = Key.of("craftengine:conditional");
    public static final Key MERGE_PACK_MCMETA = Key.of("craftengine:merge_pack_mcmeta");

    public static void register(Key key, ResolutionFactory factory) {
        ((WritableRegistry)BuiltInRegistries.RESOLUTION_FACTORY).register(ResourceKey.create(Registries.RESOLUTION_FACTORY.location(), key), factory);
    }

    public static Resolution fromMap(Map<String, Object> map) {
        String type = ResourceConfigUtils.requireNonEmptyStringOrThrow(map.get("type"), () -> new LocalizedException("warning.config.conflict_resolution.missing_type", new String[0]));
        Key key = Key.withDefaultNamespace(type, "craftengine");
        ResolutionFactory factory = BuiltInRegistries.RESOLUTION_FACTORY.getValue(key);
        if (factory == null) {
            throw new LocalizedException("warning.config.conflict_resolution.invalid_type", type);
        }
        return factory.create(map);
    }

    static {
        Resolutions.register(RETAIN_MATCHING, RetainMatchingResolution.FACTORY);
        Resolutions.register(MERGE_JSON, ResolutionMergeJson.FACTORY);
        Resolutions.register(CONDITIONAL, ResolutionConditional.FACTORY);
        Resolutions.register(MERGE_PACK_MCMETA, ResolutionMergePackMcMeta.FACTORY);
        Resolutions.register(MERGE_ATLAS, ResolutionMergeAltas.FACTORY);
    }
}

