/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.core.pack.model.generation;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import net.momirealms.craftengine.core.pack.model.generation.GuiLight;
import net.momirealms.craftengine.core.pack.model.generation.display.DisplayMeta;
import net.momirealms.craftengine.core.pack.model.generation.display.DisplayPosition;
import net.momirealms.craftengine.core.plugin.locale.LocalizedResourceConfigException;
import net.momirealms.craftengine.core.util.EnumUtils;
import net.momirealms.craftengine.core.util.Key;
import net.momirealms.craftengine.core.util.MiscUtils;
import net.momirealms.craftengine.core.util.ResourceConfigUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;

public class ModelGeneration
implements Supplier<JsonObject> {
    private static final Map<String, BiConsumer<Builder, Object>> BUILDER_FUNCTIONS = new HashMap<String, BiConsumer<Builder, Object>>();
    @NotNull
    private final Key path;
    @NotNull
    private final String parentModelPath;
    @Nullable
    private final Map<String, String> texturesOverride;
    @Nullable
    private final Map<DisplayPosition, DisplayMeta> displays;
    @Nullable
    private final GuiLight guiLight;
    @Nullable
    private final Boolean ambientOcclusion;
    @Nullable
    private JsonObject cachedModel;

    public ModelGeneration(@NotNull Key path, @NotNull String parentModelPath, @Nullable Map<String, String> texturesOverride, @Nullable Map<DisplayPosition, DisplayMeta> displays, @Nullable GuiLight guiLight, @Nullable Boolean ambientOcclusion) {
        this.path = path;
        this.parentModelPath = parentModelPath;
        this.texturesOverride = texturesOverride;
        this.displays = displays;
        this.guiLight = guiLight;
        this.ambientOcclusion = ambientOcclusion;
    }

    public static ModelGeneration of(Key path, Map<String, Object> map) {
        Builder builder = ModelGeneration.builder().path(path);
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            Optional.ofNullable(BUILDER_FUNCTIONS.get(entry.getKey())).ifPresent(it -> it.accept(builder, entry.getValue()));
        }
        return builder.build();
    }

    @Nullable
    public Map<String, String> texturesOverride() {
        return this.texturesOverride;
    }

    public Key path() {
        return this.path;
    }

    public String parentModelPath() {
        return this.parentModelPath;
    }

    @Nullable
    public Map<DisplayPosition, DisplayMeta> displays() {
        return this.displays;
    }

    @Nullable
    public GuiLight guiLight() {
        return this.guiLight;
    }

    @Nullable
    public Boolean ambientOcclusion() {
        return this.ambientOcclusion;
    }

    @Override
    public JsonObject get() {
        if (this.cachedModel == null) {
            this.cachedModel = this.getCachedModel();
        }
        return this.cachedModel;
    }

    private JsonObject getCachedModel() {
        JsonObject model = new JsonObject();
        model.addProperty("parent", this.parentModelPath);
        if (this.texturesOverride != null) {
            JsonObject textures = new JsonObject();
            for (Map.Entry<Object, Object> entry : this.texturesOverride.entrySet()) {
                textures.addProperty((String)entry.getKey(), (String)entry.getValue());
            }
            model.add("textures", (JsonElement)textures);
        }
        if (this.displays != null) {
            JsonObject displays = new JsonObject();
            for (Map.Entry<Object, Object> entry : this.displays.entrySet()) {
                JsonObject displayMetadata = new JsonObject();
                DisplayMeta meta = (DisplayMeta)entry.getValue();
                if (meta.rotation() != null) {
                    displayMetadata.add("rotation", (JsonElement)this.vectorToJsonArray(meta.rotation()));
                }
                if (meta.translation() != null) {
                    displayMetadata.add("translation", (JsonElement)this.vectorToJsonArray(meta.translation()));
                }
                if (meta.scale() != null) {
                    displayMetadata.add("scale", (JsonElement)this.vectorToJsonArray(meta.scale()));
                }
                displays.add(((DisplayPosition)((Object)entry.getKey())).name().toLowerCase(Locale.ENGLISH), (JsonElement)displayMetadata);
            }
            model.add("display", (JsonElement)displays);
        }
        if (this.guiLight != null) {
            model.addProperty("gui_light", this.guiLight.name().toLowerCase(Locale.ENGLISH));
        }
        return model;
    }

    private JsonArray vectorToJsonArray(Vector3f vector) {
        JsonArray array = new JsonArray();
        array.add((Number)Float.valueOf(vector.x()));
        array.add((Number)Float.valueOf(vector.y()));
        array.add((Number)Float.valueOf(vector.z()));
        return array;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ModelGeneration that = (ModelGeneration)o;
        return this.path.equals(that.path) && this.parentModelPath.equals(that.parentModelPath) && Objects.equals(this.texturesOverride, that.texturesOverride) && Objects.equals(this.displays, that.displays) && Objects.equals(this.ambientOcclusion, that.ambientOcclusion) && Objects.equals((Object)this.guiLight, (Object)that.guiLight);
    }

    public int hashCode() {
        int result = this.path.hashCode();
        result = 31 * result + this.parentModelPath.hashCode();
        return result;
    }

    public static Builder builder() {
        return new Builder();
    }

    static {
        BUILDER_FUNCTIONS.put("textures", (b, data) -> {
            Map<String, Object> texturesMap = MiscUtils.castToMap(data, false);
            LinkedHashMap<String, String> texturesOverride = new LinkedHashMap<String, String>();
            for (Map.Entry<String, Object> entry : texturesMap.entrySet()) {
                Object patt0$temp = entry.getValue();
                if (!(patt0$temp instanceof String)) continue;
                String p = (String)patt0$temp;
                texturesOverride.put(entry.getKey(), p);
            }
            b.texturesOverride(texturesOverride);
        });
        BUILDER_FUNCTIONS.put("display", (b, data) -> {
            Map<String, Object> displayMap = MiscUtils.castToMap(data, false);
            EnumMap<DisplayPosition, DisplayMeta> displays = new EnumMap<DisplayPosition, DisplayMeta>(DisplayPosition.class);
            for (Map.Entry<String, Object> entry : displayMap.entrySet()) {
                try {
                    DisplayPosition displayPosition = DisplayPosition.valueOf(entry.getKey().toUpperCase(Locale.ENGLISH));
                    Object patt0$temp = entry.getValue();
                    if (!(patt0$temp instanceof Map)) continue;
                    Map metaMap = (Map)patt0$temp;
                    displays.put(displayPosition, DisplayMeta.fromMap(MiscUtils.castToMap(metaMap, false)));
                }
                catch (IllegalArgumentException e) {
                    throw new LocalizedResourceConfigException("warning.config.model.generation.invalid_display_position", e, entry.getKey(), EnumUtils.toString(DisplayPosition.values()));
                }
            }
            b.displays(displays);
        });
        BUILDER_FUNCTIONS.put("gui-light", (b, data) -> {
            String guiLightStr = String.valueOf(data);
            try {
                GuiLight guiLight = GuiLight.valueOf(guiLightStr.toUpperCase(Locale.ENGLISH));
                b.guiLight(guiLight);
            }
            catch (IllegalArgumentException e) {
                throw new LocalizedResourceConfigException("warning.config.model.generation.invalid_gui_light", e, guiLightStr, EnumUtils.toString(GuiLight.values()));
            }
        });
        BUILDER_FUNCTIONS.put("ambient-occlusion", (b, data) -> b.ambientOcclusion(ResourceConfigUtils.getAsBoolean(data, "ambient-occlusion")));
        BUILDER_FUNCTIONS.put("parent", (b, data) -> {
            String parentModelPath = data.toString();
            b.parentModelPath(parentModelPath);
        });
    }

    public static class Builder {
        private Key path;
        private String parentModelPath;
        @Nullable
        private Map<String, String> texturesOverride;
        @Nullable
        private Map<DisplayPosition, DisplayMeta> displays;
        @Nullable
        private GuiLight guiLight;
        @Nullable
        private Boolean ambientOcclusion;

        public Builder path(Key key) {
            this.path = key;
            return this;
        }

        public Builder parentModelPath(String parentModelPath) {
            this.parentModelPath = parentModelPath;
            return this;
        }

        public Builder texturesOverride(Map<String, String> texturesOverride) {
            this.texturesOverride = texturesOverride;
            return this;
        }

        public Builder displays(Map<DisplayPosition, DisplayMeta> displays) {
            this.displays = displays;
            return this;
        }

        public Builder guiLight(GuiLight guiLight) {
            this.guiLight = guiLight;
            return this;
        }

        public Builder ambientOcclusion(Boolean ambientOcclusion) {
            this.ambientOcclusion = ambientOcclusion;
            return this;
        }

        public ModelGeneration build() {
            if (this.parentModelPath == null) {
                throw new LocalizedResourceConfigException("warning.config.model.generation.missing_parent", new String[0]);
            }
            return new ModelGeneration(Objects.requireNonNull(this.path, "path should be nonnull"), this.parentModelPath, this.texturesOverride, this.displays, this.guiLight, this.ambientOcclusion);
        }
    }
}

