/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.core.pack.model.tint;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.momirealms.craftengine.core.pack.model.tint.Tint;
import net.momirealms.craftengine.core.plugin.locale.LocalizedResourceConfigException;
import net.momirealms.craftengine.core.util.MiscUtils;
import net.momirealms.craftengine.libraries.cloud.type.Either;

public interface TintFactory {
    public Tint create(Map<String, Object> var1);

    default public Either<Integer, List<Float>> parseTintValue(Object value) {
        String s;
        String[] split;
        if (value instanceof Number) {
            Number i = (Number)value;
            return Either.ofPrimary((Object)i.intValue());
        }
        if (value instanceof List) {
            List list = (List)value;
            if (list.size() == 3) {
                List<String> strList = MiscUtils.getAsStringList(list);
                boolean hasDot = false;
                for (String str : strList) {
                    if (!str.contains(".")) continue;
                    hasDot = true;
                    break;
                }
                ArrayList<Float> fList = new ArrayList<Float>();
                for (String str : strList) {
                    if (hasDot) {
                        fList.add(Float.valueOf(Float.parseFloat(str)));
                        continue;
                    }
                    fList.add(Float.valueOf(TintFactory.convertToFloat(Integer.parseInt(str))));
                }
                return Either.ofFallback(fList);
            }
        } else if (value instanceof String && (split = (s = (String)value).split(",")).length == 3) {
            ArrayList<Float> fList = new ArrayList<Float>();
            boolean hasDot = s.contains(".");
            for (String string : split) {
                if (hasDot) {
                    fList.add(Float.valueOf(Float.parseFloat(string)));
                    continue;
                }
                fList.add(Float.valueOf(TintFactory.convertToFloat(Integer.parseInt(string))));
            }
            return Either.ofFallback(fList);
        }
        throw new LocalizedResourceConfigException("warning.config.item.model.tint.invalid_value", value.toString());
    }

    public static float convertToFloat(int value) {
        if (value < 0 || value > 255) {
            throw new IllegalArgumentException("Tint value out of range: " + value + ". Allowed range is [0,255]");
        }
        return (float)value / 255.0f;
    }
}

