/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.core.plugin.command.sender;

import java.util.Objects;
import java.util.UUID;
import net.momirealms.craftengine.core.plugin.Plugin;
import net.momirealms.craftengine.core.plugin.command.sender.AbstractSender;
import net.momirealms.craftengine.core.plugin.command.sender.Sender;
import net.momirealms.craftengine.core.util.Tristate;
import net.momirealms.craftengine.libraries.adventure.text.Component;

public abstract class SenderFactory<P extends Plugin, T> {
    private final P plugin;
    private final Sender console;

    public SenderFactory(P plugin) {
        this.plugin = plugin;
        this.console = this.wrap(this.consoleCommandSender());
    }

    protected P plugin() {
        return this.plugin;
    }

    protected abstract UUID uniqueId(T var1);

    protected abstract String name(T var1);

    protected abstract void sendMessage(T var1, Component var2);

    protected abstract Tristate permissionState(T var1, String var2);

    protected abstract boolean hasPermission(T var1, String var2);

    protected abstract void performCommand(T var1, String var2);

    protected abstract boolean isConsole(T var1);

    protected abstract <C extends T> C consoleCommandSender();

    protected boolean consoleHasAllPermissions() {
        return true;
    }

    public Sender console() {
        return this.console;
    }

    public <C extends T> Sender wrap(C sender) {
        Objects.requireNonNull(sender, "sender");
        return new AbstractSender<C>((Plugin)this.plugin, this, sender);
    }

    public void close() {
    }
}

