/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.core.plugin.config.template;

import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import net.momirealms.craftengine.core.plugin.config.template.TemplateArgument;
import net.momirealms.craftengine.core.plugin.config.template.TemplateArgumentFactory;
import net.momirealms.craftengine.core.plugin.config.template.TemplateArguments;
import net.momirealms.craftengine.core.plugin.config.template.TemplateManager;
import net.momirealms.craftengine.core.util.Key;
import net.momirealms.craftengine.libraries.evalex.Expression;
import net.momirealms.craftengine.libraries.evalex.data.EvaluationValue;

public class ExpressionTemplateArgument
implements TemplateArgument {
    public static final Factory FACTORY = new Factory();
    private final TemplateManager.ArgumentString expression;
    private final ValueType valueType;

    protected ExpressionTemplateArgument(String expression, ValueType valueType) {
        this.expression = TemplateManager.preParse(expression);
        this.valueType = valueType;
    }

    @Override
    public Object get(Map<String, TemplateArgument> arguments) {
        String expression = Optional.ofNullable(this.expression.get(arguments)).map(String::valueOf).orElse(null);
        if (expression == null) {
            return null;
        }
        try {
            return this.valueType.formatter().apply(new Expression(expression).evaluate());
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to process expression argument: " + String.valueOf(this.expression), e);
        }
    }

    @Override
    public Key type() {
        return TemplateArguments.EXPRESSION;
    }

    protected static enum ValueType {
        INT(e -> e.getNumberValue().intValue()),
        LONG(e -> e.getNumberValue().longValue()),
        SHORT(e -> e.getNumberValue().shortValueExact()),
        DOUBLE(e -> e.getNumberValue().doubleValue()),
        FLOAT(e -> Float.valueOf(e.getNumberValue().floatValue())),
        BOOLEAN(EvaluationValue::getBooleanValue);

        private final Function<EvaluationValue, Object> formatter;

        private ValueType(Function<EvaluationValue, Object> formatter) {
            this.formatter = formatter;
        }

        public Function<EvaluationValue, Object> formatter() {
            return this.formatter;
        }
    }

    public static class Factory
    implements TemplateArgumentFactory {
        @Override
        public TemplateArgument create(Map<String, Object> arguments) {
            return new ExpressionTemplateArgument(arguments.getOrDefault("expression", "").toString(), ValueType.valueOf(arguments.getOrDefault("value-type", "double").toString().toUpperCase(Locale.ENGLISH)));
        }
    }
}

