/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.core.plugin.config.template;

import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.momirealms.craftengine.core.plugin.config.template.TemplateArgument;
import net.momirealms.craftengine.core.plugin.config.template.TemplateArgumentFactory;
import net.momirealms.craftengine.core.plugin.config.template.TemplateArguments;
import net.momirealms.craftengine.core.plugin.locale.LocalizedResourceConfigException;
import net.momirealms.craftengine.core.util.Key;

public class ListTemplateArgument
implements TemplateArgument {
    public static final Factory FACTORY = new Factory();
    private final List<Object> value;

    public ListTemplateArgument(List<Object> value) {
        this.value = value;
    }

    @Override
    public List<Object> get(Map<String, TemplateArgument> arguments) {
        return this.value;
    }

    @Override
    public Key type() {
        return TemplateArguments.LIST;
    }

    public static class Factory
    implements TemplateArgumentFactory {
        @Override
        public TemplateArgument create(Map<String, Object> arguments) {
            List list = arguments.getOrDefault("list", List.of());
            return new ListTemplateArgument(Factory.castToListOrThrow(list, () -> new LocalizedResourceConfigException("warning.config.template.argument.list.invalid_type", list.getClass().getSimpleName())));
        }

        private static List<Object> castToListOrThrow(Object obj, Supplier<LocalizedResourceConfigException> throwableSupplier) {
            if (obj instanceof List) {
                List list = (List)obj;
                return list;
            }
            throw throwableSupplier.get();
        }
    }
}

