/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.core.plugin.context.parameter;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import net.momirealms.craftengine.core.plugin.context.ChainParameterProvider;
import net.momirealms.craftengine.core.plugin.context.ContextKey;
import net.momirealms.craftengine.core.plugin.context.parameter.DirectContextParameters;
import net.momirealms.craftengine.core.world.World;

public class WorldParameterProvider
implements ChainParameterProvider<World> {
    private static final Map<ContextKey<?>, Function<World, Object>> CONTEXT_FUNCTIONS = new HashMap();

    @Override
    public <T> Optional<T> getOptionalParameter(ContextKey<T> parameter, World world) {
        return Optional.ofNullable(CONTEXT_FUNCTIONS.get(parameter)).map(f -> f.apply(world));
    }

    static {
        CONTEXT_FUNCTIONS.put(DirectContextParameters.NAME, World::name);
        CONTEXT_FUNCTIONS.put(DirectContextParameters.TIME, World::time);
        CONTEXT_FUNCTIONS.put(DirectContextParameters.UUID, World::uuid);
    }
}

