/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.core.plugin.dependency;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.DirectoryStream;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.stream.Stream;
import net.momirealms.craftengine.core.plugin.Plugin;
import net.momirealms.craftengine.core.plugin.classpath.ClassPathAppender;
import net.momirealms.craftengine.core.plugin.dependency.Dependency;
import net.momirealms.craftengine.core.plugin.dependency.DependencyDownloadException;
import net.momirealms.craftengine.core.plugin.dependency.DependencyManager;
import net.momirealms.craftengine.core.plugin.dependency.DependencyRegistry;
import net.momirealms.craftengine.core.plugin.dependency.DependencyRepository;
import net.momirealms.craftengine.core.plugin.dependency.classloader.IsolatedClassLoader;
import net.momirealms.craftengine.core.plugin.dependency.relocation.Relocation;
import net.momirealms.craftengine.core.plugin.dependency.relocation.RelocationHandler;
import net.momirealms.craftengine.core.util.FileUtils;

public class DependencyManagerImpl
implements DependencyManager {
    private final DependencyRegistry registry;
    private final Path cacheDirectory;
    private final ClassPathAppender classPathAppender;
    private final Map<Dependency, Path> loaded = Collections.synchronizedMap(new HashMap());
    private final Map<Set<Dependency>, IsolatedClassLoader> loaders = new HashMap<Set<Dependency>, IsolatedClassLoader>();
    private final RelocationHandler relocationHandler;
    private final Executor loadingExecutor;
    private final Plugin plugin;

    public DependencyManagerImpl(Plugin plugin) {
        this.plugin = plugin;
        this.registry = new DependencyRegistry();
        this.cacheDirectory = DependencyManagerImpl.setupCacheDirectory(plugin);
        this.classPathAppender = plugin.classPathAppender();
        this.loadingExecutor = plugin.scheduler().async();
        this.relocationHandler = new RelocationHandler(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ClassLoader obtainClassLoaderWith(Set<Dependency> dependencies) {
        HashSet<Dependency> set = new HashSet<Dependency>(dependencies);
        for (Dependency dependency : dependencies) {
            if (this.loaded.containsKey(dependency)) continue;
            throw new IllegalStateException("Dependency " + dependency.id() + " is not loaded.");
        }
        Map<Set<Dependency>, IsolatedClassLoader> map = this.loaders;
        synchronized (map) {
            IsolatedClassLoader classLoader = this.loaders.get(set);
            if (classLoader != null) {
                return classLoader;
            }
            URL[] urls = (URL[])set.stream().map(this.loaded::get).map(file -> {
                try {
                    return file.toUri().toURL();
                }
                catch (MalformedURLException e) {
                    throw new RuntimeException(e);
                }
            }).toArray(URL[]::new);
            classLoader = new IsolatedClassLoader(urls);
            this.loaders.put(set, classLoader);
            return classLoader;
        }
    }

    @Override
    public void loadDependencies(Collection<Dependency> dependencies) {
        CountDownLatch latch = new CountDownLatch(dependencies.size());
        for (Dependency dependency : dependencies) {
            if (this.loaded.containsKey(dependency)) {
                latch.countDown();
                continue;
            }
            this.loadingExecutor.execute(() -> {
                try {
                    this.loadDependency(dependency);
                }
                catch (Throwable e) {
                    this.plugin.logger().warn("Unable to load dependency " + dependency.id(), e);
                }
                finally {
                    latch.countDown();
                }
            });
        }
        try {
            latch.await();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    private void loadDependency(Dependency dependency) throws Exception {
        if (this.loaded.containsKey(dependency)) {
            return;
        }
        Path file = this.remapDependency(dependency, this.downloadDependency(dependency));
        this.loaded.put(dependency, file);
        if (this.classPathAppender != null && this.registry.shouldAutoLoad(dependency)) {
            this.classPathAppender.addJarToClasspath(file);
        }
    }

    private Path downloadDependency(Dependency dependency) throws DependencyDownloadException {
        String fileName = dependency.fileName(null);
        Path file = this.cacheDirectory.resolve(dependency.toLocalPath()).resolve(fileName);
        if (Files.exists(file, new LinkOption[0])) {
            return file;
        }
        Path versionFolder = file.getParent().getParent();
        if (Files.exists(versionFolder, new LinkOption[0]) && Files.isDirectory(versionFolder, new LinkOption[0])) {
            String version = dependency.getVersion();
            try (Stream<Path> dirStream = Files.list(versionFolder);){
                dirStream.filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).filter(it -> !it.getFileName().toString().equals(version)).forEach(dir -> {
                    try {
                        FileUtils.deleteDirectory(dir);
                        this.plugin.logger().info("Cleaned up outdated dependency " + String.valueOf(dir));
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                });
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to clean " + String.valueOf(versionFolder), e);
            }
        }
        DependencyDownloadException lastError = null;
        List<DependencyRepository> repository = DependencyRepository.getByID("maven");
        if (!repository.isEmpty()) {
            for (int i = 0; i < repository.size(); ++i) {
                try {
                    this.plugin.logger().info("Downloading dependency " + repository.get(i).getUrl() + dependency.mavenPath());
                    repository.get(i).download(dependency, file);
                    this.plugin.logger().info("Successfully downloaded " + fileName);
                    return file;
                }
                catch (DependencyDownloadException e) {
                    lastError = e;
                    continue;
                }
            }
        }
        throw (DependencyDownloadException)Objects.requireNonNull(lastError);
    }

    private Path remapDependency(Dependency dependency, Path normalFile) throws Exception {
        ArrayList<Relocation> rules = new ArrayList<Relocation>(dependency.relocations());
        if (rules.isEmpty()) {
            return normalFile;
        }
        Path remappedFile = this.cacheDirectory.resolve(dependency.toLocalPath()).resolve(dependency.fileName(DependencyRegistry.isGsonRelocated() ? "remapped-legacy" : "remapped"));
        if (Files.exists(remappedFile, new LinkOption[0]) && dependency.verify(remappedFile)) {
            return remappedFile;
        }
        this.plugin.logger().info("Remapping " + dependency.fileName(null));
        this.relocationHandler.remap(normalFile, remappedFile, rules);
        this.plugin.logger().info("Successfully remapped " + dependency.fileName(null));
        return remappedFile;
    }

    private static Path setupCacheDirectory(Plugin plugin) {
        Path cacheDirectory = plugin.dataFolderPath().resolve("libs");
        try {
            if (Files.exists(cacheDirectory, new LinkOption[0]) && (Files.isDirectory(cacheDirectory, new LinkOption[0]) || Files.isSymbolicLink(cacheDirectory))) {
                DependencyManagerImpl.cleanDirectoryJars(cacheDirectory);
                return cacheDirectory;
            }
            try {
                Files.createDirectories(cacheDirectory, new FileAttribute[0]);
            }
            catch (FileAlreadyExistsException fileAlreadyExistsException) {}
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to create libs directory", e);
        }
        return cacheDirectory;
    }

    private static void cleanDirectoryJars(Path directory) throws IOException {
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(directory);){
            for (Path file : stream) {
                if (!Files.isRegularFile(file, new LinkOption[0]) || !file.getFileName().toString().endsWith(".jar")) continue;
                Files.delete(file);
            }
        }
    }

    @Override
    public void close() {
        Throwable firstEx = null;
        for (IsolatedClassLoader loader : this.loaders.values()) {
            try {
                loader.close();
            }
            catch (IOException ex) {
                if (firstEx == null) {
                    firstEx = ex;
                    continue;
                }
                firstEx.addSuppressed(ex);
            }
        }
        if (firstEx != null) {
            this.plugin.logger().severe(firstEx.getMessage(), firstEx);
        }
    }
}

