/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.core.util;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Stream;
import net.momirealms.craftengine.core.pack.ResourceLocation;

public class FileUtils {
    private FileUtils() {
    }

    public static String getExtension(Path path) {
        String name = path.getFileName().toString();
        int index = name.lastIndexOf(46);
        if (index == -1) {
            return "";
        }
        return name.substring(index + 1);
    }

    public static String pathWithoutExtension(String path) {
        int i = path.lastIndexOf(46);
        return i == -1 ? path : path.substring(0, i);
    }

    public static void createDirectoriesSafe(Path path) throws IOException {
        Files.createDirectories(Files.exists(path, new LinkOption[0]) ? path.toRealPath(new LinkOption[0]) : path, new FileAttribute[0]);
    }

    public static void deleteDirectory(Path folder) throws IOException {
        if (!Files.exists(folder, new LinkOption[0])) {
            return;
        }
        try (Stream<Path> walk = Files.walk(folder, FileVisitOption.FOLLOW_LINKS);){
            walk.sorted(Comparator.reverseOrder()).forEach(path -> {
                try {
                    Files.delete(path);
                }
                catch (IOException ioException) {
                    throw new RuntimeException(ioException);
                }
            });
        }
    }

    public static List<Path> getYmlConfigsDeeply(Path configFolder) {
        List<Path> list;
        block9: {
            if (!Files.exists(configFolder, new LinkOption[0])) {
                return List.of();
            }
            Stream<Path> stream = Files.walk(configFolder, FileVisitOption.FOLLOW_LINKS);
            try {
                list = ((Stream)stream.parallel()).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(path -> path.toString().endsWith(".yml")).toList();
                if (stream == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException("Failed to traverse directory: " + String.valueOf(configFolder), e);
                }
            }
            stream.close();
        }
        return list;
    }

    public static List<Path> collectOverlays(Path resourcePackFolder) throws IOException {
        ObjectArrayList folders = new ObjectArrayList();
        folders.add(resourcePackFolder);
        try (Stream<Path> paths = Files.list(resourcePackFolder);){
            folders.addAll(paths.filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).filter(path -> !path.getFileName().toString().equals("assets")).filter(path -> Files.exists(path.resolve("assets"), new LinkOption[0])).toList());
        }
        return folders;
    }

    public static List<Path> collectNamespaces(Path assetsFolder) throws IOException {
        ObjectArrayList folders;
        try (Stream<Path> paths = Files.list(assetsFolder);){
            folders = new ObjectArrayList(paths.filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).filter(path -> ResourceLocation.isValidNamespace(path.getFileName().toString())).toList());
        }
        return folders;
    }
}

