/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.core.util;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public enum PressurePlateSensitivity {
    EVERYTHING("everything", "all"),
    MOBS("mobs", "mob");

    private final String[] names;
    private static final Map<String, PressurePlateSensitivity> BY_NAME;

    private PressurePlateSensitivity(String ... names) {
        this.names = names;
    }

    public String[] names() {
        return this.names;
    }

    public static PressurePlateSensitivity byName(String name) {
        return Optional.ofNullable(BY_NAME.get(name)).orElseThrow(() -> new IllegalArgumentException("PressurePlateSensitivity not found: " + name));
    }

    static {
        BY_NAME = new HashMap<String, PressurePlateSensitivity>();
        for (PressurePlateSensitivity trigger : PressurePlateSensitivity.values()) {
            for (String name : trigger.names()) {
                BY_NAME.put(name, trigger);
            }
        }
    }
}

