/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.core.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class SerializationUtils {
    private SerializationUtils() {
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static <T extends Serializable> T clone(T object) {
        if (object == null) {
            return null;
        }
        byte[] objectData = SerializationUtils.serialize(object);
        try (ByteArrayInputStream bais = new ByteArrayInputStream(objectData);){
            Serializable serializable;
            try (ClassLoaderAwareObjectInputStream ois = new ClassLoaderAwareObjectInputStream(bais, object.getClass().getClassLoader());){
                Serializable clonedObject;
                serializable = clonedObject = (Serializable)ois.readObject();
            }
            return (T)serializable;
        }
        catch (IOException | ClassNotFoundException e) {
            throw new RuntimeException("Exception occurred while cloning object", e);
        }
    }

    public static <T> T deserialize(byte[] objectData) {
        Objects.requireNonNull(objectData);
        return SerializationUtils.deserialize(new ByteArrayInputStream(objectData));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T> T deserialize(InputStream inputStream) {
        Objects.requireNonNull(inputStream);
        try (ObjectInputStream ois = new ObjectInputStream(inputStream);){
            Object obj;
            Object object = obj = ois.readObject();
            return (T)object;
        }
        catch (IOException | ClassNotFoundException e) {
            throw new RuntimeException("Exception occurred while deserializing object", e);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static byte[] serialize(Serializable obj) {
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            byte[] byArray;
            try (ObjectOutputStream oos = new ObjectOutputStream(baos);){
                oos.writeObject(obj);
                byArray = baos.toByteArray();
            }
            return byArray;
        }
        catch (IOException e) {
            throw new RuntimeException("Exception occurred while serializing object", e);
        }
    }

    static class ClassLoaderAwareObjectInputStream
    extends ObjectInputStream {
        private static final Map<String, Class<?>> PRIMITIVE_TYPES = new HashMap();
        private final ClassLoader classLoader;

        ClassLoaderAwareObjectInputStream(InputStream in, ClassLoader classLoader) throws IOException {
            super(in);
            this.classLoader = classLoader;
        }

        @Override
        protected Class<?> resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
            String className = desc.getName();
            try {
                return Class.forName(className, false, this.classLoader);
            }
            catch (ClassNotFoundException e) {
                Class<?> primitiveClass = PRIMITIVE_TYPES.get(className);
                if (primitiveClass != null) {
                    return primitiveClass;
                }
                return super.resolveClass(desc);
            }
        }

        static {
            PRIMITIVE_TYPES.put("byte", Byte.TYPE);
            PRIMITIVE_TYPES.put("short", Short.TYPE);
            PRIMITIVE_TYPES.put("int", Integer.TYPE);
            PRIMITIVE_TYPES.put("long", Long.TYPE);
            PRIMITIVE_TYPES.put("float", Float.TYPE);
            PRIMITIVE_TYPES.put("double", Double.TYPE);
            PRIMITIVE_TYPES.put("boolean", Boolean.TYPE);
            PRIMITIVE_TYPES.put("char", Character.TYPE);
            PRIMITIVE_TYPES.put("void", Void.TYPE);
        }
    }
}

