/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.core.world.chunk;

import net.momirealms.craftengine.core.block.ImmutableBlockState;
import net.momirealms.craftengine.core.world.BlockPos;
import net.momirealms.craftengine.core.world.chunk.PalettedContainer;
import org.jetbrains.annotations.ApiStatus;

public class CESection {
    public static final int SECTION_WIDTH = 16;
    public static final int SECTION_HEIGHT = 16;
    public static final int SECTION_SIZE = 4096;
    private final int sectionY;
    private final PalettedContainer<ImmutableBlockState> statesContainer;

    public CESection(int sectionY, PalettedContainer<ImmutableBlockState> statesContainer) {
        this.sectionY = sectionY;
        this.statesContainer = statesContainer;
    }

    @ApiStatus.Internal
    public ImmutableBlockState setBlockState(BlockPos pos, ImmutableBlockState state) {
        return this.setBlockState(pos.x() & 0xF, pos.y() & 0xF, pos.z() & 0xF, state);
    }

    @ApiStatus.Internal
    public ImmutableBlockState setBlockState(int x, int y, int z, ImmutableBlockState state) {
        return this.setBlockState((y << 4 | z) << 4 | x, state);
    }

    @ApiStatus.Internal
    public ImmutableBlockState setBlockState(int index, ImmutableBlockState state) {
        return this.statesContainer.getAndSet(index, state);
    }

    @ApiStatus.Internal
    public ImmutableBlockState getBlockState(BlockPos pos) {
        return this.getBlockState(pos.x() & 0xF, pos.y() & 0xF, pos.z() & 0xF);
    }

    @ApiStatus.Internal
    public ImmutableBlockState getBlockState(int x, int y, int z) {
        return this.statesContainer.get((y << 4 | z) << 4 | x);
    }

    @ApiStatus.Internal
    public ImmutableBlockState getBlockState(int index) {
        return this.statesContainer.get(index);
    }

    @ApiStatus.Internal
    public PalettedContainer<ImmutableBlockState> statesContainer() {
        return this.statesContainer;
    }

    public int sectionY() {
        return this.sectionY;
    }
}

