/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.core.world.chunk.storage;

import java.io.IOException;
import java.util.concurrent.TimeUnit;
import net.momirealms.craftengine.core.plugin.CraftEngine;
import net.momirealms.craftengine.core.world.CEWorld;
import net.momirealms.craftengine.core.world.ChunkPos;
import net.momirealms.craftengine.core.world.chunk.CEChunk;
import net.momirealms.craftengine.core.world.chunk.storage.WorldDataStorage;
import net.momirealms.craftengine.libraries.caffeine.cache.Cache;
import net.momirealms.craftengine.libraries.caffeine.cache.Caffeine;
import net.momirealms.craftengine.libraries.caffeine.cache.Scheduler;
import org.jetbrains.annotations.NotNull;

public class CachedStorage<T extends WorldDataStorage>
implements WorldDataStorage {
    private final T storage;
    private final Cache<ChunkPos, CEChunk> chunkCache;

    public CachedStorage(T storage) {
        this.storage = storage;
        this.chunkCache = Caffeine.newBuilder().executor(CraftEngine.instance().scheduler().async()).scheduler(Scheduler.systemScheduler()).initialCapacity(2048).expireAfterAccess(60L, TimeUnit.SECONDS).build();
    }

    @Override
    @NotNull
    public CEChunk readChunkAt(@NotNull CEWorld world, @NotNull ChunkPos pos) throws IOException {
        CEChunk chunk = (CEChunk)this.chunkCache.getIfPresent((Object)pos);
        if (chunk != null) {
            return chunk;
        }
        chunk = this.storage.readChunkAt(world, pos);
        this.chunkCache.put((Object)pos, (Object)chunk);
        return chunk;
    }

    @Override
    public void writeChunkAt(@NotNull ChunkPos pos, @NotNull CEChunk chunk) throws IOException {
        this.storage.writeChunkAt(pos, chunk);
    }

    @Override
    public void close() throws IOException {
        this.storage.close();
    }

    @Override
    public void flush() throws IOException {
        this.storage.flush();
    }
}

