/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.core.world.chunk.storage;

import it.unimi.dsi.fastutil.longs.Long2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongLinkedOpenHashSet;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import net.momirealms.craftengine.core.plugin.config.Config;
import net.momirealms.craftengine.core.util.ExceptionCollector;
import net.momirealms.craftengine.core.util.FileUtils;
import net.momirealms.craftengine.core.world.CEWorld;
import net.momirealms.craftengine.core.world.ChunkPos;
import net.momirealms.craftengine.core.world.chunk.CEChunk;
import net.momirealms.craftengine.core.world.chunk.serialization.DefaultChunkSerializer;
import net.momirealms.craftengine.core.world.chunk.storage.CompressionMethod;
import net.momirealms.craftengine.core.world.chunk.storage.RegionFile;
import net.momirealms.craftengine.core.world.chunk.storage.WorldDataStorage;
import net.momirealms.craftengine.libraries.nbt.CompoundTag;
import net.momirealms.craftengine.libraries.nbt.NBT;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DefaultRegionFileStorage
implements WorldDataStorage {
    private final Path folder;
    public static final String REGION_FILE_SUFFIX = ".mca";
    public static final String REGION_FILE_PREFIX = "r.";
    public static final int MAX_NON_EXISTING_CACHE = 65536;
    public final Long2ObjectLinkedOpenHashMap<RegionFile> regionCache = new Long2ObjectLinkedOpenHashMap();
    private final LongLinkedOpenHashSet nonExistingRegionFiles = new LongLinkedOpenHashSet();

    public DefaultRegionFileStorage(Path directory) {
        this.folder = directory;
    }

    private synchronized boolean doesRegionFilePossiblyExist(long position) {
        if (this.nonExistingRegionFiles.contains(position)) {
            this.nonExistingRegionFiles.addAndMoveToFirst(position);
            return false;
        }
        return true;
    }

    private synchronized void createRegionFile(long position) {
        this.nonExistingRegionFiles.remove(position);
    }

    private synchronized void markNonExisting(long position) {
        if (this.nonExistingRegionFiles.addAndMoveToFirst(position)) {
            while (this.nonExistingRegionFiles.size() >= 65536) {
                this.nonExistingRegionFiles.removeLastLong();
            }
        }
    }

    public synchronized boolean doesRegionFileNotExistNoIO(ChunkPos pos) {
        long key = ChunkPos.asLong(pos.regionX(), pos.regionZ());
        return !this.doesRegionFilePossiblyExist(key);
    }

    public synchronized RegionFile getRegionFileIfLoaded(ChunkPos pos) {
        return (RegionFile)this.regionCache.getAndMoveToFirst(ChunkPos.asLong(pos.regionX(), pos.regionZ()));
    }

    public synchronized boolean chunkExists(ChunkPos pos) throws IOException {
        RegionFile regionfile = this.getRegionFile(pos, true, false);
        return regionfile != null && regionfile.hasChunk(pos);
    }

    public synchronized RegionFile getRegionFile(ChunkPos pos, boolean existingOnly, boolean lock) throws IOException {
        long chunkPosLongKey = ChunkPos.asLong(pos.regionX(), pos.regionZ());
        RegionFile regionfile = (RegionFile)this.regionCache.getAndMoveToFirst(chunkPosLongKey);
        if (regionfile != null) {
            if (lock) {
                regionfile.fileLock.lock();
            }
            return regionfile;
        }
        if (existingOnly && !this.doesRegionFilePossiblyExist(chunkPosLongKey)) {
            return null;
        }
        if (this.regionCache.size() >= 256) {
            ((RegionFile)this.regionCache.removeLast()).close();
        }
        Path path = this.folder.resolve(REGION_FILE_PREFIX + pos.regionX() + "." + pos.regionZ() + REGION_FILE_SUFFIX);
        if (existingOnly && !Files.exists(path, new LinkOption[0])) {
            this.markNonExisting(chunkPosLongKey);
            return null;
        }
        this.createRegionFile(chunkPosLongKey);
        FileUtils.createDirectoriesSafe(this.folder);
        RegionFile newRegionFile = new RegionFile(path, this.folder, CompressionMethod.fromId(Config.compressionMethod()));
        this.regionCache.putAndMoveToFirst(chunkPosLongKey, (Object)newRegionFile);
        if (lock) {
            newRegionFile.fileLock.lock();
        }
        return newRegionFile;
    }

    public static ChunkPos getRegionFileCoordinates(Path file) {
        String fileName = file.getFileName().toString();
        if (!fileName.startsWith(REGION_FILE_PREFIX) || !fileName.endsWith(REGION_FILE_SUFFIX)) {
            return null;
        }
        String[] split = fileName.split("\\.");
        if (split.length != 4) {
            return null;
        }
        try {
            int x = Integer.parseInt(split[1]);
            int z = Integer.parseInt(split[2]);
            return new ChunkPos(x << 5, z << 5);
        }
        catch (NumberFormatException ex) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public CEChunk readChunkAt(@NotNull CEWorld world, @NotNull ChunkPos pos) throws IOException {
        RegionFile regionFile = this.getRegionFile(pos, false, true);
        try {
            CompoundTag tag;
            DataInputStream dataInputStream = regionFile.getChunkDataInputStream(pos);
            try {
                if (dataInputStream == null) {
                    CEChunk cEChunk = new CEChunk(world, pos);
                    return cEChunk;
                }
                tag = NBT.readCompound(dataInputStream, false);
            }
            finally {
                try {
                    dataInputStream.close();
                }
                catch (Throwable t2) {
                    Throwable t1;
                    t1.addSuppressed(t2);
                }
            }
            CEChunk cEChunk = DefaultChunkSerializer.deserialize(world, pos, tag);
            return cEChunk;
        }
        finally {
            regionFile.fileLock.unlock();
        }
    }

    @Override
    public void writeChunkAt(@NotNull ChunkPos pos, @NotNull CEChunk chunk) throws IOException {
        CompoundTag nbt = DefaultChunkSerializer.serialize(chunk);
        this.writeChunkTagAt(pos, nbt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeChunkTagAt(@NotNull ChunkPos pos, @Nullable CompoundTag nbt) throws IOException {
        block9: {
            RegionFile regionFile = this.getRegionFile(pos, nbt == null, true);
            try {
                if (nbt == null) {
                    regionFile.clear(pos);
                    break block9;
                }
                DataOutputStream dataOutputStream = regionFile.getChunkDataOutputStream(pos);
                try {
                    NBT.writeCompound(nbt, dataOutputStream, false);
                }
                catch (Throwable t1) {
                    if (dataOutputStream != null) {
                        try {
                            dataOutputStream.close();
                        }
                        catch (Throwable t2) {
                            t1.addSuppressed(t2);
                        }
                    }
                    throw t1;
                }
                dataOutputStream.close();
            }
            finally {
                regionFile.fileLock.unlock();
            }
        }
    }

    @Override
    public synchronized void flush() throws IOException {
        for (RegionFile regionFile : this.regionCache.values()) {
            regionFile.flush();
        }
    }

    @Override
    public synchronized void close() throws IOException {
        ExceptionCollector<IOException> collector = new ExceptionCollector<IOException>();
        for (RegionFile regionfile : this.regionCache.values()) {
            try {
                regionfile.close();
            }
            catch (IOException ioexception) {
                collector.add(ioexception);
            }
        }
        collector.throwIfPresent();
    }
}

