/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.libraries.antigrieflib;

import java.util.HashSet;
import java.util.Set;
import net.momirealms.craftengine.libraries.antigrieflib.AntiGriefPlugin;
import net.momirealms.craftengine.libraries.antigrieflib.CompatibilityException;
import net.momirealms.craftengine.libraries.antigrieflib.comp.BentoBoxComp;
import net.momirealms.craftengine.libraries.antigrieflib.comp.CrashClaimComp;
import net.momirealms.craftengine.libraries.antigrieflib.comp.DominionComp;
import net.momirealms.craftengine.libraries.antigrieflib.comp.FabledSkyBlockComp;
import net.momirealms.craftengine.libraries.antigrieflib.comp.FactionsUUIDComp;
import net.momirealms.craftengine.libraries.antigrieflib.comp.GriefDefenderComp;
import net.momirealms.craftengine.libraries.antigrieflib.comp.GriefPreventionComp;
import net.momirealms.craftengine.libraries.antigrieflib.comp.HClaimsComp;
import net.momirealms.craftengine.libraries.antigrieflib.comp.HuskClaimsComp;
import net.momirealms.craftengine.libraries.antigrieflib.comp.HuskTownsComp;
import net.momirealms.craftengine.libraries.antigrieflib.comp.IridiumSkyblockComp;
import net.momirealms.craftengine.libraries.antigrieflib.comp.KingdomsComp;
import net.momirealms.craftengine.libraries.antigrieflib.comp.LandlordComp;
import net.momirealms.craftengine.libraries.antigrieflib.comp.LandsComp;
import net.momirealms.craftengine.libraries.antigrieflib.comp.NoBuildPlusComp;
import net.momirealms.craftengine.libraries.antigrieflib.comp.PlotSquaredV5Comp;
import net.momirealms.craftengine.libraries.antigrieflib.comp.PlotSquaredV6V7Comp;
import net.momirealms.craftengine.libraries.antigrieflib.comp.PreciousStonesComp;
import net.momirealms.craftengine.libraries.antigrieflib.comp.RedProtectComp;
import net.momirealms.craftengine.libraries.antigrieflib.comp.ResidenceComp;
import net.momirealms.craftengine.libraries.antigrieflib.comp.SaberFactionsComp;
import net.momirealms.craftengine.libraries.antigrieflib.comp.SuperiorSkyblockComp;
import net.momirealms.craftengine.libraries.antigrieflib.comp.TownyComp;
import net.momirealms.craftengine.libraries.antigrieflib.comp.USkyBlockComp;
import net.momirealms.craftengine.libraries.antigrieflib.comp.UltimateClaimsComp;
import net.momirealms.craftengine.libraries.antigrieflib.comp.UltimateClansComp;
import net.momirealms.craftengine.libraries.antigrieflib.comp.WorldGuardComp;
import net.momirealms.craftengine.libraries.antigrieflib.comp.XClaimComp;
import net.momirealms.craftengine.libraries.antigrieflib.util.ReflectionUtils;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.java.JavaPlugin;

public class AntiGriefLib {
    private final JavaPlugin plugin;
    private final Set<AntiGriefPlugin> plugins = new HashSet<AntiGriefPlugin>();
    private boolean ignoreOP;
    private boolean silentLogs;

    private AntiGriefLib(JavaPlugin plugin) {
        this.plugin = plugin;
    }

    private void init() {
        for (AntiGriefPlugin antiGriefPlugin : this.plugins) {
            antiGriefPlugin.init();
            this.logHook(antiGriefPlugin.getAntiGriefPluginName());
        }
    }

    public static Builder builder(JavaPlugin plugin) {
        return new Builder(plugin);
    }

    public boolean canPlace(Player player, Location location) {
        if (this.ignoreOP && player.isOp()) {
            return true;
        }
        for (AntiGriefPlugin antiGriefPlugin : this.plugins) {
            if (antiGriefPlugin.canPlace(player, location)) continue;
            return false;
        }
        return true;
    }

    public boolean canBreak(Player player, Location location) {
        if (this.ignoreOP && player.isOp()) {
            return true;
        }
        for (AntiGriefPlugin antiGriefPlugin : this.plugins) {
            if (antiGriefPlugin.canBreak(player, location)) continue;
            return false;
        }
        return true;
    }

    public boolean canInteract(Player player, Location location) {
        if (this.ignoreOP && player.isOp()) {
            return true;
        }
        for (AntiGriefPlugin antiGriefPlugin : this.plugins) {
            if (antiGriefPlugin.canInteract(player, location)) continue;
            return false;
        }
        return true;
    }

    public boolean canInteractEntity(Player player, Entity entity) {
        if (this.ignoreOP && player.isOp()) {
            return true;
        }
        for (AntiGriefPlugin antiGriefPlugin : this.plugins) {
            if (antiGriefPlugin.canInteractEntity(player, entity)) continue;
            return false;
        }
        return true;
    }

    public boolean canDamage(Player player, Entity entity) {
        Player another;
        if (entity instanceof Player && !(another = (Player)entity).getWorld().getPVP()) {
            return false;
        }
        if (this.ignoreOP && player.isOp()) {
            return true;
        }
        for (AntiGriefPlugin antiGriefPlugin : this.plugins) {
            if (antiGriefPlugin.canDamage(player, entity)) continue;
            return false;
        }
        return true;
    }

    public void registerNewCompatibility(AntiGriefPlugin antiGriefPlugin) {
        this.plugins.add(antiGriefPlugin);
    }

    private void detectSupportedPlugins() {
        PluginManager manager = Bukkit.getPluginManager();
        if (manager.getPlugin("WorldGuard") != null && ReflectionUtils.classExists("com{}sk89q{}worldguard{}WorldGuard")) {
            this.registerNewCompatibility(new WorldGuardComp(this.plugin));
        }
        if (manager.getPlugin("Kingdoms") != null && ReflectionUtils.classExists("org{}kingdoms{}constants{}land{}Land")) {
            this.registerNewCompatibility(new KingdomsComp(this.plugin));
        }
        if (manager.getPlugin("Lands") != null && ReflectionUtils.classExists("me{}angeschossen{}lands{}api{}LandsIntegration")) {
            this.registerNewCompatibility(new LandsComp(this.plugin));
        }
        if (manager.getPlugin("IridiumSkyblock") != null && ReflectionUtils.classExists("com{}iridium{}iridiumskyblock{}api{}IridiumSkyblockAPI") && manager.getPlugin("IridiumSkyblock").getDescription().getVersion().startsWith("4.0")) {
            this.registerNewCompatibility(new IridiumSkyblockComp(this.plugin));
        }
        if (manager.getPlugin("CrashClaim") != null && ReflectionUtils.classExists("net{}crashcraft{}crashclaim{}CrashClaim")) {
            this.registerNewCompatibility(new CrashClaimComp(this.plugin));
        }
        if (manager.getPlugin("GriefDefender") != null && ReflectionUtils.classExists("com{}griefdefender{}api{}GriefDefender")) {
            this.registerNewCompatibility(new GriefDefenderComp(this.plugin));
        }
        if (manager.getPlugin("HuskClaims") != null && ReflectionUtils.classExists("net{}william278{}huskclaims{}api{}BukkitHuskClaimsAPI")) {
            this.registerNewCompatibility(new HuskClaimsComp(this.plugin));
        }
        if (manager.getPlugin("BentoBox") != null && ReflectionUtils.classExists("world{}bentobox{}bentobox{}BentoBox")) {
            this.registerNewCompatibility(new BentoBoxComp(this.plugin));
        }
        if (manager.getPlugin("HuskTowns") != null && ReflectionUtils.classExists("net{}william278{}husktowns{}api{}BukkitHuskTownsAPI")) {
            this.registerNewCompatibility(new HuskTownsComp(this.plugin));
        }
        if (manager.getPlugin("PlotSquared") != null && ReflectionUtils.classExists("com{}plotsquared{}bukkit{}util{}BukkitUtil")) {
            switch (manager.getPlugin("PlotSquared").getDescription().getVersion().charAt(0)) {
                case '5': {
                    this.registerNewCompatibility(new PlotSquaredV5Comp(this.plugin));
                    break;
                }
                case '6': 
                case '7': {
                    this.registerNewCompatibility(new PlotSquaredV6V7Comp(this.plugin));
                }
            }
        }
        if (manager.getPlugin("Residence") != null && ReflectionUtils.classExists("com{}bekvon{}bukkit{}residence{}Residence")) {
            this.registerNewCompatibility(new ResidenceComp(this.plugin));
        }
        if (manager.getPlugin("SuperiorSkyblock2") != null && ReflectionUtils.classExists("com{}bgsoftware{}superiorskyblock{}SuperiorSkyblockPlugin")) {
            this.registerNewCompatibility(new SuperiorSkyblockComp(this.plugin));
        }
        if (manager.getPlugin("Towny") != null && ReflectionUtils.classExists("com{}palmergames{}bukkit{}towny{}TownyAPI")) {
            this.registerNewCompatibility(new TownyComp(this.plugin));
        }
        if (manager.getPlugin("FabledSkyBlock") != null && ReflectionUtils.classExists("com{}craftaro{}skyblock{}api{}SkyBlockAPI")) {
            this.registerNewCompatibility(new FabledSkyBlockComp(this.plugin));
        }
        if (manager.getPlugin("GriefPrevention") != null && ReflectionUtils.classExists("me{}ryanhamshire{}GriefPrevention{}Claim")) {
            this.registerNewCompatibility(new GriefPreventionComp(this.plugin));
        }
        if (manager.getPlugin("RedProtect") != null && ReflectionUtils.classExists("br{}net{}fabiozumbi12{}RedProtect{}Bukkit{}API{}RedProtectAPI")) {
            this.registerNewCompatibility(new RedProtectComp(this.plugin));
        }
        if (manager.getPlugin("Landlord") != null && ReflectionUtils.classExists("biz{}princeps{}landlord{}api{}ILandLord")) {
            this.registerNewCompatibility(new LandlordComp(this.plugin));
        }
        if (manager.getPlugin("uSkyBlock") != null && ReflectionUtils.classExists("us{}talabrek{}ultimateskyblock{}api{}uSkyBlockAPI")) {
            this.registerNewCompatibility(new USkyBlockComp(this.plugin));
        }
        if (manager.getPlugin("XClaim") != null && ReflectionUtils.classExists("codes{}wasabi{}xclaim{}api{}Claim")) {
            this.registerNewCompatibility(new XClaimComp(this.plugin));
        }
        if (manager.getPlugin("UltimateClaims") != null && ReflectionUtils.classExists("com{}craftaro{}ultimateclaims{}UltimateClaims")) {
            this.registerNewCompatibility(new UltimateClaimsComp(this.plugin));
        }
        if (manager.getPlugin("UltimateClans") != null && ReflectionUtils.classExists("me{}ulrich{}clans{}Clans")) {
            this.registerNewCompatibility(new UltimateClansComp(this.plugin));
        }
        if (manager.getPlugin("PreciousStones") != null && ReflectionUtils.classExists("net{}sacredlabyrinth{}Phaed{}PreciousStones{}api{}Api")) {
            this.registerNewCompatibility(new PreciousStonesComp(this.plugin));
        }
        if (manager.getPlugin("hClaims") != null && ReflectionUtils.classExists("com{}hakan{}claim{}shadow{}com{}hakan{}spinjection{}SpigotBootstrap")) {
            this.registerNewCompatibility(new HClaimsComp(this.plugin));
        }
        if (manager.getPlugin("Dominion") != null && ReflectionUtils.classExists("cn{}lunadeer{}dominion{}api{}DominionAPI")) {
            this.registerNewCompatibility(new DominionComp(this.plugin));
        }
        if (manager.getPlugin("Factions") != null) {
            if (ReflectionUtils.classExists("com{}massivecraft{}factions{}zcore{}fperms{}PermissableAction")) {
                this.registerNewCompatibility(new SaberFactionsComp(this.plugin));
            }
            if (ReflectionUtils.classExists("com{}massivecraft{}factions{}perms{}PermissibleActions")) {
                this.registerNewCompatibility(new FactionsUUIDComp(this.plugin));
            }
        }
        if (manager.getPlugin("NoBuildPlus") != null && ReflectionUtils.classExists("p1xel{}nobuildplus{}NoBuildPlus")) {
            this.registerNewCompatibility(new NoBuildPlusComp(this.plugin));
        }
    }

    private void logHook(String pluginName) {
        if (this.silentLogs) {
            return;
        }
        this.plugin.getLogger().info("[AntiGriefLib] Enabled " + pluginName + " compatibility.");
    }

    public static class Builder {
        private final AntiGriefLib lib;

        public Builder(JavaPlugin plugin) {
            this.lib = new AntiGriefLib(plugin);
            try {
                this.lib.detectSupportedPlugins();
            }
            catch (Exception e) {
                throw new CompatibilityException("AntiGriefLib failed to init", e);
            }
        }

        public Builder ignoreOP(boolean ignoreOP) {
            this.lib.ignoreOP = ignoreOP;
            return this;
        }

        public Builder silentLogs(boolean silent) {
            this.lib.silentLogs = silent;
            return this;
        }

        public Builder addCompatibility(AntiGriefPlugin antiGriefPlugin) {
            this.lib.registerNewCompatibility(antiGriefPlugin);
            return this;
        }

        public AntiGriefLib build() {
            this.lib.init();
            return this.lib;
        }
    }
}

