/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.libraries.antigrieflib.comp;

import cn.lunadeer.dominion.api.DominionAPI;
import cn.lunadeer.dominion.api.dtos.DominionDTO;
import cn.lunadeer.dominion.api.dtos.flag.Flags;
import net.momirealms.craftengine.libraries.antigrieflib.AbstractComp;
import net.momirealms.craftengine.libraries.antigrieflib.CompatibilityException;
import org.bukkit.Location;
import org.bukkit.entity.Animals;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Monster;
import org.bukkit.entity.Player;
import org.bukkit.entity.Villager;
import org.bukkit.plugin.java.JavaPlugin;

public class DominionComp
extends AbstractComp {
    private DominionAPI api;

    public DominionComp(JavaPlugin plugin) {
        super(plugin, "Dominion");
    }

    @Override
    public void init() {
        try {
            this.api = DominionAPI.getInstance();
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | NoSuchFieldException e) {
            throw new CompatibilityException("Could not instantiate Dominion API", e);
        }
    }

    @Override
    public boolean canPlace(Player player, Location location) {
        DominionDTO dto = this.api.getDominion(location);
        if (dto == null) {
            return true;
        }
        return this.api.checkPrivilegeFlag(dto, Flags.PLACE, player);
    }

    @Override
    public boolean canBreak(Player player, Location location) {
        DominionDTO dto = this.api.getDominion(location);
        if (dto == null) {
            return true;
        }
        return this.api.checkPrivilegeFlag(dto, Flags.BREAK_BLOCK, player);
    }

    @Override
    public boolean canInteract(Player player, Location location) {
        DominionDTO dto = this.api.getDominion(location);
        if (dto == null) {
            return true;
        }
        return this.api.checkPrivilegeFlag(dto, Flags.PLACE, player);
    }

    @Override
    public boolean canInteractEntity(Player player, Entity entity) {
        DominionDTO dto = this.api.getDominion(entity.getLocation());
        if (dto == null) {
            return true;
        }
        return this.api.checkPrivilegeFlag(dto, Flags.PLACE, player);
    }

    @Override
    public boolean canDamage(Player player, Entity entity) {
        DominionDTO dto = this.api.getDominion(entity.getLocation());
        if (dto == null) {
            return true;
        }
        if (entity instanceof Monster) {
            return this.api.checkEnvironmentFlag(dto, Flags.MONSTER_DAMAGE);
        }
        if (entity instanceof Villager) {
            return this.api.checkPrivilegeFlag(dto, Flags.VILLAGER_KILLING, player);
        }
        if (entity instanceof Animals) {
            return this.api.checkPrivilegeFlag(dto, Flags.ANIMAL_KILLING, player);
        }
        return false;
    }
}

