/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.libraries.antigrieflib.comp;

import br.net.fabiozumbi12.RedProtect.Bukkit.API.RedProtectAPI;
import br.net.fabiozumbi12.RedProtect.Bukkit.RedProtect;
import java.util.Optional;
import net.momirealms.craftengine.libraries.antigrieflib.AbstractComp;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.plugin.java.JavaPlugin;

public class RedProtectComp
extends AbstractComp {
    private RedProtectAPI api;

    public RedProtectComp(JavaPlugin plugin) {
        super(plugin, "RedProtect");
    }

    @Override
    public void init() {
        this.api = RedProtect.get().getAPI();
    }

    @Override
    public boolean canPlace(Player player, Location location) {
        return Optional.ofNullable(this.api.getRegion(location)).map(region -> region.canBuild(player)).orElse(true);
    }

    @Override
    public boolean canBreak(Player player, Location location) {
        return Optional.ofNullable(this.api.getRegion(location)).map(region -> region.canBuild(player)).orElse(true);
    }

    @Override
    public boolean canInteract(Player player, Location location) {
        return Optional.ofNullable(this.api.getRegion(location)).map(region -> region.canBuild(player)).orElse(true);
    }

    @Override
    public boolean canInteractEntity(Player player, Entity entity) {
        return Optional.ofNullable(this.api.getRegion(entity.getLocation())).map(region -> region.canBuild(player)).orElse(true);
    }

    @Override
    public boolean canDamage(Player player, Entity entity) {
        return Optional.ofNullable(this.api.getRegion(entity.getLocation())).map(region -> {
            if (entity instanceof Player) {
                Player another = (Player)entity;
                return region.canPVP(player, another);
            }
            return region.canBuild(player);
        }).orElse(true);
    }
}

