/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.libraries.nbt.codec;

import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.MapLike;
import com.mojang.serialization.RecordBuilder;
import it.unimi.dsi.fastutil.bytes.ByteArrayList;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import java.lang.runtime.SwitchBootstraps;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.momirealms.craftengine.libraries.nbt.ByteArrayTag;
import net.momirealms.craftengine.libraries.nbt.ByteTag;
import net.momirealms.craftengine.libraries.nbt.CollectionTag;
import net.momirealms.craftengine.libraries.nbt.CompoundTag;
import net.momirealms.craftengine.libraries.nbt.DoubleTag;
import net.momirealms.craftengine.libraries.nbt.EndTag;
import net.momirealms.craftengine.libraries.nbt.FloatTag;
import net.momirealms.craftengine.libraries.nbt.IntArrayTag;
import net.momirealms.craftengine.libraries.nbt.IntTag;
import net.momirealms.craftengine.libraries.nbt.ListTag;
import net.momirealms.craftengine.libraries.nbt.LongArrayTag;
import net.momirealms.craftengine.libraries.nbt.LongTag;
import net.momirealms.craftengine.libraries.nbt.NumericTag;
import net.momirealms.craftengine.libraries.nbt.ShortTag;
import net.momirealms.craftengine.libraries.nbt.StringTag;
import net.momirealms.craftengine.libraries.nbt.Tag;

public class LegacyNBTOps
implements DynamicOps<Tag> {
    public static final LegacyNBTOps INSTANCE = new LegacyNBTOps();

    private LegacyNBTOps() {
    }

    public Tag empty() {
        return EndTag.INSTANCE;
    }

    public <U> U convertTo(DynamicOps<U> dynamicOps, Tag tag) {
        return (U)(switch (tag.getId()) {
            case 0 -> dynamicOps.empty();
            case 1 -> dynamicOps.createByte(((NumericTag)tag).getAsByte());
            case 2 -> dynamicOps.createShort(((NumericTag)tag).getAsShort());
            case 3 -> dynamicOps.createInt(((NumericTag)tag).getAsInt());
            case 4 -> dynamicOps.createLong(((NumericTag)tag).getAsLong());
            case 5 -> dynamicOps.createFloat(((NumericTag)tag).getAsFloat());
            case 6 -> dynamicOps.createDouble(((NumericTag)tag).getAsDouble());
            case 7 -> dynamicOps.createByteList(ByteBuffer.wrap(((ByteArrayTag)tag).getAsByteArray()));
            case 8 -> dynamicOps.createString(tag.getAsString());
            case 9 -> this.convertList(dynamicOps, tag);
            case 10 -> this.convertMap(dynamicOps, tag);
            case 11 -> dynamicOps.createIntList(Arrays.stream(((IntArrayTag)tag).getAsIntArray()));
            case 12 -> dynamicOps.createLongList(Arrays.stream(((LongArrayTag)tag).getAsLongArray()));
            default -> throw new IllegalStateException("Unknown tag type: " + String.valueOf(tag));
        });
    }

    public DataResult<Number> getNumberValue(Tag tag) {
        if (tag instanceof NumericTag) {
            NumericTag numericTag = (NumericTag)tag;
            return DataResult.success((Object)numericTag.getAsNumber());
        }
        return DataResult.error(() -> "Not a number");
    }

    public Tag createNumeric(Number number) {
        return new DoubleTag(number.doubleValue());
    }

    public Tag createByte(byte b2) {
        return new ByteTag(b2);
    }

    public Tag createShort(short s) {
        return new ShortTag(s);
    }

    public Tag createInt(int i) {
        return new IntTag(i);
    }

    public Tag createLong(long l) {
        return new LongTag(l);
    }

    public Tag createFloat(float f2) {
        return new FloatTag(f2);
    }

    public Tag createDouble(double d2) {
        return new DoubleTag(d2);
    }

    public Tag createBoolean(boolean b2) {
        return new ByteTag(b2);
    }

    public Tag createString(String string) {
        return new StringTag(string);
    }

    public Tag createIntList(IntStream data) {
        return new IntArrayTag(data.toArray());
    }

    public Tag createByteList(ByteBuffer data) {
        ByteBuffer byteBuffer = data.duplicate().clear();
        byte[] bytes = new byte[data.capacity()];
        byteBuffer.get(0, bytes, 0, bytes.length);
        return new ByteArrayTag(bytes);
    }

    public Tag createLongList(LongStream data) {
        return new LongArrayTag(data.toArray());
    }

    public Tag createList(Stream<Tag> data) {
        return new ListTag(data.collect(LegacyNBTOps.toMutableList()));
    }

    public DataResult<String> getStringValue(Tag tag) {
        if (tag instanceof StringTag) {
            StringTag stringTag = (StringTag)tag;
            return DataResult.success((Object)stringTag.getAsString());
        }
        return DataResult.error(() -> "Not a string");
    }

    public DataResult<Tag> mergeToList(Tag tag, Tag tag2) {
        return LegacyNBTOps.createCollector(tag).map(merger -> DataResult.success((Object)merger.accept(tag2).result())).orElseGet(() -> DataResult.error(() -> "mergeToList called with not a list: " + String.valueOf(tag), (Object)tag));
    }

    public DataResult<Tag> mergeToList(Tag tag, List<Tag> list) {
        return LegacyNBTOps.createCollector(tag).map(merger -> DataResult.success((Object)merger.acceptAll(list).result())).orElseGet(() -> DataResult.error(() -> "mergeToList called with not a list: " + String.valueOf(tag), (Object)tag));
    }

    public DataResult<Tag> mergeToMap(Tag map, Tag key, Tag value) {
        if (!(map instanceof CompoundTag) && !(map instanceof EndTag)) {
            return DataResult.error(() -> "mergeToMap called with not a map: " + String.valueOf(map), (Object)map);
        }
        if (key instanceof StringTag) {
            CompoundTag resultCompound;
            StringTag stringKey = (StringTag)key;
            String keyString = stringKey.getAsString();
            if (map instanceof CompoundTag) {
                CompoundTag existingCompound = (CompoundTag)map;
                resultCompound = existingCompound.copy();
            } else {
                resultCompound = new CompoundTag();
            }
            resultCompound.put(keyString, value);
            return DataResult.success((Object)resultCompound);
        }
        return DataResult.error(() -> "key is not a string: " + String.valueOf(key), (Object)map);
    }

    public DataResult<Tag> mergeToMap(Tag map, MapLike<Tag> otherMap) {
        CompoundTag compoundTag;
        if (!(map instanceof CompoundTag) && !(map instanceof EndTag)) {
            return DataResult.error(() -> "mergeToMap called with not a map: " + String.valueOf(map), (Object)map);
        }
        if (map instanceof CompoundTag) {
            CompoundTag existingCompound = (CompoundTag)map;
            compoundTag = existingCompound.copy();
        } else {
            compoundTag = new CompoundTag();
        }
        CompoundTag resultCompound = compoundTag;
        ArrayList invalidKeys = new ArrayList();
        otherMap.entries().forEach(pair -> {
            Tag keyTag = (Tag)pair.getFirst();
            if (keyTag instanceof StringTag) {
                StringTag stringKey = (StringTag)keyTag;
                resultCompound.put(stringKey.getAsString(), (Tag)pair.getSecond());
            } else {
                invalidKeys.add(keyTag);
            }
        });
        return invalidKeys.isEmpty() ? DataResult.success((Object)resultCompound) : DataResult.error(() -> "Invalid keys: " + String.valueOf(invalidKeys), (Object)resultCompound);
    }

    public DataResult<Tag> mergeToMap(Tag inputTag, Map<Tag, Tag> entriesToMerge) {
        CompoundTag compoundTag;
        if (!(inputTag instanceof CompoundTag) && !(inputTag instanceof EndTag)) {
            return DataResult.error(() -> "mergeToMap called with not a map: " + String.valueOf(inputTag), (Object)inputTag);
        }
        if (inputTag instanceof CompoundTag) {
            CompoundTag existingCompound = (CompoundTag)inputTag;
            compoundTag = existingCompound.copy();
        } else {
            compoundTag = new CompoundTag();
        }
        CompoundTag resultCompound = compoundTag;
        ArrayList<Tag> invalidKeys = new ArrayList<Tag>();
        for (Map.Entry<Tag, Tag> entry : entriesToMerge.entrySet()) {
            Tag keyTag = entry.getKey();
            if (keyTag instanceof StringTag) {
                StringTag stringKey = (StringTag)keyTag;
                resultCompound.put(stringKey.getAsString(), entry.getValue());
                continue;
            }
            invalidKeys.add(keyTag);
        }
        return invalidKeys.isEmpty() ? DataResult.success((Object)resultCompound) : DataResult.error(() -> "Found non-string keys: " + String.valueOf(invalidKeys), (Object)resultCompound);
    }

    public DataResult<Stream<Pair<Tag, Tag>>> getMapValues(Tag map) {
        DataResult dataResult;
        if (map instanceof CompoundTag) {
            CompoundTag compoundTag = (CompoundTag)map;
            dataResult = DataResult.success(compoundTag.entrySet().stream().map(entry -> Pair.of((Object)this.createString((String)entry.getKey()), (Object)((Tag)entry.getValue()))));
        } else {
            dataResult = DataResult.error(() -> "Not a map: " + String.valueOf(map));
        }
        return dataResult;
    }

    public DataResult<Consumer<BiConsumer<Tag, Tag>>> getMapEntries(Tag map) {
        DataResult dataResult;
        if (map instanceof CompoundTag) {
            CompoundTag compoundTag = (CompoundTag)map;
            dataResult = DataResult.success(biConsumer -> {
                for (Map.Entry<String, Tag> entry : compoundTag.entrySet()) {
                    biConsumer.accept(this.createString(entry.getKey()), entry.getValue());
                }
            });
        } else {
            dataResult = DataResult.error(() -> "Not a map: " + String.valueOf(map));
        }
        return dataResult;
    }

    public DataResult<MapLike<Tag>> getMap(Tag map) {
        DataResult dataResult;
        if (map instanceof CompoundTag) {
            final CompoundTag compoundTag = (CompoundTag)map;
            dataResult = DataResult.success((Object)new MapLike<Tag>(){

                @Nullable
                public Tag get(Tag tag) {
                    if (tag instanceof StringTag) {
                        StringTag stringTag = (StringTag)tag;
                        return compoundTag.get(stringTag.getAsString());
                    }
                    throw new UnsupportedOperationException("Cannot get map entry with non-string key: " + String.valueOf(tag));
                }

                @Nullable
                public Tag get(String string) {
                    return compoundTag.get(string);
                }

                public Stream<Pair<Tag, Tag>> entries() {
                    return compoundTag.entrySet().stream().map(entry -> Pair.of((Object)LegacyNBTOps.this.createString((String)entry.getKey()), (Object)((Tag)entry.getValue())));
                }

                public String toString() {
                    return "MapLike[" + String.valueOf(compoundTag) + "]";
                }
            });
        } else {
            dataResult = DataResult.error(() -> "Not a map: " + String.valueOf(map));
        }
        return dataResult;
    }

    public Tag createMap(Stream<Pair<Tag, Tag>> data) {
        CompoundTag compoundTag = new CompoundTag();
        data.forEach(pair -> {
            Object patt0$temp = pair.getFirst();
            if (!(patt0$temp instanceof StringTag)) {
                throw new UnsupportedOperationException("Cannot create map with non-string key: " + String.valueOf(pair.getFirst()));
            }
            StringTag stringTag = (StringTag)patt0$temp;
            compoundTag.put(stringTag.getAsString(), (Tag)pair.getSecond());
        });
        return compoundTag;
    }

    public DataResult<Stream<Tag>> getStream(Tag tag) {
        DataResult dataResult;
        if (tag instanceof CollectionTag) {
            CollectionTag collectionTag = (CollectionTag)tag;
            dataResult = DataResult.success(collectionTag.stream());
        } else {
            dataResult = DataResult.error(() -> "Not a list");
        }
        return dataResult;
    }

    public DataResult<Consumer<Consumer<Tag>>> getList(Tag tag) {
        DataResult dataResult;
        if (tag instanceof CollectionTag) {
            CollectionTag collectionTag = (CollectionTag)tag;
            dataResult = DataResult.success(collectionTag::forEach);
        } else {
            dataResult = DataResult.error(() -> "Not a list: " + String.valueOf(tag));
        }
        return dataResult;
    }

    public DataResult<ByteBuffer> getByteBuffer(Tag tag) {
        DataResult dataResult;
        if (tag instanceof ByteArrayTag) {
            ByteArrayTag byteArrayTag = (ByteArrayTag)tag;
            dataResult = DataResult.success((Object)ByteBuffer.wrap(byteArrayTag.getAsByteArray()));
        } else {
            dataResult = this.getStream(tag).flatMap(stream -> {
                List list = stream.toList();
                if (list.stream().allMatch(element -> this.getNumberValue((Tag)element).result().isPresent())) {
                    ByteBuffer buffer = ByteBuffer.wrap(new byte[list.size()]);
                    for (int i = 0; i < list.size(); ++i) {
                        buffer.put(i, ((Number)this.getNumberValue((Tag)list.get(i)).result().get()).byteValue());
                    }
                    return DataResult.success((Object)buffer);
                }
                return DataResult.error(() -> "Some elements are not bytes: " + String.valueOf(tag));
            });
        }
        return dataResult;
    }

    public DataResult<IntStream> getIntStream(Tag tag) {
        DataResult dataResult;
        if (tag instanceof IntArrayTag) {
            IntArrayTag intArrayTag = (IntArrayTag)tag;
            dataResult = DataResult.success((Object)Arrays.stream(intArrayTag.getAsIntArray()));
        } else {
            dataResult = this.getStream(tag).flatMap(stream -> {
                List list = stream.toList();
                if (list.stream().allMatch(element -> this.getNumberValue((Tag)element).result().isPresent())) {
                    return DataResult.success((Object)list.stream().mapToInt(element -> ((Number)this.getNumberValue((Tag)element).result().get()).intValue()));
                }
                return DataResult.error(() -> "Some elements are not ints: " + String.valueOf(tag));
            });
        }
        return dataResult;
    }

    public DataResult<LongStream> getLongStream(Tag tag) {
        DataResult dataResult;
        if (tag instanceof LongArrayTag) {
            LongArrayTag longArrayTag = (LongArrayTag)tag;
            dataResult = DataResult.success((Object)Arrays.stream(longArrayTag.getAsLongArray()));
        } else {
            dataResult = this.getStream(tag).flatMap(stream -> {
                List list = stream.toList();
                if (list.stream().allMatch(element -> this.getNumberValue((Tag)element).result().isPresent())) {
                    return DataResult.success((Object)list.stream().mapToLong(element -> ((Number)this.getNumberValue((Tag)element).result().get()).longValue()));
                }
                return DataResult.error(() -> "Some elements are not longs: " + String.valueOf(tag));
            });
        }
        return dataResult;
    }

    public static <T> Collector<T, ?, List<T>> toMutableList() {
        return Collectors.toCollection(Lists::newArrayList);
    }

    public Tag remove(Tag map, String removeKey) {
        if (map instanceof CompoundTag) {
            CompoundTag compoundTag = (CompoundTag)map;
            CompoundTag copied = compoundTag.copy();
            copied.remove(removeKey);
            return copied;
        }
        return map;
    }

    public String toString() {
        return "SPARROW_NBT";
    }

    public RecordBuilder<Tag> mapBuilder() {
        return new NbtRecordBuilder(this);
    }

    private static Optional<ListCollector> createCollector(Tag tag) {
        if (tag instanceof EndTag) {
            return Optional.of(new GenericListCollector());
        }
        if (tag instanceof CollectionTag) {
            CollectionTag collectionTag = (CollectionTag)tag;
            if (collectionTag.isEmpty()) {
                return Optional.of(new GenericListCollector());
            }
            CollectionTag collectionTag2 = collectionTag;
            Objects.requireNonNull(collectionTag2);
            CollectionTag collectionTag3 = collectionTag2;
            int n = 0;
            return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ListTag.class, ByteArrayTag.class, IntArrayTag.class, LongArrayTag.class}, (Object)collectionTag3, n)) {
                case 0 -> {
                    ListTag listTag = (ListTag)collectionTag3;
                    yield Optional.of(new GenericListCollector(listTag));
                }
                case 1 -> {
                    ByteArrayTag byteArrayTag = (ByteArrayTag)collectionTag3;
                    yield Optional.of(new ByteListCollector(byteArrayTag.getAsByteArray()));
                }
                case 2 -> {
                    IntArrayTag intArrayTag = (IntArrayTag)collectionTag3;
                    yield Optional.of(new IntListCollector(intArrayTag.getAsIntArray()));
                }
                case 3 -> {
                    LongArrayTag longArrayTag = (LongArrayTag)collectionTag3;
                    yield Optional.of(new LongListCollector(longArrayTag.getAsLongArray()));
                }
                default -> throw new IllegalStateException("Unexpected value: " + String.valueOf(collectionTag));
            };
        }
        return Optional.empty();
    }

    class NbtRecordBuilder
    extends RecordBuilder.AbstractStringBuilder<Tag, CompoundTag> {
        protected NbtRecordBuilder(LegacyNBTOps this$0) {
            super((DynamicOps)this$0);
        }

        protected CompoundTag initBuilder() {
            return new CompoundTag();
        }

        protected CompoundTag append(String key, Tag value, CompoundTag tag) {
            tag.put(key, value);
            return tag;
        }

        protected DataResult<Tag> build(CompoundTag compoundTag, Tag tag) {
            if (tag != null && tag != EndTag.INSTANCE) {
                if (!(tag instanceof CompoundTag)) {
                    return DataResult.error(() -> "mergeToMap called with not a map: " + String.valueOf(tag), (Object)tag);
                }
                CompoundTag compoundTag1 = (CompoundTag)tag;
                CompoundTag compoundTag2 = compoundTag1.copy();
                for (Map.Entry<String, Tag> entry : compoundTag.entrySet()) {
                    compoundTag2.put(entry.getKey(), entry.getValue());
                }
                return DataResult.success((Object)compoundTag2);
            }
            return DataResult.success((Object)compoundTag);
        }
    }

    static class GenericListCollector
    implements ListCollector {
        private final ListTag result = new ListTag();

        GenericListCollector() {
        }

        GenericListCollector(ListTag list) {
            this.result.addAll(list);
        }

        GenericListCollector(IntArrayList list) {
            list.forEach(i -> this.result.add(new IntTag(i)));
        }

        GenericListCollector(ByteArrayList list) {
            list.forEach(b2 -> this.result.add(new ByteTag(b2)));
        }

        GenericListCollector(LongArrayList list) {
            list.forEach(l -> this.result.add(new LongTag(l)));
        }

        @Override
        public ListCollector accept(Tag tag) {
            this.result.add(tag);
            return this;
        }

        @Override
        public Tag result() {
            return this.result;
        }
    }

    static class ByteListCollector
    implements ListCollector {
        private final ByteArrayList values = new ByteArrayList();

        ByteListCollector(byte[] values) {
            this.values.addElements(0, values);
        }

        @Override
        public ListCollector accept(Tag tag) {
            if (tag instanceof ByteTag) {
                ByteTag byteTag = (ByteTag)tag;
                this.values.add(byteTag.getAsByte());
                return this;
            }
            return new GenericListCollector(this.values).accept(tag);
        }

        @Override
        public Tag result() {
            return new ByteArrayTag(this.values.toByteArray());
        }
    }

    static class IntListCollector
    implements ListCollector {
        private final IntArrayList values = new IntArrayList();

        IntListCollector(int[] values) {
            this.values.addElements(0, values);
        }

        @Override
        public ListCollector accept(Tag tag) {
            if (tag instanceof IntTag) {
                IntTag intTag = (IntTag)tag;
                this.values.add(intTag.getAsInt());
                return this;
            }
            return new GenericListCollector(this.values).accept(tag);
        }

        @Override
        public Tag result() {
            return new IntArrayTag(this.values.toIntArray());
        }
    }

    static class LongListCollector
    implements ListCollector {
        private final LongArrayList values = new LongArrayList();

        LongListCollector(long[] values) {
            this.values.addElements(0, values);
        }

        @Override
        public ListCollector accept(Tag tag) {
            if (tag instanceof LongTag) {
                LongTag longTag = (LongTag)tag;
                this.values.add(longTag.getAsLong());
                return this;
            }
            return new GenericListCollector(this.values).accept(tag);
        }

        @Override
        public Tag result() {
            return new LongArrayTag(this.values.toLongArray());
        }
    }

    static interface ListCollector {
        public ListCollector accept(Tag var1);

        default public ListCollector acceptAll(Iterable<Tag> tags) {
            ListCollector listCollector = this;
            for (Tag tag : tags) {
                listCollector = listCollector.accept(tag);
            }
            return listCollector;
        }

        default public ListCollector acceptAll(Stream<Tag> tags) {
            Objects.requireNonNull(tags);
            return this.acceptAll(tags::iterator);
        }

        public Tag result();
    }
}

