/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.bukkit.api;

import java.util.List;
import net.momirealms.craftengine.bukkit.entity.furniture.BukkitFurniture;
import net.momirealms.craftengine.bukkit.entity.furniture.BukkitFurnitureManager;
import net.momirealms.craftengine.bukkit.nms.CollisionEntity;
import net.momirealms.craftengine.bukkit.nms.FastNMS;
import net.momirealms.craftengine.bukkit.plugin.BukkitCraftEngine;
import net.momirealms.craftengine.bukkit.world.BukkitWorld;
import net.momirealms.craftengine.core.entity.furniture.AnchorType;
import net.momirealms.craftengine.core.entity.furniture.CustomFurniture;
import net.momirealms.craftengine.core.entity.furniture.Furniture;
import net.momirealms.craftengine.core.entity.furniture.FurnitureExtraData;
import net.momirealms.craftengine.core.item.Item;
import net.momirealms.craftengine.core.loot.LootTable;
import net.momirealms.craftengine.core.plugin.context.ContextHolder;
import net.momirealms.craftengine.core.plugin.context.parameter.DirectContextParameters;
import net.momirealms.craftengine.core.util.Key;
import net.momirealms.craftengine.core.world.World;
import net.momirealms.craftengine.core.world.WorldPosition;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.persistence.PersistentDataType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CraftEngineFurniture {
    private CraftEngineFurniture() {
    }

    public static CustomFurniture byId(@NotNull Key id) {
        return BukkitFurnitureManager.instance().furnitureById(id).orElse(null);
    }

    @Nullable
    public static BukkitFurniture place(Location location, Key furnitureId) {
        CustomFurniture furniture = CraftEngineFurniture.byId(furnitureId);
        if (furniture == null) {
            return null;
        }
        return CraftEngineFurniture.place(location, furnitureId, furniture.getAnyAnchorType());
    }

    @Nullable
    public static BukkitFurniture place(Location location, Key furnitureId, AnchorType anchorType) {
        CustomFurniture furniture = CraftEngineFurniture.byId(furnitureId);
        if (furniture == null) {
            return null;
        }
        return BukkitFurnitureManager.instance().place(location, furniture, FurnitureExtraData.builder().anchorType(anchorType).build(), true);
    }

    @NotNull
    public static BukkitFurniture place(Location location, CustomFurniture furniture, AnchorType anchorType) {
        return BukkitFurnitureManager.instance().place(location, furniture, FurnitureExtraData.builder().anchorType(anchorType).build(), true);
    }

    @Nullable
    public static BukkitFurniture place(Location location, Key furnitureId, AnchorType anchorType, boolean playSound) {
        CustomFurniture furniture = CraftEngineFurniture.byId(furnitureId);
        if (furniture == null) {
            return null;
        }
        return BukkitFurnitureManager.instance().place(location, furniture, FurnitureExtraData.builder().anchorType(anchorType).build(), playSound);
    }

    @NotNull
    public static BukkitFurniture place(Location location, CustomFurniture furniture, AnchorType anchorType, boolean playSound) {
        return BukkitFurnitureManager.instance().place(location, furniture, FurnitureExtraData.builder().anchorType(anchorType).build(), playSound);
    }

    public static boolean isFurniture(@NotNull Entity entity) {
        String furnitureId = (String)entity.getPersistentDataContainer().get(BukkitFurnitureManager.FURNITURE_KEY, PersistentDataType.STRING);
        return furnitureId != null;
    }

    public static boolean isCollisionEntity(@NotNull Entity entity) {
        Object nmsEntity = FastNMS.INSTANCE.method$CraftEntity$getHandle(entity);
        return nmsEntity instanceof CollisionEntity;
    }

    public static boolean isSeat(@NotNull Entity entity) {
        Integer baseEntityId = (Integer)entity.getPersistentDataContainer().get(BukkitFurnitureManager.FURNITURE_SEAT_BASE_ENTITY_KEY, PersistentDataType.INTEGER);
        return baseEntityId != null;
    }

    @Nullable
    public static BukkitFurniture getLoadedFurnitureByBaseEntity(@NotNull Entity baseEntity) {
        return BukkitFurnitureManager.instance().loadedFurnitureByRealEntityId(baseEntity.getEntityId());
    }

    @Nullable
    public static BukkitFurniture getLoadedFurnitureBySeat(@NotNull Entity seat) {
        Integer baseEntityId = (Integer)seat.getPersistentDataContainer().get(BukkitFurnitureManager.FURNITURE_SEAT_BASE_ENTITY_KEY, PersistentDataType.INTEGER);
        if (baseEntityId == null) {
            return null;
        }
        return BukkitFurnitureManager.instance().loadedFurnitureByRealEntityId(baseEntityId);
    }

    public static boolean remove(@NotNull Entity entity) {
        if (!CraftEngineFurniture.isFurniture(entity)) {
            return false;
        }
        BukkitFurniture furniture = BukkitFurnitureManager.instance().loadedFurnitureByRealEntityId(entity.getEntityId());
        if (furniture == null) {
            return false;
        }
        furniture.destroy();
        return true;
    }

    public static boolean remove(@NotNull Entity entity, boolean dropLoot, boolean playSound) {
        if (!CraftEngineFurniture.isFurniture(entity)) {
            return false;
        }
        BukkitFurniture furniture = BukkitFurnitureManager.instance().loadedFurnitureByRealEntityId(entity.getEntityId());
        if (furniture == null) {
            return false;
        }
        CraftEngineFurniture.remove((Furniture)furniture, (net.momirealms.craftengine.core.entity.player.Player)null, dropLoot, playSound);
        return true;
    }

    public static boolean remove(@NotNull Entity entity, @Nullable Player player, boolean dropLoot, boolean playSound) {
        if (!CraftEngineFurniture.isFurniture(entity)) {
            return false;
        }
        BukkitFurniture furniture = BukkitFurnitureManager.instance().loadedFurnitureByRealEntityId(entity.getEntityId());
        if (furniture == null) {
            return false;
        }
        CraftEngineFurniture.remove((Furniture)furniture, player, dropLoot, playSound);
        return true;
    }

    public static void remove(@NotNull Furniture furniture, boolean dropLoot, boolean playSound) {
        CraftEngineFurniture.remove(furniture, (net.momirealms.craftengine.core.entity.player.Player)null, dropLoot, playSound);
    }

    public static void remove(@NotNull Furniture furniture, @Nullable Player player, boolean dropLoot, boolean playSound) {
        CraftEngineFurniture.remove(furniture, player == null ? null : BukkitCraftEngine.instance().adapt(player), dropLoot, playSound);
    }

    public static void remove(@NotNull Furniture furniture, @Nullable net.momirealms.craftengine.core.entity.player.Player player, boolean dropLoot, boolean playSound) {
        if (!furniture.isValid()) {
            return;
        }
        Location location = ((BukkitFurniture)furniture).dropLocation();
        furniture.destroy();
        LootTable<?> lootTable = furniture.config().lootTable();
        BukkitWorld world = new BukkitWorld(location.getWorld());
        WorldPosition position = new WorldPosition((World)world, location.getX(), location.getY(), location.getZ());
        if (dropLoot && lootTable != null) {
            ContextHolder.Builder builder = ContextHolder.builder().withParameter(DirectContextParameters.POSITION, position).withParameter(DirectContextParameters.FURNITURE, furniture).withOptionalParameter(DirectContextParameters.FURNITURE_ITEM, furniture.extraData().item().orElse(null));
            if (player != null) {
                builder.withParameter(DirectContextParameters.PLAYER, player);
            }
            List<Item<?>> items = lootTable.getRandomItems(builder.build(), world, player);
            for (Item<?> item : items) {
                world.dropItemNaturally(position, item);
            }
        }
        if (playSound) {
            world.playBlockSound(position, furniture.config().settings().sounds().breakSound());
        }
    }
}

