/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.bukkit.api;

import net.momirealms.craftengine.bukkit.item.BukkitItemManager;
import net.momirealms.craftengine.bukkit.util.ItemUtils;
import net.momirealms.craftengine.core.item.CustomItem;
import net.momirealms.craftengine.core.util.Key;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CraftEngineItems {
    private CraftEngineItems() {
    }

    @Nullable
    public static CustomItem<ItemStack> byId(@NotNull Key id) {
        return BukkitItemManager.instance().getCustomItem(id).orElse(null);
    }

    @Nullable
    public static CustomItem<ItemStack> byItemStack(@NotNull ItemStack itemStack) {
        if (ItemUtils.isEmpty(itemStack)) {
            return null;
        }
        return BukkitItemManager.instance().wrap(itemStack).getCustomItem().orElse(null);
    }

    public static boolean isCustomItem(@NotNull ItemStack itemStack) {
        if (ItemUtils.isEmpty(itemStack)) {
            return false;
        }
        return BukkitItemManager.instance().wrap(itemStack).isCustomItem();
    }

    @Nullable
    public static Key getCustomItemId(@NotNull ItemStack itemStack) {
        if (ItemUtils.isEmpty(itemStack)) {
            return null;
        }
        return BukkitItemManager.instance().wrap(itemStack).customId().orElse(null);
    }
}

