/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.bukkit.block.behavior;

import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Callable;
import net.momirealms.craftengine.bukkit.block.behavior.BukkitBlockBehavior;
import net.momirealms.craftengine.bukkit.nms.FastNMS;
import net.momirealms.craftengine.bukkit.plugin.reflection.minecraft.MFluids;
import net.momirealms.craftengine.bukkit.util.BlockStateUtils;
import net.momirealms.craftengine.bukkit.util.DirectionUtils;
import net.momirealms.craftengine.bukkit.util.LocationUtils;
import net.momirealms.craftengine.core.block.BlockBehavior;
import net.momirealms.craftengine.core.block.CustomBlock;
import net.momirealms.craftengine.core.block.ImmutableBlockState;
import net.momirealms.craftengine.core.block.behavior.BlockBehaviorFactory;
import net.momirealms.craftengine.core.block.properties.Property;
import net.momirealms.craftengine.core.block.state.properties.SingleBlockHalf;
import net.momirealms.craftengine.core.block.state.properties.StairsShape;
import net.momirealms.craftengine.core.item.context.BlockPlaceContext;
import net.momirealms.craftengine.core.util.Direction;
import net.momirealms.craftengine.core.util.HorizontalDirection;
import net.momirealms.craftengine.core.util.ResourceConfigUtils;
import net.momirealms.craftengine.core.util.VersionHelper;
import net.momirealms.craftengine.core.world.BlockPos;

public class StairsBlockBehavior
extends BukkitBlockBehavior {
    public static final Factory FACTORY = new Factory();
    private final Property<HorizontalDirection> facingProperty;
    private final Property<SingleBlockHalf> halfProperty;
    private final Property<StairsShape> shapeProperty;

    public StairsBlockBehavior(CustomBlock block, Property<HorizontalDirection> facing, Property<SingleBlockHalf> half, Property<StairsShape> shape) {
        super(block);
        this.facingProperty = facing;
        this.halfProperty = half;
        this.shapeProperty = shape;
    }

    @Override
    public ImmutableBlockState updateStateForPlacement(BlockPlaceContext context, ImmutableBlockState state) {
        Direction clickedFace = context.getClickedFace();
        BlockPos clickedPos = context.getClickedPos();
        ImmutableBlockState blockState = state.owner().value().defaultState().with(this.facingProperty, context.getHorizontalDirection().toHorizontalDirection()).with(this.halfProperty, !(clickedFace == Direction.DOWN || clickedFace != Direction.UP && context.getClickLocation().y - (double)clickedPos.y() > 0.5) ? SingleBlockHalf.BOTTOM : SingleBlockHalf.TOP);
        if (this.waterloggedProperty != null) {
            Object fluidState = FastNMS.INSTANCE.method$Level$getFluidState(context.getLevel().serverWorld(), LocationUtils.toBlockPos(clickedPos));
            blockState = blockState.with(this.waterloggedProperty, FastNMS.INSTANCE.method$FluidState$getType(fluidState) == MFluids.WATER);
        }
        return blockState.with(this.shapeProperty, this.getStairsShape(blockState, context.getLevel().serverWorld(), clickedPos));
    }

    @Override
    public Object updateShape(Object thisBlock, Object[] args, Callable<Object> superMethod) throws Exception {
        Object level = args[updateShape$level];
        Object blockPos = args[updateShape$blockPos];
        Object blockState = args[0];
        Optional<ImmutableBlockState> optionalCustomState = BlockStateUtils.getOptionalCustomBlockState(blockState);
        if (optionalCustomState.isEmpty()) {
            return blockState;
        }
        ImmutableBlockState customState = optionalCustomState.get();
        if (this.waterloggedProperty != null && ((Boolean)customState.get(this.waterloggedProperty)).booleanValue()) {
            FastNMS.INSTANCE.method$LevelAccessor$scheduleFluidTick(args[updateShape$level], args[updateShape$blockPos], MFluids.WATER, 5);
        }
        Direction direction = DirectionUtils.fromNMSDirection(VersionHelper.isOrAbove1_21_2() ? args[4] : args[1]);
        StairsShape stairsShape = this.getStairsShape(customState, level, LocationUtils.fromBlockPos(blockPos));
        return direction.axis().isHorizontal() ? customState.with(this.shapeProperty, stairsShape).customBlockState().handle() : superMethod.call();
    }

    private StairsShape getStairsShape(ImmutableBlockState state, Object level, BlockPos pos) {
        ImmutableBlockState customState2;
        Optional<StairsBlockBehavior> optionalStairsBlockBehavior;
        Object relativeBlockState2;
        Optional<ImmutableBlockState> optionalCustomState2;
        ImmutableBlockState customState1;
        Optional<StairsBlockBehavior> optionalStairsBlockBehavior2;
        Direction direction = state.get(this.facingProperty).toDirection();
        Object relativeBlockState1 = FastNMS.INSTANCE.method$BlockGetter$getBlockState(level, LocationUtils.toBlockPos(pos.relative(direction)));
        Optional<ImmutableBlockState> optionalCustomState1 = BlockStateUtils.getOptionalCustomBlockState(relativeBlockState1);
        if (optionalCustomState1.isPresent() && (optionalStairsBlockBehavior2 = (customState1 = optionalCustomState1.get()).behavior().getAs(StairsBlockBehavior.class)).isPresent()) {
            Direction direction1;
            StairsBlockBehavior stairsBlockBehavior = optionalStairsBlockBehavior2.get();
            if (state.get(this.halfProperty) == customState1.get(stairsBlockBehavior.halfProperty) && (direction1 = customState1.get(stairsBlockBehavior.facingProperty).toDirection()).axis() != state.get(this.facingProperty).toDirection().axis() && this.canTakeShape(state, level, pos, direction1.opposite())) {
                if (direction1 == direction.counterClockWise()) {
                    return StairsShape.OUTER_LEFT;
                }
                return StairsShape.OUTER_RIGHT;
            }
        }
        if ((optionalCustomState2 = BlockStateUtils.getOptionalCustomBlockState(relativeBlockState2 = FastNMS.INSTANCE.method$BlockGetter$getBlockState(level, LocationUtils.toBlockPos(pos.relative(direction.opposite()))))).isPresent() && (optionalStairsBlockBehavior = (customState2 = optionalCustomState2.get()).behavior().getAs(StairsBlockBehavior.class)).isPresent()) {
            Direction direction2;
            StairsBlockBehavior stairsBlockBehavior = optionalStairsBlockBehavior.get();
            if (state.get(this.halfProperty) == customState2.get(stairsBlockBehavior.halfProperty) && (direction2 = customState2.get(stairsBlockBehavior.facingProperty).toDirection()).axis() != state.get(this.facingProperty).toDirection().axis() && this.canTakeShape(state, level, pos, direction2)) {
                if (direction2 == direction.counterClockWise()) {
                    return StairsShape.INNER_LEFT;
                }
                return StairsShape.INNER_RIGHT;
            }
        }
        return StairsShape.STRAIGHT;
    }

    private boolean canTakeShape(ImmutableBlockState state, Object level, BlockPos pos, Direction face) {
        Object blockState = FastNMS.INSTANCE.method$BlockGetter$getBlockState(level, LocationUtils.toBlockPos(pos.relative(face)));
        Optional<ImmutableBlockState> optionalAnotherState = BlockStateUtils.getOptionalCustomBlockState(blockState);
        if (optionalAnotherState.isEmpty()) {
            return true;
        }
        ImmutableBlockState anotherState = optionalAnotherState.get();
        Optional<StairsBlockBehavior> optionalBehavior = anotherState.behavior().getAs(StairsBlockBehavior.class);
        if (optionalBehavior.isEmpty()) {
            return true;
        }
        StairsBlockBehavior anotherBehavior = optionalBehavior.get();
        return anotherState.get(anotherBehavior.facingProperty) != state.get(this.facingProperty) || anotherState.get(anotherBehavior.halfProperty) != state.get(this.halfProperty);
    }

    public static class Factory
    implements BlockBehaviorFactory {
        @Override
        public BlockBehavior create(CustomBlock block, Map<String, Object> arguments) {
            Property<HorizontalDirection> facing = ResourceConfigUtils.requireNonNullOrThrow(block.getProperty("facing"), "warning.config.block.behavior.stairs.missing_facing");
            Property<SingleBlockHalf> half = ResourceConfigUtils.requireNonNullOrThrow(block.getProperty("half"), "warning.config.block.behavior.stairs.missing_half");
            Property<StairsShape> shape = ResourceConfigUtils.requireNonNullOrThrow(block.getProperty("shape"), "warning.config.block.behavior.stairs.missing_shape");
            return new StairsBlockBehavior(block, facing, half, shape);
        }
    }
}

