/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.bukkit.compatibility.skript.event;

import ch.njol.skript.Skript;
import ch.njol.skript.lang.Literal;
import ch.njol.skript.lang.SkriptEvent;
import ch.njol.skript.lang.SkriptParser;
import java.util.Arrays;
import net.momirealms.craftengine.bukkit.api.event.FurnitureBreakEvent;
import net.momirealms.craftengine.bukkit.api.event.FurniturePlaceEvent;
import org.bukkit.event.Event;
import org.jetbrains.annotations.Nullable;

public class EvtCustomFurniture
extends SkriptEvent {
    @Nullable
    private Literal<String> ids;
    private String[] idArray;

    public static void register() {
        Skript.registerEvent((String)"Break Furniture", EvtCustomFurniture.class, FurnitureBreakEvent.class, (String[])new String[]{"(break[ing]) [[of] %-strings%]"}).description(new String[]{"Called when a furniture is broken by a player."});
        Skript.registerEvent((String)"Place Furniture", EvtCustomFurniture.class, FurniturePlaceEvent.class, (String[])new String[]{"(plac(e|ing)|build[ing]) [[of] %-strings%]"}).description(new String[]{"Called when a player places a furniture."});
    }

    public boolean init(Literal<?>[] args, int matchedPattern, SkriptParser.ParseResult parser) {
        if (args[0] != null) {
            this.ids = args[0];
            this.idArray = (String[])this.ids.getAll();
        }
        return true;
    }

    public boolean check(Event event) {
        String id;
        if (this.ids == null) {
            return true;
        }
        if (event instanceof FurnitureBreakEvent) {
            FurnitureBreakEvent e = (FurnitureBreakEvent)event;
            id = e.furniture().id().toString();
        } else if (event instanceof FurniturePlaceEvent) {
            FurniturePlaceEvent e = (FurniturePlaceEvent)event;
            id = e.furniture().id().toString();
        } else {
            return false;
        }
        return Arrays.asList(this.idArray).contains(id);
    }

    public String toString(@Nullable Event event, boolean debug) {
        return "break/place" + (String)(this.ids != null ? " of " + this.ids.toString(event, debug) : "");
    }
}

