/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.bukkit.entity.furniture;

import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.function.Consumer;
import net.momirealms.craftengine.bukkit.entity.data.ItemDisplayEntityData;
import net.momirealms.craftengine.bukkit.item.BukkitItemManager;
import net.momirealms.craftengine.bukkit.nms.FastNMS;
import net.momirealms.craftengine.bukkit.plugin.reflection.minecraft.CoreReflections;
import net.momirealms.craftengine.bukkit.plugin.reflection.minecraft.MEntityTypes;
import net.momirealms.craftengine.core.entity.Billboard;
import net.momirealms.craftengine.core.entity.ItemDisplayContext;
import net.momirealms.craftengine.core.entity.furniture.AbstractFurnitureElement;
import net.momirealms.craftengine.core.entity.furniture.Furniture;
import net.momirealms.craftengine.core.entity.furniture.FurnitureElement;
import net.momirealms.craftengine.core.item.Item;
import net.momirealms.craftengine.core.item.data.FireworkExplosion;
import net.momirealms.craftengine.core.plugin.CraftEngine;
import net.momirealms.craftengine.core.util.Key;
import net.momirealms.craftengine.core.world.WorldPosition;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionf;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class BukkitFurnitureElement
extends AbstractFurnitureElement {
    private final List<Object> commonValues = new ArrayList<Object>();

    public BukkitFurnitureElement(Key item, Billboard billboard, ItemDisplayContext transform, Vector3f scale, Vector3f translation, Vector3f position, Quaternionf rotation, boolean applyDyedColor) {
        super(item, billboard, transform, scale, translation, position, rotation, applyDyedColor);
        ItemDisplayEntityData.Scale.addEntityDataIfNotDefaultValue(this.scale(), this.commonValues);
        ItemDisplayEntityData.RotationLeft.addEntityDataIfNotDefaultValue(this.rotation(), this.commonValues);
        ItemDisplayEntityData.BillboardConstraints.addEntityDataIfNotDefaultValue(this.billboard().id(), this.commonValues);
        ItemDisplayEntityData.Translation.addEntityDataIfNotDefaultValue(this.translation(), this.commonValues);
        ItemDisplayEntityData.DisplayType.addEntityDataIfNotDefaultValue(this.transform().id(), this.commonValues);
    }

    @Override
    public void initPackets(Furniture furniture, int entityId, @NotNull Quaternionf conjugated, Consumer<Object> packets) {
        WorldPosition position = furniture.position();
        Vector3f offset = conjugated.transform(new Vector3f((Vector3fc)this.position()));
        packets.accept(FastNMS.INSTANCE.constructor$ClientboundAddEntityPacket(entityId, UUID.randomUUID(), position.x() + (double)offset.x, position.y() + (double)offset.y, position.z() - (double)offset.z, 0.0f, position.xRot(), MEntityTypes.ITEM_DISPLAY, 0, CoreReflections.instance$Vec3$Zero, 0.0));
        if (this.applyDyedColor()) {
            packets.accept(FastNMS.INSTANCE.constructor$ClientboundSetEntityDataPacket(entityId, this.getCachedValues(furniture.extraData().dyedColor().orElse(null), furniture.extraData().fireworkExplosionColors().orElse(null))));
        } else {
            packets.accept(FastNMS.INSTANCE.constructor$ClientboundSetEntityDataPacket(entityId, this.getCachedValues(null, null)));
        }
    }

    private synchronized List<Object> getCachedValues(@Nullable Integer color, int @Nullable [] colors) {
        ArrayList<Object> cachedValues = new ArrayList<Object>(this.commonValues);
        Item<ItemStack> item = BukkitItemManager.instance().createWrappedItem(this.item(), null);
        if (item == null) {
            CraftEngine.instance().debug(() -> "Failed to create furniture element because item " + String.valueOf(this.item()) + " not found");
            item = BukkitItemManager.instance().wrap(new ItemStack(Material.BARRIER));
        } else {
            if (color != null) {
                item.dyedColor(color);
            }
            if (colors != null) {
                item.fireworkExplosion(new FireworkExplosion(FireworkExplosion.Shape.SMALL_BALL, (IntList)new IntArrayList(colors), (IntList)new IntArrayList(), false, false));
            }
        }
        ItemDisplayEntityData.DisplayedItem.addEntityDataIfNotDefaultValue(item.getLiteralObject(), cachedValues);
        return cachedValues;
    }

    public static FurnitureElement.Builder builder() {
        return new BuilderImpl();
    }

    public static class BuilderImpl
    implements FurnitureElement.Builder {
        private boolean applyDyedColor;
        private Key item;
        private Billboard billboard;
        private ItemDisplayContext transform;
        private Vector3f scale;
        private Vector3f translation;
        private Vector3f position;
        private Quaternionf rotation;

        @Override
        public FurnitureElement.Builder applyDyedColor(boolean applyDyedColor) {
            this.applyDyedColor = applyDyedColor;
            return this;
        }

        @Override
        public FurnitureElement.Builder item(Key item) {
            this.item = item;
            return this;
        }

        @Override
        public FurnitureElement.Builder billboard(Billboard billboard) {
            this.billboard = billboard;
            return this;
        }

        @Override
        public FurnitureElement.Builder transform(ItemDisplayContext transform) {
            this.transform = transform;
            return this;
        }

        @Override
        public FurnitureElement.Builder scale(Vector3f scale) {
            this.scale = scale;
            return this;
        }

        @Override
        public FurnitureElement.Builder translation(Vector3f translation) {
            this.translation = translation;
            return this;
        }

        @Override
        public FurnitureElement.Builder position(Vector3f position) {
            this.position = position;
            return this;
        }

        @Override
        public FurnitureElement.Builder rotation(Quaternionf rotation) {
            this.rotation = rotation;
            return this;
        }

        @Override
        public FurnitureElement build() {
            return new BukkitFurnitureElement(this.item, this.billboard, this.transform, this.scale, this.translation, this.position, this.rotation, this.applyDyedColor);
        }
    }
}

