/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.bukkit.entity.furniture;

import com.destroystokyo.paper.event.entity.EntityAddToWorldEvent;
import com.destroystokyo.paper.event.entity.EntityRemoveFromWorldEvent;
import java.util.List;
import net.momirealms.craftengine.bukkit.entity.furniture.BukkitFurnitureManager;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.entity.ItemDisplay;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.player.PlayerInteractAtEntityEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.world.ChunkUnloadEvent;
import org.bukkit.event.world.EntitiesLoadEvent;
import org.bukkit.event.world.WorldLoadEvent;
import org.bukkit.event.world.WorldUnloadEvent;
import org.bukkit.persistence.PersistentDataType;

public class FurnitureEventListener
implements Listener {
    private final BukkitFurnitureManager manager;

    public FurnitureEventListener(BukkitFurnitureManager manager) {
        this.manager = manager;
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.LOWEST)
    public void onEntitiesLoadEarly(EntitiesLoadEvent event) {
        List entities = event.getEntities();
        for (Entity entity : entities) {
            if (entity instanceof ItemDisplay) {
                ItemDisplay itemDisplay = (ItemDisplay)entity;
                this.manager.handleBaseEntityLoadEarly(itemDisplay);
                continue;
            }
            if (!BukkitFurnitureManager.COLLISION_ENTITY_CLASS.isInstance(entity)) continue;
            this.manager.handleCollisionEntityLoadOnEntitiesLoad(entity);
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.LOWEST)
    public void onWorldLoad(WorldLoadEvent event) {
        List entities = event.getWorld().getEntities();
        for (Entity entity : entities) {
            if (entity instanceof ItemDisplay) {
                ItemDisplay itemDisplay = (ItemDisplay)entity;
                this.manager.handleBaseEntityLoadEarly(itemDisplay);
                continue;
            }
            if (!BukkitFurnitureManager.COLLISION_ENTITY_CLASS.isInstance(entity)) continue;
            this.manager.handleCollisionEntityLoadOnEntitiesLoad(entity);
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.LOWEST)
    public void onEntityLoad(EntityAddToWorldEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof ItemDisplay) {
            ItemDisplay itemDisplay = (ItemDisplay)entity;
            this.manager.handleBaseEntityLoadLate(itemDisplay, 0);
        } else if (BukkitFurnitureManager.COLLISION_ENTITY_CLASS.isInstance(entity)) {
            this.manager.handleCollisionEntityLoadLate(entity, 0);
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.HIGHEST)
    public void onChunkUnload(ChunkUnloadEvent event) {
        Entity[] entities;
        for (Entity entity : entities = event.getChunk().getEntities()) {
            if (entity instanceof ItemDisplay) {
                this.manager.handleBaseEntityUnload(entity);
                continue;
            }
            if (!BukkitFurnitureManager.COLLISION_ENTITY_CLASS.isInstance(entity)) continue;
            this.manager.handleCollisionEntityUnload(entity);
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.HIGHEST)
    public void onWorldUnload(WorldUnloadEvent event) {
        List entities = event.getWorld().getEntities();
        for (Entity entity : entities) {
            if (entity instanceof ItemDisplay) {
                this.manager.handleBaseEntityUnload(entity);
                continue;
            }
            if (!BukkitFurnitureManager.COLLISION_ENTITY_CLASS.isInstance(entity)) continue;
            this.manager.handleCollisionEntityUnload(entity);
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.HIGHEST)
    public void onEntityUnload(EntityRemoveFromWorldEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof ItemDisplay) {
            this.manager.handleBaseEntityUnload(entity);
        } else if (BukkitFurnitureManager.COLLISION_ENTITY_CLASS.isInstance(entity)) {
            this.manager.handleCollisionEntityUnload(entity);
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onPlayerQuit(PlayerQuitEvent event) {
        Player player = event.getPlayer();
        Entity entity = player.getVehicle();
        if (entity == null) {
            return;
        }
        if (this.manager.isSeatCarrierType(entity)) {
            this.manager.tryLeavingSeat(player, entity);
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onPlayerDeath(PlayerDeathEvent event) {
        Player player = event.getPlayer();
        Entity entity = player.getVehicle();
        if (entity == null) {
            return;
        }
        if (this.manager.isSeatCarrierType(entity)) {
            this.manager.tryLeavingSeat(player, entity);
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.LOWEST)
    public void onInteractArmorStand(PlayerInteractAtEntityEvent event) {
        Entity clicked = event.getRightClicked();
        if (clicked instanceof ArmorStand) {
            ArmorStand armorStand = (ArmorStand)clicked;
            Integer baseFurniture = (Integer)armorStand.getPersistentDataContainer().get(BukkitFurnitureManager.FURNITURE_SEAT_BASE_ENTITY_KEY, PersistentDataType.INTEGER);
            if (baseFurniture == null) {
                return;
            }
            event.setCancelled(true);
        }
    }
}

