/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.bukkit.font;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.papermc.paper.event.player.AsyncChatCommandDecorateEvent;
import io.papermc.paper.event.player.AsyncChatDecorateEvent;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import net.momirealms.craftengine.bukkit.plugin.BukkitCraftEngine;
import net.momirealms.craftengine.bukkit.plugin.reflection.bukkit.CraftBukkitReflections;
import net.momirealms.craftengine.bukkit.plugin.reflection.paper.PaperReflections;
import net.momirealms.craftengine.bukkit.util.ComponentUtils;
import net.momirealms.craftengine.bukkit.util.LegacyInventoryUtils;
import net.momirealms.craftengine.core.entity.player.Player;
import net.momirealms.craftengine.core.font.AbstractFontManager;
import net.momirealms.craftengine.core.font.Emoji;
import net.momirealms.craftengine.core.font.EmojiComponentProcessResult;
import net.momirealms.craftengine.core.font.EmojiTextProcessResult;
import net.momirealms.craftengine.core.font.IllegalCharacterProcessResult;
import net.momirealms.craftengine.core.item.Item;
import net.momirealms.craftengine.core.plugin.config.Config;
import net.momirealms.craftengine.core.util.AdventureHelper;
import net.momirealms.craftengine.core.util.VersionHelper;
import net.momirealms.craftengine.libraries.adventure.text.Component;
import net.momirealms.craftengine.libraries.adventure.text.TextComponent;
import org.bukkit.Bukkit;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.block.SignChangeEvent;
import org.bukkit.event.inventory.PrepareAnvilEvent;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.bukkit.event.player.PlayerEditBookEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.BookMeta;
import org.bukkit.inventory.view.AnvilView;
import org.bukkit.plugin.Plugin;

public class BukkitFontManager
extends AbstractFontManager
implements Listener {
    private final BukkitCraftEngine plugin;

    public BukkitFontManager(BukkitCraftEngine plugin) {
        super(plugin);
        this.plugin = plugin;
    }

    @Override
    public void delayedInit() {
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)this.plugin.javaPlugin());
    }

    @Override
    public void disable() {
        super.disable();
        HandlerList.unregisterAll((Listener)this);
    }

    @Override
    public void delayedLoad() {
        Collection players = Bukkit.getOnlinePlayers();
        for (org.bukkit.entity.Player player : players) {
            this.removeEmojiSuggestions(player);
        }
        super.delayedLoad();
        for (org.bukkit.entity.Player player : players) {
            this.addEmojiSuggestions(player, this.getEmojiSuggestion(player));
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onPlayerJoin(PlayerJoinEvent event) {
        this.plugin.scheduler().async().execute(() -> this.addEmojiSuggestions(event.getPlayer(), this.getEmojiSuggestion(event.getPlayer())));
    }

    @Override
    public void refreshEmojiSuggestions(UUID uuid) {
        org.bukkit.entity.Player player = Bukkit.getPlayer((UUID)uuid);
        if (player == null) {
            return;
        }
        this.removeEmojiSuggestions(player);
        this.addEmojiSuggestions(player, this.getEmojiSuggestion(player));
    }

    private List<String> getEmojiSuggestion(org.bukkit.entity.Player player) {
        ArrayList<String> suggestions = new ArrayList<String>();
        for (Emoji emoji : this.emojiList) {
            if (emoji.permission() != null && !player.hasPermission(Objects.requireNonNull(emoji.permission()))) continue;
            suggestions.addAll(emoji.keywords());
        }
        return suggestions;
    }

    private void addEmojiSuggestions(org.bukkit.entity.Player player, List<String> suggestions) {
        player.addCustomChatCompletions(suggestions);
    }

    private void removeEmojiSuggestions(org.bukkit.entity.Player player) {
        if (this.allEmojiSuggestions != null) {
            player.removeCustomChatCompletions(this.allEmojiSuggestions);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onChat(AsyncChatDecorateEvent event) {
        if (!Config.filterChat()) {
            return;
        }
        this.processChatEvent(event);
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onChatCommand(AsyncChatCommandDecorateEvent event) {
        if (!Config.filterChat()) {
            return;
        }
        this.processChatEvent((AsyncChatDecorateEvent)event);
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onCommand(PlayerCommandPreprocessEvent event) {
        IllegalCharacterProcessResult result;
        org.bukkit.entity.Player player = event.getPlayer();
        if (!Config.filterCommand()) {
            return;
        }
        if (!player.hasPermission("craftengine.filter.bypass.command") && (result = this.processIllegalCharacters(event.getMessage())).has()) {
            event.setMessage(result.text());
        }
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void onAnvilRename(PrepareAnvilEvent event) {
        String renameText;
        org.bukkit.entity.Player player;
        if (!Config.allowEmojiAnvil() || this.emojiKeywordTrie == null) {
            return;
        }
        ItemStack result = event.getResult();
        if (result == null) {
            return;
        }
        try {
            player = (org.bukkit.entity.Player)CraftBukkitReflections.method$InventoryView$getPlayer.invoke(VersionHelper.isOrAbove1_21() ? event.getView() : LegacyInventoryUtils.getView(event), new Object[0]);
        }
        catch (ReflectiveOperationException e) {
            this.plugin.logger().warn("Failed to get inventory viewer", e);
            return;
        }
        if (VersionHelper.isOrAbove1_21_2()) {
            AnvilView anvilView = event.getView();
            renameText = anvilView.getRenameText();
        } else {
            renameText = LegacyInventoryUtils.getRenameText(event.getInventory());
        }
        if (renameText == null || renameText.isEmpty()) {
            return;
        }
        TextComponent itemName = Component.text((String)renameText);
        EmojiComponentProcessResult replaceProcessResult = this.replaceComponentEmoji((Component)itemName, (Player)this.plugin.adapt(player), renameText);
        if (replaceProcessResult.changed()) {
            Item<ItemStack> wrapped = this.plugin.itemManager().wrap(result);
            wrapped.customNameJson(AdventureHelper.componentToJson(replaceProcessResult.newText()));
            event.setResult(wrapped.getItem());
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onSignChange(SignChangeEvent event) {
        if (!Config.allowEmojiSign()) {
            return;
        }
        org.bukkit.entity.Player player = event.getPlayer();
        List lines = event.lines();
        for (int i = 0; i < lines.size(); ++i) {
            JsonElement json = ComponentUtils.paperAdventureToJsonElement(lines.get(i));
            if (json == null) continue;
            Component line = AdventureHelper.jsonElementToComponent(json);
            EmojiComponentProcessResult result = this.replaceComponentEmoji(line, this.plugin.adapt(player));
            if (result.changed()) {
                try {
                    PaperReflections.method$SignChangeEvent$line.invoke((Object)event, i, ComponentUtils.jsonElementToPaperAdventure(AdventureHelper.componentToJsonElement(result.newText())));
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    this.plugin.logger().warn("Failed to set sign line", e);
                }
                continue;
            }
            if (!AdventureHelper.isPureTextComponent(line)) continue;
            String plainText = AdventureHelper.plainTextContent(line);
            try {
                JsonObject jo = new JsonObject();
                jo.addProperty("text", plainText);
                PaperReflections.method$SignChangeEvent$line.invoke((Object)event, i, ComponentUtils.jsonElementToPaperAdventure((JsonElement)jo));
                continue;
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                this.plugin.logger().warn("Failed to reset sign line", e);
            }
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onPlayerEditBook(PlayerEditBookEvent event) {
        if (!event.isSigning()) {
            return;
        }
        if (!Config.allowEmojiBook()) {
            return;
        }
        org.bukkit.entity.Player player = event.getPlayer();
        BookMeta newBookMeta = event.getNewBookMeta();
        List pages = newBookMeta.pages();
        boolean changed = false;
        for (int i = 0; i < pages.size(); ++i) {
            JsonElement json = ComponentUtils.paperAdventureToJsonElement(pages.get(i));
            Component page = AdventureHelper.jsonElementToComponent(json);
            EmojiComponentProcessResult result = this.replaceComponentEmoji(page, this.plugin.adapt(player));
            if (!result.changed()) continue;
            changed = true;
            try {
                PaperReflections.method$BookMeta$page.invoke((Object)newBookMeta, i + 1, ComponentUtils.jsonElementToPaperAdventure(AdventureHelper.componentToJsonElement(result.newText())));
                continue;
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                this.plugin.logger().warn("Failed to set book page", e);
            }
        }
        if (changed) {
            event.setNewBookMeta(newBookMeta);
        }
    }

    private void processChatEvent(AsyncChatDecorateEvent event) {
        org.bukkit.entity.Player player = event.player();
        if (player == null) {
            return;
        }
        try {
            IllegalCharacterProcessResult result;
            Object originalMessage = PaperReflections.field$AsyncChatDecorateEvent$originalMessage.get(event);
            String rawJsonMessage = ComponentUtils.paperAdventureToJson(originalMessage);
            if (Config.allowEmojiChat()) {
                EmojiTextProcessResult processResult = this.replaceJsonEmoji(rawJsonMessage, this.plugin.adapt(player));
                boolean hasChanged = processResult.replaced();
                if (!player.hasPermission("craftengine.filter.bypass.chat")) {
                    IllegalCharacterProcessResult result2 = this.processIllegalCharacters(processResult.text());
                    if (result2.has()) {
                        Object component = ComponentUtils.jsonToPaperAdventure(result2.text());
                        PaperReflections.method$AsyncChatDecorateEvent$result.invoke((Object)event, component);
                    } else if (hasChanged) {
                        Object component = ComponentUtils.jsonToPaperAdventure(processResult.text());
                        PaperReflections.method$AsyncChatDecorateEvent$result.invoke((Object)event, component);
                    }
                } else if (hasChanged) {
                    Object component = ComponentUtils.jsonToPaperAdventure(processResult.text());
                    PaperReflections.method$AsyncChatDecorateEvent$result.invoke((Object)event, component);
                }
            } else if (!player.hasPermission("craftengine.filter.bypass.chat") && (result = this.processIllegalCharacters(rawJsonMessage)).has()) {
                Object component = ComponentUtils.jsonToPaperAdventure(result.text());
                PaperReflections.method$AsyncChatDecorateEvent$result.invoke((Object)event, component);
            }
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }
}

