/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.bukkit.item;

import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import net.momirealms.craftengine.bukkit.nms.FastNMS;
import net.momirealms.craftengine.bukkit.plugin.BukkitCraftEngine;
import net.momirealms.craftengine.core.item.AbstractCustomItem;
import net.momirealms.craftengine.core.item.CustomItem;
import net.momirealms.craftengine.core.item.Item;
import net.momirealms.craftengine.core.item.ItemBuildContext;
import net.momirealms.craftengine.core.item.ItemSettings;
import net.momirealms.craftengine.core.item.behavior.ItemBehavior;
import net.momirealms.craftengine.core.item.modifier.ItemDataModifier;
import net.momirealms.craftengine.core.plugin.context.PlayerOptionalContext;
import net.momirealms.craftengine.core.plugin.context.event.EventTrigger;
import net.momirealms.craftengine.core.plugin.context.function.Function;
import net.momirealms.craftengine.core.registry.Holder;
import net.momirealms.craftengine.core.util.Key;
import org.bukkit.inventory.ItemStack;

public class BukkitCustomItem
extends AbstractCustomItem<ItemStack> {
    private final Object item;
    private final Object clientItem;

    public BukkitCustomItem(Holder<Key> id, Object item, Object clientItem, Key materialKey, Key clientBoundMaterialKey, List<ItemBehavior> behaviors, List<ItemDataModifier<ItemStack>> modifiers, List<ItemDataModifier<ItemStack>> clientBoundModifiers, ItemSettings settings, Map<EventTrigger, List<Function<PlayerOptionalContext>>> events) {
        super(id, materialKey, clientBoundMaterialKey, behaviors, modifiers, clientBoundModifiers, settings, events);
        this.item = item;
        this.clientItem = clientItem;
    }

    @Override
    public ItemStack buildItemStack(ItemBuildContext context, int count) {
        ItemStack item = FastNMS.INSTANCE.method$CraftItemStack$asCraftMirror(FastNMS.INSTANCE.constructor$ItemStack(this.item, count));
        Item<ItemStack> wrapped = BukkitCraftEngine.instance().itemManager().wrap(item);
        for (ItemDataModifier modifier : this.modifiers) {
            modifier.apply(wrapped, context);
        }
        return wrapped.getItem();
    }

    @Override
    public Item<ItemStack> buildItem(ItemBuildContext context) {
        ItemStack item = FastNMS.INSTANCE.method$CraftItemStack$asCraftMirror(FastNMS.INSTANCE.constructor$ItemStack(this.item, 1));
        Item<ItemStack> wrapped = BukkitCraftEngine.instance().itemManager().wrap(item);
        for (ItemDataModifier<ItemStack> itemDataModifier : this.dataModifiers()) {
            itemDataModifier.apply(wrapped, context);
        }
        return BukkitCraftEngine.instance().itemManager().wrap(wrapped.getItem());
    }

    public Object clientItem() {
        return this.clientItem;
    }

    public Object item() {
        return this.item;
    }

    public static CustomItem.Builder<ItemStack> builder(Object item, Object clientBoundItem) {
        return new BuilderImpl(item, clientBoundItem);
    }

    public static class BuilderImpl
    implements CustomItem.Builder<ItemStack> {
        private Holder<Key> id;
        private Key itemKey;
        private final Object item;
        private Key clientBoundItemKey;
        private final Object clientBoundItem;
        private final Map<EventTrigger, List<Function<PlayerOptionalContext>>> events = new EnumMap<EventTrigger, List<Function<PlayerOptionalContext>>>(EventTrigger.class);
        private final List<ItemBehavior> behaviors = new ArrayList<ItemBehavior>(4);
        private final List<ItemDataModifier<ItemStack>> modifiers = new ArrayList<ItemDataModifier<ItemStack>>(4);
        private final List<ItemDataModifier<ItemStack>> clientBoundModifiers = new ArrayList<ItemDataModifier<ItemStack>>(4);
        private ItemSettings settings;

        public BuilderImpl(Object item, Object clientBoundItem) {
            this.item = item;
            this.clientBoundItem = clientBoundItem;
        }

        @Override
        public CustomItem.Builder<ItemStack> id(Holder<Key> id) {
            this.id = id;
            return this;
        }

        @Override
        public CustomItem.Builder<ItemStack> clientBoundMaterial(Key clientBoundMaterial) {
            this.clientBoundItemKey = clientBoundMaterial;
            return this;
        }

        @Override
        public CustomItem.Builder<ItemStack> material(Key material) {
            this.itemKey = material;
            return this;
        }

        @Override
        public CustomItem.Builder<ItemStack> dataModifier(ItemDataModifier<ItemStack> modifier) {
            this.modifiers.add(modifier);
            return this;
        }

        @Override
        public CustomItem.Builder<ItemStack> dataModifiers(List<ItemDataModifier<ItemStack>> modifiers) {
            this.modifiers.addAll(modifiers);
            return this;
        }

        @Override
        public CustomItem.Builder<ItemStack> clientBoundDataModifier(ItemDataModifier<ItemStack> modifier) {
            this.clientBoundModifiers.add(modifier);
            return this;
        }

        @Override
        public CustomItem.Builder<ItemStack> clientBoundDataModifiers(List<ItemDataModifier<ItemStack>> modifiers) {
            this.clientBoundModifiers.addAll(modifiers);
            return null;
        }

        @Override
        public CustomItem.Builder<ItemStack> behavior(ItemBehavior behavior) {
            this.behaviors.add(behavior);
            return this;
        }

        @Override
        public CustomItem.Builder<ItemStack> behaviors(List<ItemBehavior> behaviors) {
            this.behaviors.addAll(behaviors);
            return this;
        }

        @Override
        public CustomItem.Builder<ItemStack> settings(ItemSettings settings) {
            this.settings = settings;
            return this;
        }

        @Override
        public CustomItem.Builder<ItemStack> events(Map<EventTrigger, List<Function<PlayerOptionalContext>>> events) {
            this.events.putAll(events);
            return this;
        }

        @Override
        public CustomItem<ItemStack> build() {
            this.modifiers.addAll(this.settings.modifiers());
            return new BukkitCustomItem(this.id, this.item, this.clientBoundItem, this.itemKey, this.clientBoundItemKey, List.copyOf(this.behaviors), List.copyOf(this.modifiers), List.copyOf(this.clientBoundModifiers), this.settings, this.events);
        }
    }
}

