/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.bukkit.item;

import java.util.ArrayList;
import java.util.Optional;
import java.util.Set;
import net.momirealms.craftengine.bukkit.item.BukkitCustomItem;
import net.momirealms.craftengine.bukkit.item.CloneableConstantItem;
import net.momirealms.craftengine.bukkit.item.LegacyNetworkItemHandler;
import net.momirealms.craftengine.bukkit.item.ModernNetworkItemHandler;
import net.momirealms.craftengine.bukkit.item.behavior.AxeItemBehavior;
import net.momirealms.craftengine.bukkit.item.behavior.FlintAndSteelItemBehavior;
import net.momirealms.craftengine.bukkit.item.factory.BukkitItemFactory;
import net.momirealms.craftengine.bukkit.item.listener.ArmorEventListener;
import net.momirealms.craftengine.bukkit.item.listener.DebugStickListener;
import net.momirealms.craftengine.bukkit.item.listener.ItemEventListener;
import net.momirealms.craftengine.bukkit.nms.FastNMS;
import net.momirealms.craftengine.bukkit.plugin.BukkitCraftEngine;
import net.momirealms.craftengine.bukkit.plugin.reflection.minecraft.CoreReflections;
import net.momirealms.craftengine.bukkit.plugin.reflection.minecraft.MBuiltInRegistries;
import net.momirealms.craftengine.bukkit.plugin.reflection.minecraft.MRegistries;
import net.momirealms.craftengine.bukkit.util.ItemUtils;
import net.momirealms.craftengine.bukkit.util.KeyUtils;
import net.momirealms.craftengine.core.entity.player.Player;
import net.momirealms.craftengine.core.item.AbstractItemManager;
import net.momirealms.craftengine.core.item.BuildableItem;
import net.momirealms.craftengine.core.item.CustomItem;
import net.momirealms.craftengine.core.item.Item;
import net.momirealms.craftengine.core.item.ItemBuildContext;
import net.momirealms.craftengine.core.item.ItemKeys;
import net.momirealms.craftengine.core.item.ItemWrapper;
import net.momirealms.craftengine.core.item.NetworkItemHandler;
import net.momirealms.craftengine.core.plugin.config.Config;
import net.momirealms.craftengine.core.plugin.context.ContextHolder;
import net.momirealms.craftengine.core.plugin.locale.LocalizedResourceConfigException;
import net.momirealms.craftengine.core.registry.BuiltInRegistries;
import net.momirealms.craftengine.core.registry.Holder;
import net.momirealms.craftengine.core.registry.WritableRegistry;
import net.momirealms.craftengine.core.util.Key;
import net.momirealms.craftengine.core.util.ResourceKey;
import net.momirealms.craftengine.core.util.VersionHelper;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Registry;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.Nullable;

public class BukkitItemManager
extends AbstractItemManager<ItemStack> {
    private static BukkitItemManager instance;
    private final BukkitItemFactory<? extends ItemWrapper<ItemStack>> factory;
    private final BukkitCraftEngine plugin;
    private final ItemEventListener itemEventListener;
    private final DebugStickListener debugStickListener;
    private final ArmorEventListener armorEventListener;
    private final NetworkItemHandler<ItemStack> networkItemHandler;

    public BukkitItemManager(BukkitCraftEngine plugin) {
        super(plugin);
        instance = this;
        this.plugin = plugin;
        this.factory = BukkitItemFactory.create(plugin);
        this.itemEventListener = new ItemEventListener(plugin);
        this.debugStickListener = new DebugStickListener(plugin);
        this.armorEventListener = new ArmorEventListener();
        this.networkItemHandler = VersionHelper.isOrAbove1_20_5() ? new ModernNetworkItemHandler() : new LegacyNetworkItemHandler();
        this.registerAllVanillaItems();
    }

    @Override
    public void delayedInit() {
        Bukkit.getPluginManager().registerEvents((Listener)this.itemEventListener, (Plugin)this.plugin.javaPlugin());
        Bukkit.getPluginManager().registerEvents((Listener)this.debugStickListener, (Plugin)this.plugin.javaPlugin());
        Bukkit.getPluginManager().registerEvents((Listener)this.armorEventListener, (Plugin)this.plugin.javaPlugin());
    }

    @Override
    public NetworkItemHandler<ItemStack> networkItemHandler() {
        return this.networkItemHandler;
    }

    public static BukkitItemManager instance() {
        return instance;
    }

    public Optional<ItemStack> s2c(ItemStack itemStack, Player player) {
        try {
            Item<ItemStack> wrapped = this.wrap(itemStack);
            if (wrapped == null) {
                return Optional.empty();
            }
            return this.networkItemHandler.s2c(wrapped, player).map(Item::getItem);
        }
        catch (Throwable e) {
            if (Config.debug()) {
                this.plugin.logger().warn("Failed to handle s2c items.", e);
            }
            return Optional.empty();
        }
    }

    public Optional<ItemStack> c2s(ItemStack itemStack) {
        try {
            Item<ItemStack> wrapped = this.wrap(itemStack);
            if (wrapped == null) {
                return Optional.empty();
            }
            return this.networkItemHandler.c2s(wrapped).map(Item::getItem);
        }
        catch (Throwable e) {
            if (Config.debug()) {
                this.plugin.logger().warn("Failed to handle c2s items.", e);
            }
            return Optional.empty();
        }
    }

    @Override
    public Optional<BuildableItem<ItemStack>> getVanillaItem(Key key) {
        Material material = (Material)Registry.MATERIAL.get(KeyUtils.toNamespacedKey(key));
        if (material == null) {
            return Optional.empty();
        }
        return Optional.of(new CloneableConstantItem(key, new ItemStack(material)));
    }

    @Override
    public int fuelTime(ItemStack itemStack) {
        if (ItemUtils.isEmpty(itemStack)) {
            return 0;
        }
        Optional<CustomItem<ItemStack>> customItem = this.wrap(itemStack).getCustomItem();
        return customItem.map(it -> it.settings().fuelTime()).orElse(0);
    }

    @Override
    public int fuelTime(Key id) {
        return this.getCustomItem(id).map(it -> it.settings().fuelTime()).orElse(0);
    }

    @Override
    public void disable() {
        this.unload();
        HandlerList.unregisterAll((Listener)this.itemEventListener);
        HandlerList.unregisterAll((Listener)this.debugStickListener);
        HandlerList.unregisterAll((Listener)this.armorEventListener);
    }

    @Override
    public Item<ItemStack> fromByteArray(byte[] bytes) {
        return this.factory.wrap(Bukkit.getUnsafe().deserializeItem(bytes));
    }

    @Override
    public ItemStack buildCustomItemStack(Key id, Player player) {
        return Optional.ofNullable((CustomItem)this.customItems.get(id)).map(it -> (ItemStack)it.buildItemStack(new ItemBuildContext(player, ContextHolder.EMPTY), 1)).orElse(null);
    }

    @Override
    public ItemStack buildItemStack(Key id, @Nullable Player player) {
        return Optional.ofNullable(this.buildCustomItemStack(id, player)).orElseGet(() -> this.createVanillaItemStack(id));
    }

    @Override
    public Item<ItemStack> createCustomWrappedItem(Key id, Player player) {
        return Optional.ofNullable((CustomItem)this.customItems.get(id)).map(it -> it.buildItem(player)).orElse(null);
    }

    private ItemStack createVanillaItemStack(Key id) {
        NamespacedKey key = NamespacedKey.fromString((String)id.toString());
        if (key == null) {
            this.plugin.logger().warn(String.valueOf(id) + " is not a valid namespaced key");
            return new ItemStack(Material.AIR);
        }
        Object item = FastNMS.INSTANCE.method$Registry$getValue(MBuiltInRegistries.ITEM, KeyUtils.toResourceLocation(id));
        if (item == null) {
            this.plugin.logger().warn(String.valueOf(id) + " is not a valid material");
            return new ItemStack(Material.AIR);
        }
        return FastNMS.INSTANCE.method$CraftItemStack$asCraftMirror(FastNMS.INSTANCE.constructor$ItemStack(item, 1));
    }

    @Override
    public Item<ItemStack> createWrappedItem(Key id, @Nullable Player player) {
        return Optional.ofNullable((CustomItem)this.customItems.get(id)).map(it -> it.buildItem(player)).orElseGet(() -> {
            ItemStack itemStack = this.createVanillaItemStack(id);
            return this.wrap(itemStack);
        });
    }

    @Override
    public Item<ItemStack> wrap(ItemStack itemStack) {
        if (ItemUtils.isEmpty(itemStack)) {
            return null;
        }
        return this.factory.wrap(itemStack);
    }

    @Override
    public Key itemId(ItemStack itemStack) {
        Item<ItemStack> wrapped = this.wrap(itemStack);
        return wrapped.id();
    }

    @Override
    public Key customItemId(ItemStack itemStack) {
        Item<ItemStack> wrapped = this.wrap(itemStack);
        if (!wrapped.hasTag("craftengine:id")) {
            return null;
        }
        return wrapped.id();
    }

    @Override
    protected CustomItem.Builder<ItemStack> createPlatformItemBuilder(Holder<Key> id, Key materialId, Key clientBoundMaterialId) {
        Object clientBoundItem;
        Object item = FastNMS.INSTANCE.method$Registry$getValue(MBuiltInRegistries.ITEM, KeyUtils.toResourceLocation(materialId));
        Object object = clientBoundItem = materialId == clientBoundMaterialId ? item : FastNMS.INSTANCE.method$Registry$getValue(MBuiltInRegistries.ITEM, KeyUtils.toResourceLocation(clientBoundMaterialId));
        if (item == null) {
            throw new LocalizedResourceConfigException("warning.config.item.invalid_material", materialId.toString());
        }
        if (clientBoundItem == null) {
            throw new LocalizedResourceConfigException("warning.config.item.invalid_material", clientBoundMaterialId.toString());
        }
        return BukkitCustomItem.builder(item, clientBoundItem).id(id).material(materialId).clientBoundMaterial(clientBoundMaterialId);
    }

    private void registerAllVanillaItems() {
        try {
            for (Object item : (Iterable)MBuiltInRegistries.ITEM) {
                Object resourceLocation = FastNMS.INSTANCE.method$Registry$getKey(MBuiltInRegistries.ITEM, item);
                Key itemKey = KeyUtils.resourceLocationToKey(resourceLocation);
                if (!itemKey.namespace().equals("minecraft")) continue;
                VANILLA_ITEMS.add(itemKey);
                Holder.Reference holder = BuiltInRegistries.OPTIMIZED_ITEM_ID.get(itemKey).orElseGet(() -> ((WritableRegistry)BuiltInRegistries.OPTIMIZED_ITEM_ID).register(new ResourceKey(BuiltInRegistries.OPTIMIZED_ITEM_ID.key().location(), itemKey), itemKey));
                Object mcHolder = ((Optional)CoreReflections.method$Registry$getHolder1.invoke(MBuiltInRegistries.ITEM, CoreReflections.method$ResourceKey$create.invoke(null, MRegistries.ITEM, resourceLocation))).get();
                Set tags = (Set)CoreReflections.field$Holder$Reference$tags.get(mcHolder);
                for (Object tag : tags) {
                    Key tagId = Key.of(CoreReflections.field$TagKey$location.get(tag).toString());
                    VANILLA_ITEM_TAGS.computeIfAbsent(tagId, key -> new ArrayList()).add(holder);
                }
            }
        }
        catch (ReflectiveOperationException e) {
            this.plugin.logger().warn("Failed to init vanilla items", e);
        }
    }

    static {
        BukkitItemManager.registerVanillaItemExtraBehavior(FlintAndSteelItemBehavior.INSTANCE, ItemKeys.FLINT_AND_STEEL);
        BukkitItemManager.registerVanillaItemExtraBehavior(AxeItemBehavior.INSTANCE, ItemKeys.AXES);
    }
}

