/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.bukkit.item;

import net.momirealms.craftengine.bukkit.nms.FastNMS;
import net.momirealms.craftengine.bukkit.plugin.reflection.minecraft.CoreReflections;
import net.momirealms.craftengine.bukkit.plugin.reflection.minecraft.MRegistryOps;
import net.momirealms.craftengine.bukkit.util.ItemUtils;
import net.momirealms.craftengine.core.item.ItemWrapper;
import net.momirealms.craftengine.libraries.nbt.Tag;
import org.bukkit.inventory.ItemStack;

public class LegacyItemWrapper
implements ItemWrapper<ItemStack> {
    private final Object nmsStack;
    private final ItemStack itemStack;

    public LegacyItemWrapper(ItemStack item) {
        this.itemStack = ItemUtils.ensureCraftItemStack(item);
        this.nmsStack = FastNMS.INSTANCE.field$CraftItemStack$handle(this.itemStack);
    }

    public boolean setTag(Object value, Object ... path) {
        Object finalNMSTag;
        if (value instanceof Tag) {
            Tag tag = (Tag)value;
            finalNMSTag = MRegistryOps.SPARROW_NBT.convertTo(MRegistryOps.NBT, (Object)tag);
        } else {
            finalNMSTag = MRegistryOps.JAVA.convertTo(MRegistryOps.NBT, value);
        }
        Object currentTag = FastNMS.INSTANCE.field$ItemStack$getOrCreateTag(this.nmsStack);
        if (path == null || path.length == 0) {
            if (CoreReflections.clazz$CompoundTag.isInstance(finalNMSTag)) {
                FastNMS.INSTANCE.method$ItemStack$setTag(this.nmsStack, finalNMSTag);
                return true;
            }
            return false;
        }
        for (int i = 0; i < path.length - 1; ++i) {
            Object pathSegment = path[i];
            if (pathSegment == null) {
                return false;
            }
            Object childTag = FastNMS.INSTANCE.method$CompoundTag$get(currentTag, pathSegment.toString());
            if (!CoreReflections.clazz$CompoundTag.isInstance(childTag)) {
                childTag = FastNMS.INSTANCE.constructor$CompoundTag();
                FastNMS.INSTANCE.method$CompoundTag$put(currentTag, pathSegment.toString(), childTag);
            }
            currentTag = childTag;
        }
        String finalKey = path[path.length - 1].toString();
        FastNMS.INSTANCE.method$CompoundTag$put(currentTag, finalKey, finalNMSTag);
        return true;
    }

    public <V> V getJavaTag(Object ... path) {
        Object tag = this.getExactTag(path);
        if (tag == null) {
            return null;
        }
        return (V)MRegistryOps.NBT.convertTo(MRegistryOps.JAVA, tag);
    }

    public Tag getNBTTag(Object ... path) {
        Object tag = this.getExactTag(path);
        if (tag == null) {
            return null;
        }
        return (Tag)MRegistryOps.NBT.convertTo(MRegistryOps.SPARROW_NBT, tag);
    }

    @Override
    public int count() {
        return this.getItem().getAmount();
    }

    @Override
    public void count(int amount) {
        if (amount < 0) {
            amount = 0;
        }
        this.getItem().setAmount(amount);
    }

    public Object getExactTag(Object ... path) {
        Object compoundTag = FastNMS.INSTANCE.method$ItemStack$getTag(this.nmsStack);
        if (compoundTag == null) {
            return null;
        }
        Object currentTag = compoundTag;
        for (int i = 0; i < path.length; ++i) {
            Object pathSegment = path[i];
            if (pathSegment == null) {
                return null;
            }
            if ((currentTag = FastNMS.INSTANCE.method$CompoundTag$get(currentTag, path[i].toString())) == null) {
                return null;
            }
            if (i == path.length - 1) {
                return currentTag;
            }
            if (CoreReflections.clazz$CompoundTag.isInstance(currentTag)) continue;
            return null;
        }
        return null;
    }

    public boolean remove(Object ... path) {
        String key;
        Object compoundTag = FastNMS.INSTANCE.method$ItemStack$getTag(this.nmsStack);
        if (compoundTag == null || path == null || path.length == 0) {
            return false;
        }
        if (path.length == 1 && FastNMS.INSTANCE.method$CompoundTag$get(compoundTag, key = path[0].toString()) != null) {
            FastNMS.INSTANCE.method$CompoundTag$remove(compoundTag, key);
            return true;
        }
        Object currentTag = compoundTag;
        for (int i = 0; i < path.length - 1; ++i) {
            Object pathSegment = path[i];
            if (pathSegment == null) {
                return false;
            }
            if (CoreReflections.clazz$CompoundTag.isInstance(currentTag = FastNMS.INSTANCE.method$CompoundTag$get(currentTag, path[i].toString()))) continue;
            return false;
        }
        String finalKey = path[path.length - 1].toString();
        if (FastNMS.INSTANCE.method$CompoundTag$get(currentTag, finalKey) != null) {
            FastNMS.INSTANCE.method$CompoundTag$remove(currentTag, finalKey);
            return true;
        }
        return false;
    }

    public boolean hasTag(Object ... path) {
        return this.getExactTag(path) != null;
    }

    @Override
    public ItemStack getItem() {
        return this.itemStack;
    }

    @Override
    public Object getLiteralObject() {
        return this.nmsStack;
    }

    @Override
    public ItemWrapper<ItemStack> copyWithCount(int count) {
        ItemStack copied = this.itemStack.clone();
        copied.setAmount(count);
        return new LegacyItemWrapper(copied);
    }

    @Override
    public void shrink(int amount) {
        this.count(this.count() - amount);
    }
}

